/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class NBTTagLongArray
extends NBTList<NBTTagLong> {
    private static final int b = 24;
    public static final NBTTagType<NBTTagLongArray> a = new NBTTagType.b<NBTTagLongArray>(){

        public NBTTagLongArray a(DataInput input, NBTReadLimiter accounter) throws IOException {
            return new NBTTagLongArray(1.d(input, accounter));
        }

        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            return visitor.a(1.d(input, accounter));
        }

        private static long[] d(DataInput input, NBTReadLimiter accounter) throws IOException {
            accounter.b(24L);
            int _int = input.readInt();
            accounter.a(8L, _int);
            long[] longs = new long[_int];
            for (int i2 = 0; i2 < _int; ++i2) {
                longs[i2] = input.readLong();
            }
            return longs;
        }

        @Override
        public void b(DataInput input, NBTReadLimiter accounter) throws IOException {
            input.skipBytes(input.readInt() * 8);
        }

        @Override
        public String a() {
            return "LONG[]";
        }

        @Override
        public String b() {
            return "TAG_Long_Array";
        }
    };
    private long[] c;

    public NBTTagLongArray(long[] data) {
        this.c = data;
    }

    public NBTTagLongArray(LongSet dataSet) {
        this.c = dataSet.toLongArray();
    }

    public NBTTagLongArray(List<Long> data) {
        this(NBTTagLongArray.a(data));
    }

    private static long[] a(List<Long> dataList) {
        long[] longs = new long[dataList.size()];
        for (int i2 = 0; i2 < dataList.size(); ++i2) {
            Long _long = dataList.get(i2);
            longs[i2] = _long == null ? 0L : _long;
        }
        return longs;
    }

    @Override
    public void a(DataOutput output) throws IOException {
        output.writeInt(this.c.length);
        for (long l2 : this.c) {
            output.writeLong(l2);
        }
    }

    @Override
    public int a() {
        return 24 + 8 * this.c.length;
    }

    @Override
    public byte b() {
        return 12;
    }

    public NBTTagType<NBTTagLongArray> c() {
        return a;
    }

    @Override
    public String toString() {
        return this.u_();
    }

    public NBTTagLongArray e() {
        long[] longs = new long[this.c.length];
        System.arraycopy(this.c, 0, longs, 0, this.c.length);
        return new NBTTagLongArray(longs);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof NBTTagLongArray && Arrays.equals(this.c, ((NBTTagLongArray)other).c);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.c);
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    public long[] g() {
        return this.c;
    }

    @Override
    public int size() {
        return this.c.length;
    }

    public NBTTagLong a(int index) {
        return NBTTagLong.a(this.c[index]);
    }

    public NBTTagLong a(int index, NBTTagLong tag) {
        long l2 = this.c[index];
        this.c[index] = tag.f();
        return NBTTagLong.a(l2);
    }

    public void b(int index, NBTTagLong tag) {
        this.c = ArrayUtils.add((long[])this.c, (int)index, (long)tag.f());
    }

    @Override
    public boolean a(int index, NBTBase nbt) {
        if (nbt instanceof NBTNumber) {
            this.c[index] = ((NBTNumber)nbt).f();
            return true;
        }
        return false;
    }

    @Override
    public boolean b(int index, NBTBase nbt) {
        if (nbt instanceof NBTNumber) {
            this.c = ArrayUtils.add((long[])this.c, (int)index, (long)((NBTNumber)nbt).f());
            return true;
        }
        return false;
    }

    public NBTTagLong b(int index) {
        long l2 = this.c[index];
        this.c = ArrayUtils.remove((long[])this.c, (int)index);
        return NBTTagLong.a(l2);
    }

    @Override
    public byte f() {
        return 4;
    }

    @Override
    public void clear() {
        this.c = new long[0];
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.c);
    }
}

