/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagList
extends NBTList<NBTBase> {
    private static final int b = 37;
    public static final NBTTagType<NBTTagList> a = new NBTTagType.b<NBTTagList>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NBTTagList a(DataInput input, NBTReadLimiter accounter) throws IOException {
            NBTTagList var3;
            accounter.b();
            try {
                var3 = 1.d(input, accounter);
            }
            finally {
                accounter.c();
            }
            return var3;
        }

        private static NBTTagList d(DataInput input, NBTReadLimiter accounter) throws IOException {
            accounter.b(37L);
            byte _byte = input.readByte();
            int _int = input.readInt();
            if (_byte == 0 && _int > 0) {
                throw new NbtFormatException("Missing type on ListTag");
            }
            accounter.a(4L, _int);
            NBTTagType<?> type = NBTTagTypes.a(_byte);
            ArrayList list = Lists.newArrayListWithCapacity((int)_int);
            for (int i2 = 0; i2 < _int; ++i2) {
                list.add(type.c(input, accounter));
            }
            return new NBTTagList(list, _byte);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            StreamTagVisitor.b var4;
            accounter.b();
            try {
                var4 = 1.c(input, visitor, accounter);
            }
            finally {
                accounter.c();
            }
            return var4;
        }

        private static StreamTagVisitor.b c(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            accounter.b(37L);
            NBTTagType<?> type = NBTTagTypes.a(input.readByte());
            int _int = input.readInt();
            switch (visitor.a(type, _int)) {
                case c: {
                    return StreamTagVisitor.b.c;
                }
                case b: {
                    type.a(input, _int, accounter);
                    return visitor.b();
                }
            }
            accounter.a(4L, _int);
            int i2 = 0;
            while (true) {
                block16: {
                    int i1;
                    block15: {
                        if (i2 >= _int) break block15;
                        block4 : switch (visitor.b(type, i2)) {
                            case d: {
                                return StreamTagVisitor.b.c;
                            }
                            case c: {
                                type.b(input, accounter);
                                break;
                            }
                            case b: {
                                type.b(input, accounter);
                                break block16;
                            }
                            default: {
                                switch (type.a(input, visitor, accounter)) {
                                    case c: {
                                        return StreamTagVisitor.b.c;
                                    }
                                    case b: {
                                        break block4;
                                    }
                                }
                                break block16;
                            }
                        }
                    }
                    if ((i1 = _int - 1 - i2) > 0) {
                        type.a(input, i1, accounter);
                    }
                    return visitor.b();
                }
                ++i2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void b(DataInput input, NBTReadLimiter accounter) throws IOException {
            accounter.b();
            try {
                NBTTagType<?> type = NBTTagTypes.a(input.readByte());
                int _int = input.readInt();
                type.a(input, _int, accounter);
            }
            finally {
                accounter.c();
            }
        }

        @Override
        public String a() {
            return "LIST";
        }

        @Override
        public String b() {
            return "TAG_List";
        }
    };
    private final List<NBTBase> c;
    private byte w;

    public NBTTagList(List<NBTBase> list, byte type) {
        this.c = list;
        this.w = type;
    }

    public NBTTagList() {
        this(Lists.newArrayList(), 0);
    }

    @Override
    public void a(DataOutput output) throws IOException {
        this.w = this.c.isEmpty() ? (byte)0 : this.c.get(0).b();
        output.writeByte(this.w);
        output.writeInt(this.c.size());
        for (NBTBase tag : this.c) {
            tag.a(output);
        }
    }

    @Override
    public int a() {
        int i2 = 37;
        i2 += 4 * this.c.size();
        for (NBTBase tag : this.c) {
            i2 += tag.a();
        }
        return i2;
    }

    @Override
    public byte b() {
        return 9;
    }

    public NBTTagType<NBTTagList> c() {
        return a;
    }

    @Override
    public String toString() {
        return this.u_();
    }

    private void g() {
        if (this.c.isEmpty()) {
            this.w = 0;
        }
    }

    @Override
    public NBTBase c(int index) {
        NBTBase tag = this.c.remove(index);
        this.g();
        return tag;
    }

    @Override
    public boolean isEmpty() {
        return this.c.isEmpty();
    }

    public NBTTagCompound a(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).b() == 10) {
            return (NBTTagCompound)tag;
        }
        return new NBTTagCompound();
    }

    public NBTTagList b(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).b() == 9) {
            return (NBTTagList)tag;
        }
        return new NBTTagList();
    }

    public short d(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).b() == 2) {
            return ((NBTTagShort)tag).h();
        }
        return 0;
    }

    public int e(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).b() == 3) {
            return ((NBTTagInt)tag).g();
        }
        return 0;
    }

    public int[] f(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).b() == 11) {
            return ((NBTTagIntArray)tag).g();
        }
        return new int[0];
    }

    public long[] g(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).b() == 12) {
            return ((NBTTagLongArray)tag).g();
        }
        return new long[0];
    }

    public double h(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).b() == 6) {
            return ((NBTTagDouble)tag).j();
        }
        return 0.0;
    }

    public float i(int index) {
        NBTBase tag;
        if (index >= 0 && index < this.c.size() && (tag = this.c.get(index)).b() == 5) {
            return ((NBTTagFloat)tag).k();
        }
        return 0.0f;
    }

    public String j(int index) {
        if (index >= 0 && index < this.c.size()) {
            NBTBase tag = this.c.get(index);
            return tag.b() == 8 ? tag.u_() : tag.toString();
        }
        return "";
    }

    @Override
    public int size() {
        return this.c.size();
    }

    public NBTBase k(int index) {
        return this.c.get(index);
    }

    @Override
    public NBTBase d(int index, NBTBase tag) {
        NBTBase tag1 = this.k(index);
        if (!this.a(index, tag)) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "Trying to add tag of type %d to list of %d", tag.b(), this.w));
        }
        return tag1;
    }

    @Override
    public void c(int index, NBTBase tag) {
        if (!this.b(index, tag)) {
            throw new UnsupportedOperationException(String.format(Locale.ROOT, "Trying to add tag of type %d to list of %d", tag.b(), this.w));
        }
    }

    @Override
    public boolean a(int index, NBTBase nbt) {
        if (this.a(nbt)) {
            this.c.set(index, nbt);
            return true;
        }
        return false;
    }

    @Override
    public boolean b(int index, NBTBase nbt) {
        if (this.a(nbt)) {
            this.c.add(index, nbt);
            return true;
        }
        return false;
    }

    private boolean a(NBTBase tag) {
        if (tag.b() == 0) {
            return false;
        }
        if (this.w == 0) {
            this.w = tag.b();
            return true;
        }
        return this.w == tag.b();
    }

    public NBTTagList e() {
        List<NBTBase> iterable = NBTTagTypes.a(this.w).d() ? this.c : Iterables.transform(this.c, NBTBase::d);
        ArrayList list = Lists.newArrayList(iterable);
        return new NBTTagList(list, this.w);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof NBTTagList && Objects.equals(this.c, ((NBTTagList)other).c);
    }

    @Override
    public int hashCode() {
        return this.c.hashCode();
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    @Override
    public byte f() {
        return this.w;
    }

    @Override
    public void clear() {
        this.c.clear();
        this.w = 0;
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        switch (visitor.a(NBTTagTypes.a(this.w), this.c.size())) {
            case c: {
                return StreamTagVisitor.b.c;
            }
            case b: {
                return visitor.b();
            }
        }
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            NBTBase tag = this.c.get(i2);
            switch (visitor.b(tag.c(), i2)) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return visitor.b();
                }
                default: {
                    switch (tag.a(visitor)) {
                        case c: {
                            return StreamTagVisitor.b.c;
                        }
                        case b: {
                            return visitor.b();
                        }
                    }
                }
                case b: 
            }
        }
        return visitor.b();
    }
}

