/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.util.MathHelper;

public class NBTTagFloat
extends NBTNumber {
    private static final int c = 12;
    public static final NBTTagFloat a = new NBTTagFloat(0.0f);
    public static final NBTTagType<NBTTagFloat> b = new NBTTagType.a<NBTTagFloat>(){

        public NBTTagFloat a(DataInput input, NBTReadLimiter accounter) throws IOException {
            return NBTTagFloat.a(1.d(input, accounter));
        }

        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            return visitor.a(1.d(input, accounter));
        }

        private static float d(DataInput input, NBTReadLimiter accounter) throws IOException {
            accounter.b(12L);
            return input.readFloat();
        }

        @Override
        public int c() {
            return 4;
        }

        @Override
        public String a() {
            return "FLOAT";
        }

        @Override
        public String b() {
            return "TAG_Float";
        }

        @Override
        public boolean d() {
            return true;
        }
    };
    private final float w;

    private NBTTagFloat(float data) {
        this.w = data;
    }

    public static NBTTagFloat a(float data) {
        return data == 0.0f ? a : new NBTTagFloat(data);
    }

    @Override
    public void a(DataOutput output) throws IOException {
        output.writeFloat(this.w);
    }

    @Override
    public int a() {
        return 12;
    }

    @Override
    public byte b() {
        return 5;
    }

    public NBTTagType<NBTTagFloat> c() {
        return b;
    }

    public NBTTagFloat e() {
        return this;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NBTTagFloat && this.w == ((NBTTagFloat)other).w;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.w);
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    @Override
    public long f() {
        return (long)this.w;
    }

    @Override
    public int g() {
        return MathHelper.d(this.w);
    }

    @Override
    public short h() {
        return (short)(MathHelper.d(this.w) & 0xFFFF);
    }

    @Override
    public byte i() {
        return (byte)(MathHelper.d(this.w) & 0xFF);
    }

    @Override
    public double j() {
        return this.w;
    }

    @Override
    public float k() {
        return this.w;
    }

    @Override
    public Number l() {
        return Float.valueOf(this.w);
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.w);
    }
}

