/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import net.minecraft.util.MathHelper;

public class NBTTagDouble
extends NBTNumber {
    private static final int c = 16;
    public static final NBTTagDouble a = new NBTTagDouble(0.0);
    public static final NBTTagType<NBTTagDouble> b = new NBTTagType.a<NBTTagDouble>(){

        public NBTTagDouble a(DataInput input, NBTReadLimiter accounter) throws IOException {
            return NBTTagDouble.a(1.d(input, accounter));
        }

        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            return visitor.a(1.d(input, accounter));
        }

        private static double d(DataInput input, NBTReadLimiter accounter) throws IOException {
            accounter.b(16L);
            return input.readDouble();
        }

        @Override
        public int c() {
            return 8;
        }

        @Override
        public String a() {
            return "DOUBLE";
        }

        @Override
        public String b() {
            return "TAG_Double";
        }

        @Override
        public boolean d() {
            return true;
        }
    };
    private final double w;

    private NBTTagDouble(double data) {
        this.w = data;
    }

    public static NBTTagDouble a(double data) {
        return data == 0.0 ? a : new NBTTagDouble(data);
    }

    @Override
    public void a(DataOutput output) throws IOException {
        output.writeDouble(this.w);
    }

    @Override
    public int a() {
        return 16;
    }

    @Override
    public byte b() {
        return 6;
    }

    public NBTTagType<NBTTagDouble> c() {
        return b;
    }

    public NBTTagDouble e() {
        return this;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NBTTagDouble && this.w == ((NBTTagDouble)other).w;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.w);
        return (int)(l2 ^ l2 >>> 32);
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    @Override
    public long f() {
        return (long)Math.floor(this.w);
    }

    @Override
    public int g() {
        return MathHelper.a(this.w);
    }

    @Override
    public short h() {
        return (short)(MathHelper.a(this.w) & 0xFFFF);
    }

    @Override
    public byte i() {
        return (byte)(MathHelper.a(this.w) & 0xFF);
    }

    @Override
    public double j() {
        return this.w;
    }

    @Override
    public float k() {
        return (float)this.w;
    }

    @Override
    public Number l() {
        return this.w;
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        return visitor.a(this.w);
    }
}

