/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagCompound
implements NBTBase {
    public static final Codec<NBTTagCompound> a = Codec.PASSTHROUGH.comapFlatMap(compoundTag -> {
        NBTTagCompound compoundTag1;
        NBTBase tag = compoundTag.convert(DynamicOpsNBT.a).getValue();
        return tag instanceof NBTTagCompound ? DataResult.success((Object)((compoundTag1 = (NBTTagCompound)tag) == compoundTag.getValue() ? compoundTag1.i() : compoundTag1)) : DataResult.error(() -> "Not a compound tag: " + String.valueOf(tag));
    }, compoundTag -> new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, compoundTag.i()));
    private static final int c = 48;
    private static final int w = 32;
    public static final NBTTagType<NBTTagCompound> b = new NBTTagType.b<NBTTagCompound>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NBTTagCompound a(DataInput input, NBTReadLimiter accounter) throws IOException {
            NBTTagCompound var3;
            accounter.b();
            try {
                var3 = 1.d(input, accounter);
            }
            finally {
                accounter.c();
            }
            return var3;
        }

        private static NBTTagCompound d(DataInput input, NBTReadLimiter nbtAccounter) throws IOException {
            byte b2;
            nbtAccounter.b(48L);
            Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(8, 0.8f);
            while ((b2 = input.readByte()) != 0) {
                NBTBase namedTagData;
                String string = 1.e(input, nbtAccounter);
                if (map.put((Object)string, (Object)(namedTagData = NBTTagCompound.a(NBTTagTypes.a(b2), string, input, nbtAccounter))) != null) continue;
                nbtAccounter.b(36L);
            }
            return new NBTTagCompound((Map<String, NBTBase>)map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.b a(DataInput input, StreamTagVisitor visitor, NBTReadLimiter accounter) throws IOException {
            StreamTagVisitor.b var4;
            accounter.b();
            try {
                var4 = 1.c(input, visitor, accounter);
            }
            finally {
                accounter.c();
            }
            return var4;
        }

        private static StreamTagVisitor.b c(DataInput input, StreamTagVisitor visitor, NBTReadLimiter nbtAccounter) throws IOException {
            byte b2;
            nbtAccounter.b(48L);
            block13: while ((b2 = input.readByte()) != 0) {
                NBTTagType<?> type = NBTTagTypes.a(b2);
                switch (visitor.a(type)) {
                    case d: {
                        return StreamTagVisitor.b.c;
                    }
                    case c: {
                        NBTTagString.a(input);
                        type.b(input, nbtAccounter);
                        break block13;
                    }
                    case b: {
                        NBTTagString.a(input);
                        type.b(input, nbtAccounter);
                        continue block13;
                    }
                    default: {
                        String string = 1.e(input, nbtAccounter);
                        switch (visitor.a(type, string)) {
                            case d: {
                                return StreamTagVisitor.b.c;
                            }
                            case c: {
                                type.b(input, nbtAccounter);
                                break block13;
                            }
                            case b: {
                                type.b(input, nbtAccounter);
                                continue block13;
                            }
                        }
                        nbtAccounter.b(36L);
                        switch (type.a(input, visitor, nbtAccounter)) {
                            case c: {
                                return StreamTagVisitor.b.c;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if (b2 != 0) {
                while ((b2 = input.readByte()) != 0) {
                    NBTTagString.a(input);
                    NBTTagTypes.a(b2).b(input, nbtAccounter);
                }
            }
            return visitor.b();
        }

        private static String e(DataInput input, NBTReadLimiter accounter) throws IOException {
            String utf = input.readUTF();
            accounter.b(28L);
            accounter.a(2L, utf.length());
            return utf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void b(DataInput input, NBTReadLimiter accounter) throws IOException {
            accounter.b();
            try {
                byte b2;
                while ((b2 = input.readByte()) != 0) {
                    NBTTagString.a(input);
                    NBTTagTypes.a(b2).b(input, accounter);
                }
            }
            finally {
                accounter.c();
            }
        }

        @Override
        public String a() {
            return "COMPOUND";
        }

        @Override
        public String b() {
            return "TAG_Compound";
        }
    };
    private final Map<String, NBTBase> x;

    protected NBTTagCompound(Map<String, NBTBase> tags) {
        this.x = tags;
    }

    public NBTTagCompound() {
        this((Map<String, NBTBase>)new Object2ObjectOpenHashMap(8, 0.8f));
    }

    @Override
    public void a(DataOutput output) throws IOException {
        for (String string : this.x.keySet()) {
            NBTBase tag = this.x.get(string);
            NBTTagCompound.a(string, tag, output);
        }
        output.writeByte(0);
    }

    @Override
    public int a() {
        int i2 = 48;
        for (Map.Entry<String, NBTBase> entry : this.x.entrySet()) {
            i2 += 28 + 2 * entry.getKey().length();
            i2 += 36;
            i2 += entry.getValue().a();
        }
        return i2;
    }

    public Set<String> e() {
        return this.x.keySet();
    }

    @Override
    public byte b() {
        return 10;
    }

    public NBTTagType<NBTTagCompound> c() {
        return b;
    }

    public int f() {
        return this.x.size();
    }

    @Nullable
    public NBTBase a(String key, NBTBase value) {
        return this.x.put(key, value);
    }

    public void a(String key, byte value) {
        this.x.put(key, NBTTagByte.a(value));
    }

    public void a(String key, short value) {
        this.x.put(key, NBTTagShort.a(value));
    }

    public void a(String key, int value) {
        this.x.put(key, NBTTagInt.a(value));
    }

    public void a(String key, long value) {
        this.x.put(key, NBTTagLong.a(value));
    }

    public void a(String key, UUID value) {
        if (this.b(key + "Most", 99) && this.b(key + "Least", 99)) {
            this.x.remove(key + "Most");
            this.x.remove(key + "Least");
        }
        this.x.put(key, GameProfileSerializer.a(value));
    }

    public UUID a(String key) {
        if (!this.b(key, 11) && this.b(key + "Most", 99) && this.b(key + "Least", 99)) {
            return new UUID(this.i(key + "Most"), this.i(key + "Least"));
        }
        return GameProfileSerializer.a(this.c(key));
    }

    public boolean b(String key) {
        if (this.b(key + "Most", 99) && this.b(key + "Least", 99)) {
            return true;
        }
        NBTBase tag = this.c(key);
        return tag != null && tag.c() == NBTTagIntArray.a && ((NBTTagIntArray)tag).g().length == 4;
    }

    public void a(String key, float value) {
        this.x.put(key, NBTTagFloat.a(value));
    }

    public void a(String key, double value) {
        this.x.put(key, NBTTagDouble.a(value));
    }

    public void a(String key, String value) {
        this.x.put(key, NBTTagString.a(value));
    }

    public void a(String key, byte[] value) {
        this.x.put(key, new NBTTagByteArray(value));
    }

    public void a(String key, List<Byte> value) {
        this.x.put(key, new NBTTagByteArray(value));
    }

    public void a(String key, int[] value) {
        this.x.put(key, new NBTTagIntArray(value));
    }

    public void b(String key, List<Integer> value) {
        this.x.put(key, new NBTTagIntArray(value));
    }

    public void a(String key, long[] value) {
        this.x.put(key, new NBTTagLongArray(value));
    }

    public void c(String key, List<Long> value) {
        this.x.put(key, new NBTTagLongArray(value));
    }

    public void a(String key, boolean value) {
        this.x.put(key, NBTTagByte.a(value));
    }

    @Nullable
    public NBTBase c(String key) {
        return this.x.get(key);
    }

    public byte d(String key) {
        NBTBase tag = this.x.get(key);
        return tag == null ? (byte)0 : tag.b();
    }

    public boolean e(String key) {
        return this.x.containsKey(key);
    }

    public boolean b(String key, int tagType) {
        byte tagType1 = this.d(key);
        return tagType1 == tagType || tagType == 99 && (tagType1 == 1 || tagType1 == 2 || tagType1 == 3 || tagType1 == 4 || tagType1 == 5 || tagType1 == 6);
    }

    public byte f(String key) {
        try {
            if (this.b(key, 99)) {
                return ((NBTNumber)this.x.get(key)).i();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short g(String key) {
        try {
            if (this.b(key, 99)) {
                return ((NBTNumber)this.x.get(key)).h();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int h(String key) {
        try {
            if (this.b(key, 99)) {
                return ((NBTNumber)this.x.get(key)).g();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long i(String key) {
        try {
            if (this.b(key, 99)) {
                return ((NBTNumber)this.x.get(key)).f();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float j(String key) {
        try {
            if (this.b(key, 99)) {
                return ((NBTNumber)this.x.get(key)).k();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double k(String key) {
        try {
            if (this.b(key, 99)) {
                return ((NBTNumber)this.x.get(key)).j();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String l(String key) {
        try {
            if (this.b(key, 8)) {
                return this.x.get(key).u_();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] m(String key) {
        try {
            if (this.b(key, 7)) {
                return ((NBTTagByteArray)this.x.get(key)).e();
            }
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.a(key, NBTTagByteArray.a, var3));
        }
        return new byte[0];
    }

    public int[] n(String key) {
        try {
            if (this.b(key, 11)) {
                return ((NBTTagIntArray)this.x.get(key)).g();
            }
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.a(key, NBTTagIntArray.a, var3));
        }
        return new int[0];
    }

    public long[] o(String key) {
        try {
            if (this.b(key, 12)) {
                return ((NBTTagLongArray)this.x.get(key)).g();
            }
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.a(key, NBTTagLongArray.a, var3));
        }
        return new long[0];
    }

    public NBTTagCompound p(String key) {
        try {
            if (this.b(key, 10)) {
                return (NBTTagCompound)this.x.get(key);
            }
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.a(key, b, var3));
        }
        return new NBTTagCompound();
    }

    public NBTTagList c(String key, int tagType) {
        try {
            if (this.d(key) == 9) {
                NBTTagList listTag = (NBTTagList)this.x.get(key);
                if (!listTag.isEmpty() && listTag.f() != tagType) {
                    return new NBTTagList();
                }
                return listTag;
            }
        }
        catch (ClassCastException var4) {
            throw new ReportedException(this.a(key, NBTTagList.a, var4));
        }
        return new NBTTagList();
    }

    public boolean q(String key) {
        return this.f(key) != 0;
    }

    public void r(String key) {
        this.x.remove(key);
    }

    @Override
    public String toString() {
        return this.u_();
    }

    public boolean g() {
        return this.x.isEmpty();
    }

    private CrashReport a(String tagName, NBTTagType<?> type, ClassCastException exception) {
        CrashReport crashReport = CrashReport.a(exception, "Reading NBT data");
        CrashReportSystemDetails crashReportCategory = crashReport.a("Corrupt NBT tag", 1);
        crashReportCategory.a("Tag type found", () -> this.x.get(tagName).c().a());
        crashReportCategory.a("Tag type expected", type::a);
        crashReportCategory.a("Tag name", tagName);
        return crashReport;
    }

    protected NBTTagCompound h() {
        return new NBTTagCompound(new HashMap<String, NBTBase>(this.x));
    }

    public NBTTagCompound i() {
        ObjectIterator iterator;
        Object2ObjectOpenHashMap ret = new Object2ObjectOpenHashMap(this.x.size(), 0.8f);
        ObjectIterator objectIterator = iterator = this.x instanceof Object2ObjectOpenHashMap ? ((Object2ObjectOpenHashMap)this.x).object2ObjectEntrySet().fastIterator() : this.x.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            ret.put((Object)((String)entry.getKey()), (Object)((NBTBase)entry.getValue()).d());
        }
        return new NBTTagCompound((Map<String, NBTBase>)ret);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof NBTTagCompound && Objects.equals(this.x, ((NBTTagCompound)other).x);
    }

    public int hashCode() {
        return this.x.hashCode();
    }

    private static void a(String name, NBTBase tag, DataOutput output) throws IOException {
        output.writeByte(tag.b());
        if (tag.b() != 0) {
            output.writeUTF(name);
            tag.a(output);
        }
    }

    static NBTBase a(NBTTagType<?> type, String name, DataInput input, NBTReadLimiter accounter) {
        try {
            return type.c(input, accounter);
        }
        catch (IOException var7) {
            CrashReport crashReport = CrashReport.a(var7, "Loading NBT data");
            CrashReportSystemDetails crashReportCategory = crashReport.a("NBT Tag");
            crashReportCategory.a("Tag name", name);
            crashReportCategory.a("Tag type", type.a());
            throw new ReportedNbtException(crashReport);
        }
    }

    public NBTTagCompound a(NBTTagCompound other) {
        for (String string : other.x.keySet()) {
            NBTBase tag = other.x.get(string);
            if (tag.b() == 10) {
                if (this.b(string, 10)) {
                    NBTTagCompound compound = this.p(string);
                    compound.a((NBTTagCompound)tag);
                    continue;
                }
                this.a(string, tag.d());
                continue;
            }
            this.a(string, tag.d());
        }
        return this;
    }

    @Override
    public void a(TagVisitor visitor) {
        visitor.a(this);
    }

    protected Set<Map.Entry<String, NBTBase>> j() {
        return this.x.entrySet();
    }

    @Override
    public StreamTagVisitor.b a(StreamTagVisitor visitor) {
        block14: for (Map.Entry<String, NBTBase> entry : this.x.entrySet()) {
            NBTBase tag = entry.getValue();
            NBTTagType<?> type = tag.c();
            StreamTagVisitor.a entryResult = visitor.a(type);
            switch (entryResult) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return visitor.b();
                }
                case b: {
                    continue block14;
                }
            }
            entryResult = visitor.a(type, entry.getKey());
            switch (entryResult) {
                case d: {
                    return StreamTagVisitor.b.c;
                }
                case c: {
                    return visitor.b();
                }
                case b: {
                    continue block14;
                }
            }
            StreamTagVisitor.b valueResult = tag.a(visitor);
            switch (valueResult) {
                case c: {
                    return StreamTagVisitor.b.c;
                }
                case b: {
                    return visitor.b();
                }
            }
        }
        return visitor.b();
    }
}

