/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.TextComponentTagVisitor;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import org.slf4j.Logger;

public final class GameProfileSerializer {
    private static final Comparator<NBTTagList> b = Comparator.comparingInt(listTag -> listTag.e(1)).thenComparingInt(listTag -> listTag.e(0)).thenComparingInt(listTag -> listTag.e(2));
    private static final Comparator<NBTTagList> c = Comparator.comparingDouble(listTag -> listTag.h(1)).thenComparingDouble(listTag -> listTag.h(0)).thenComparingDouble(listTag -> listTag.h(2));
    public static final String a = "data";
    private static final char d = '{';
    private static final char e = '}';
    private static final String f = ",";
    private static final char g = ':';
    private static final Splitter h = Splitter.on((String)",");
    private static final Splitter i = Splitter.on((char)':').limit(2);
    private static final Logger j = LogUtils.getLogger();
    private static final int k = 2;
    private static final int l = -1;

    private GameProfileSerializer() {
    }

    @VisibleForTesting
    public static boolean a(@Nullable NBTBase tag, @Nullable NBTBase other, boolean compareListTag) {
        if (tag == other) {
            return true;
        }
        if (tag == null) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!tag.getClass().equals(other.getClass())) {
            return false;
        }
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            NBTTagCompound compoundTag1 = (NBTTagCompound)other;
            if (compoundTag1.f() < compoundTag.f()) {
                return false;
            }
            for (String string : compoundTag.e()) {
                NBTBase tag1 = compoundTag.c(string);
                if (GameProfileSerializer.a(tag1, compoundTag1.c(string), compareListTag)) continue;
                return false;
            }
            return true;
        }
        if (tag instanceof NBTTagList) {
            NBTTagList listTag = (NBTTagList)tag;
            if (compareListTag) {
                NBTTagList listTag1 = (NBTTagList)other;
                if (listTag.isEmpty()) {
                    return listTag1.isEmpty();
                }
                if (listTag1.size() < listTag.size()) {
                    return false;
                }
                for (NBTBase tag2 : listTag) {
                    boolean flag = false;
                    for (NBTBase tag3 : listTag1) {
                        if (!GameProfileSerializer.a(tag2, tag3, compareListTag)) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    return false;
                }
                return true;
            }
        }
        return tag.equals(other);
    }

    public static NBTTagIntArray a(UUID uuid) {
        return new NBTTagIntArray(UUIDUtil.a(uuid));
    }

    public static UUID a(NBTBase tag) {
        if (tag.c() != NBTTagIntArray.a) {
            throw new IllegalArgumentException("Expected UUID-Tag to be of type " + NBTTagIntArray.a.a() + ", but found " + tag.c().a() + ".");
        }
        int[] asIntArray = ((NBTTagIntArray)tag).g();
        if (asIntArray.length != 4) {
            throw new IllegalArgumentException("Expected UUID-Array to be of length 4, but found " + asIntArray.length + ".");
        }
        return UUIDUtil.a(asIntArray);
    }

    public static Optional<BlockPosition> a(NBTTagCompound tag, String key) {
        int[] intArray = tag.n(key);
        return intArray.length == 3 ? Optional.of(new BlockPosition(intArray[0], intArray[1], intArray[2])) : Optional.empty();
    }

    public static NBTBase a(BlockPosition pos) {
        return new NBTTagIntArray(new int[]{pos.u(), pos.v(), pos.w()});
    }

    public static IBlockData a(HolderGetter<Block> blockGetter, NBTTagCompound tag) {
        Optional optional;
        if (!tag.b("Name", 8)) {
            return Blocks.a.m();
        }
        MinecraftKey resourceLocation = MinecraftKey.c(tag.l("Name"));
        Optional<Object> optional2 = optional = resourceLocation != null ? blockGetter.a(ResourceKey.a(Registries.f, resourceLocation)) : Optional.empty();
        if (optional.isEmpty()) {
            return Blocks.a.m();
        }
        Block block = (Block)((Holder)optional.get()).a();
        IBlockData blockState = block.m();
        if (tag.b("Properties", 10)) {
            NBTTagCompound compound = tag.p("Properties");
            BlockStateList<Block, IBlockData> stateDefinition = block.l();
            for (String string : compound.e()) {
                IBlockState<?> property = stateDefinition.a(string);
                if (property == null) continue;
                blockState = GameProfileSerializer.a(blockState, property, string, compound, tag);
            }
        }
        return blockState;
    }

    private static <S extends IBlockDataHolder<?, S>, T extends Comparable<T>> S a(S stateHolder, IBlockState<T> property, String propertyName, NBTTagCompound propertiesTag, NBTTagCompound blockStateTag) {
        Optional<T> value = property.b(propertiesTag.l(propertyName));
        if (value.isPresent()) {
            return (S)((IBlockDataHolder)stateHolder.b(property, (Comparable)((Comparable)value.get())));
        }
        j.warn("Unable to read property: {} with value: {} for blockstate: {}", new Object[]{propertyName, propertiesTag.l(propertyName), blockStateTag});
        return stateHolder;
    }

    public static NBTTagCompound a(IBlockData state) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("Name", BuiltInRegistries.e.b(state.b()).toString());
        Map<IBlockState<?>, Comparable<?>> values = state.G();
        if (!values.isEmpty()) {
            NBTTagCompound compoundTag1 = new NBTTagCompound();
            for (Map.Entry<IBlockState<?>, Comparable<?>> entry : values.entrySet()) {
                IBlockState<?> property = entry.getKey();
                compoundTag1.a(property.f(), GameProfileSerializer.a(property, entry.getValue()));
            }
            compoundTag.a("Properties", compoundTag1);
        }
        return compoundTag;
    }

    public static NBTTagCompound a(Fluid state) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("Name", BuiltInRegistries.c.b(state.a()).toString());
        Map<IBlockState<?>, Comparable<?>> values = state.G();
        if (!values.isEmpty()) {
            NBTTagCompound compoundTag1 = new NBTTagCompound();
            for (Map.Entry<IBlockState<?>, Comparable<?>> entry : values.entrySet()) {
                IBlockState<?> property = entry.getKey();
                compoundTag1.a(property.f(), GameProfileSerializer.a(property, entry.getValue()));
            }
            compoundTag.a("Properties", compoundTag1);
        }
        return compoundTag;
    }

    private static <T extends Comparable<T>> String a(IBlockState<T> property, Comparable<?> value) {
        return property.b(value);
    }

    public static String b(NBTBase tag) {
        return GameProfileSerializer.a(tag, false);
    }

    public static String a(NBTBase tag, boolean prettyPrintArray) {
        return GameProfileSerializer.a(new StringBuilder(), tag, 0, prettyPrintArray).toString();
    }

    public static StringBuilder a(StringBuilder stringBuilder, NBTBase tag, int indentLevel, boolean prettyPrintArray) {
        switch (tag.b()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                stringBuilder.append(tag);
                break;
            }
            case 7: {
                NBTTagByteArray byteArrayTag = (NBTTagByteArray)tag;
                byte[] asByteArray = byteArrayTag.e();
                int ix = asByteArray.length;
                GameProfileSerializer.a(indentLevel, stringBuilder).append("byte[").append(ix).append("] {\n");
                if (prettyPrintArray) {
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                    for (int i1 = 0; i1 < asByteArray.length; ++i1) {
                        if (i1 != 0) {
                            stringBuilder.append(',');
                        }
                        if (i1 % 16 == 0 && i1 / 16 > 0) {
                            stringBuilder.append('\n');
                            if (i1 < asByteArray.length) {
                                GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                            }
                        } else if (i1 != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%02X", asByteArray[i1] & 0xFF));
                    }
                } else {
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                GameProfileSerializer.a(indentLevel, stringBuilder).append('}');
                break;
            }
            case 9: {
                NBTTagList listTag = (NBTTagList)tag;
                int size = listTag.size();
                byte i2 = listTag.f();
                String string = i2 == 0 ? "undefined" : NBTTagTypes.a(i2).b();
                GameProfileSerializer.a(indentLevel, stringBuilder).append("list<").append(string).append(">[").append(size).append("] [");
                if (size != 0) {
                    stringBuilder.append('\n');
                }
                for (int i22 = 0; i22 < size; ++i22) {
                    if (i22 != 0) {
                        stringBuilder.append(",\n");
                    }
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                    GameProfileSerializer.a(stringBuilder, listTag.k(i22), indentLevel + 1, prettyPrintArray);
                }
                if (size != 0) {
                    stringBuilder.append('\n');
                }
                GameProfileSerializer.a(indentLevel, stringBuilder).append(']');
                break;
            }
            case 10: {
                NBTTagCompound compoundTag = (NBTTagCompound)tag;
                ArrayList list = Lists.newArrayList(compoundTag.e());
                Collections.sort(list);
                GameProfileSerializer.a(indentLevel, stringBuilder).append('{');
                if (stringBuilder.length() - stringBuilder.lastIndexOf("\n") > 2 * (indentLevel + 1)) {
                    stringBuilder.append('\n');
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                }
                int ix = list.stream().mapToInt(String::length).max().orElse(0);
                String stringx = Strings.repeat((String)" ", (int)ix);
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    if (i2 != 0) {
                        stringBuilder.append(",\n");
                    }
                    String string1 = (String)list.get(i2);
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder).append('\"').append(string1).append('\"').append(stringx, 0, stringx.length() - string1.length()).append(": ");
                    GameProfileSerializer.a(stringBuilder, compoundTag.c(string1), indentLevel + 1, prettyPrintArray);
                }
                if (!list.isEmpty()) {
                    stringBuilder.append('\n');
                }
                GameProfileSerializer.a(indentLevel, stringBuilder).append('}');
                break;
            }
            case 11: {
                NBTTagIntArray intArrayTag = (NBTTagIntArray)tag;
                int[] asIntArray = intArrayTag.g();
                int ix = 0;
                for (int i3 : asIntArray) {
                    ix = Math.max(ix, String.format(Locale.ROOT, "%X", i3).length());
                }
                int i1 = asIntArray.length;
                GameProfileSerializer.a(indentLevel, stringBuilder).append("int[").append(i1).append("] {\n");
                if (prettyPrintArray) {
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                    for (int i2 = 0; i2 < asIntArray.length; ++i2) {
                        if (i2 != 0) {
                            stringBuilder.append(',');
                        }
                        if (i2 % 16 == 0 && i2 / 16 > 0) {
                            stringBuilder.append('\n');
                            if (i2 < asIntArray.length) {
                                GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                            }
                        } else if (i2 != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%0" + ix + "X", asIntArray[i2]));
                    }
                } else {
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                GameProfileSerializer.a(indentLevel, stringBuilder).append('}');
                break;
            }
            case 12: {
                NBTTagLongArray longArrayTag = (NBTTagLongArray)tag;
                long[] asLongArray = longArrayTag.g();
                long l2 = 0L;
                for (long l1 : asLongArray) {
                    l2 = Math.max(l2, (long)String.format(Locale.ROOT, "%X", l1).length());
                }
                long l22 = asLongArray.length;
                GameProfileSerializer.a(indentLevel, stringBuilder).append("long[").append(l22).append("] {\n");
                if (prettyPrintArray) {
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                    for (int i3 = 0; i3 < asLongArray.length; ++i3) {
                        if (i3 != 0) {
                            stringBuilder.append(',');
                        }
                        if (i3 % 16 == 0 && i3 / 16 > 0) {
                            stringBuilder.append('\n');
                            if (i3 < asLongArray.length) {
                                GameProfileSerializer.a(indentLevel + 1, stringBuilder);
                            }
                        } else if (i3 != 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(String.format(Locale.ROOT, "0x%0" + l2 + "X", asLongArray[i3]));
                    }
                } else {
                    GameProfileSerializer.a(indentLevel + 1, stringBuilder).append(" // Skipped, supply withBinaryBlobs true");
                }
                stringBuilder.append('\n');
                GameProfileSerializer.a(indentLevel, stringBuilder).append('}');
                break;
            }
            default: {
                stringBuilder.append("<UNKNOWN :(>");
            }
        }
        return stringBuilder;
    }

    private static StringBuilder a(int indentLevel, StringBuilder stringBuilder) {
        int i2 = stringBuilder.lastIndexOf("\n") + 1;
        int i1 = stringBuilder.length() - i2;
        for (int i22 = 0; i22 < 2 * indentLevel - i1; ++i22) {
            stringBuilder.append(' ');
        }
        return stringBuilder;
    }

    public static IChatBaseComponent c(NBTBase tag) {
        return new TextComponentTagVisitor("").a(tag);
    }

    public static String a(NBTTagCompound tag) {
        return new SnbtPrinterTagVisitor().a((NBTBase)GameProfileSerializer.b(tag));
    }

    public static NBTTagCompound a(String text) throws CommandSyntaxException {
        return GameProfileSerializer.c(MojangsonParser.a(text));
    }

    @VisibleForTesting
    static NBTTagCompound b(NBTTagCompound tag) {
        NBTTagList list1;
        NBTTagList listTag1;
        boolean flag = tag.b("palettes", 9);
        NBTTagList list = flag ? tag.c("palettes", 9).b(0) : tag.c("palette", 10);
        NBTTagList listTag = list.stream().map(NBTTagCompound.class::cast).map(GameProfileSerializer::d).map(NBTTagString::a).collect(Collectors.toCollection(NBTTagList::new));
        tag.a("palette", listTag);
        if (flag) {
            listTag1 = new NBTTagList();
            list1 = tag.c("palettes", 9);
            list1.stream().map(NBTTagList.class::cast).forEach(paletteTag -> {
                NBTTagCompound compoundTag = new NBTTagCompound();
                for (int i2 = 0; i2 < paletteTag.size(); ++i2) {
                    compoundTag.a(listTag.j(i2), GameProfileSerializer.d(paletteTag.a(i2)));
                }
                listTag1.add(compoundTag);
            });
            tag.a("palettes", listTag1);
        }
        if (tag.b("entities", 9)) {
            listTag1 = tag.c("entities", 10);
            list1 = listTag1.stream().map(NBTTagCompound.class::cast).sorted(Comparator.comparing(entityTag -> entityTag.c("pos", 6), c)).collect(Collectors.toCollection(NBTTagList::new));
            tag.a("entities", list1);
        }
        listTag1 = tag.c("blocks", 10).stream().map(NBTTagCompound.class::cast).sorted(Comparator.comparing(blockTag -> blockTag.c("pos", 3), b)).peek(blockTag -> blockTag.a("state", listTag.j(blockTag.h("state")))).collect(Collectors.toCollection(NBTTagList::new));
        tag.a(a, listTag1);
        tag.r("blocks");
        return tag;
    }

    @VisibleForTesting
    static NBTTagCompound c(NBTTagCompound tag) {
        NBTTagList list = tag.c("palette", 8);
        Map map = (Map)list.stream().map(NBTTagString.class::cast).map(NBTTagString::u_).collect(ImmutableMap.toImmutableMap(Function.identity(), GameProfileSerializer::b));
        if (tag.b("palettes", 9)) {
            tag.a("palettes", tag.c("palettes", 10).stream().map(NBTTagCompound.class::cast).map(paletteTag -> map.keySet().stream().map(paletteTag::l).map(GameProfileSerializer::b).collect(Collectors.toCollection(NBTTagList::new))).collect(Collectors.toCollection(NBTTagList::new)));
            tag.r("palette");
        } else {
            tag.a("palette", map.values().stream().collect(Collectors.toCollection(NBTTagList::new)));
        }
        if (tag.b(a, 9)) {
            Object2IntOpenHashMap map1 = new Object2IntOpenHashMap();
            map1.defaultReturnValue(-1);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                map1.put((Object)list.j(i2), i2);
            }
            NBTTagList list1 = tag.c(a, 10);
            for (int i1 = 0; i1 < list1.size(); ++i1) {
                NBTTagCompound compound = list1.a(i1);
                String string = compound.l("state");
                int _int = map1.getInt((Object)string);
                if (_int == -1) {
                    throw new IllegalStateException("Entry " + string + " missing from palette");
                }
                compound.a("state", _int);
            }
            tag.a("blocks", list1);
            tag.r(a);
        }
        return tag;
    }

    @VisibleForTesting
    static String d(NBTTagCompound tag) {
        StringBuilder stringBuilder = new StringBuilder(tag.l("Name"));
        if (tag.b("Properties", 10)) {
            NBTTagCompound compound = tag.p("Properties");
            String string = compound.e().stream().sorted().map(propertyKey -> propertyKey + ":" + compound.c((String)propertyKey).u_()).collect(Collectors.joining(f));
            stringBuilder.append('{').append(string).append('}');
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    static NBTTagCompound b(String blockStateText) {
        String sub;
        NBTTagCompound compoundTag = new NBTTagCompound();
        int index = blockStateText.indexOf(123);
        if (index >= 0) {
            sub = blockStateText.substring(0, index);
            NBTTagCompound compoundTag1 = new NBTTagCompound();
            if (index + 2 <= blockStateText.length()) {
                String sub1 = blockStateText.substring(index + 1, blockStateText.indexOf(125, index));
                h.split((CharSequence)sub1).forEach(stateMetadata -> {
                    List parts = i.splitToList((CharSequence)stateMetadata);
                    if (parts.size() == 2) {
                        compoundTag1.a((String)parts.get(0), (String)parts.get(1));
                    } else {
                        j.error("Something went wrong parsing: '{}' -- incorrect gamedata!", (Object)blockStateText);
                    }
                });
                compoundTag.a("Properties", compoundTag1);
            }
        } else {
            sub = blockStateText;
        }
        compoundTag.a("Name", sub);
        return compoundTag;
    }

    public static NBTTagCompound e(NBTTagCompound tag) {
        int version = SharedConstants.b().d().c();
        return GameProfileSerializer.a(tag, version);
    }

    public static NBTTagCompound a(NBTTagCompound tag, int dataVersion) {
        tag.a("DataVersion", dataVersion);
        return tag;
    }

    public static int b(NBTTagCompound tag, int defaultValue) {
        return tag.b("DataVersion", 99) ? tag.h("DataVersion") : defaultValue;
    }
}

