/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class DynamicOpsNBT
implements DynamicOps<NBTBase> {
    public static final DynamicOpsNBT a = new DynamicOpsNBT();
    private static final String b = "";

    protected DynamicOpsNBT() {
    }

    public NBTBase a() {
        return NBTTagEnd.b;
    }

    public <U> U a(DynamicOps<U> ops, NBTBase tag) {
        return (U)(switch (tag.b()) {
            case 0 -> ops.empty();
            case 1 -> ops.createByte(((NBTNumber)tag).i());
            case 2 -> ops.createShort(((NBTNumber)tag).h());
            case 3 -> ops.createInt(((NBTNumber)tag).g());
            case 4 -> ops.createLong(((NBTNumber)tag).f());
            case 5 -> ops.createFloat(((NBTNumber)tag).k());
            case 6 -> ops.createDouble(((NBTNumber)tag).j());
            case 7 -> ops.createByteList(ByteBuffer.wrap(((NBTTagByteArray)tag).e()));
            case 8 -> ops.createString(tag.u_());
            case 9 -> this.convertList(ops, tag);
            case 10 -> this.convertMap(ops, tag);
            case 11 -> ops.createIntList(Arrays.stream(((NBTTagIntArray)tag).g()));
            case 12 -> ops.createLongList(Arrays.stream(((NBTTagLongArray)tag).g()));
            default -> throw new IllegalStateException("Unknown tag type: " + String.valueOf(tag));
        });
    }

    public DataResult<Number> a(NBTBase tag) {
        DataResult dataResult;
        if (tag instanceof NBTNumber) {
            NBTNumber numericTag = (NBTNumber)tag;
            dataResult = DataResult.success((Object)numericTag.l());
        } else {
            dataResult = DataResult.error(() -> "Not a number");
        }
        return dataResult;
    }

    public NBTBase a(Number data) {
        return NBTTagDouble.a(data.doubleValue());
    }

    public NBTBase a(byte data) {
        return NBTTagByte.a(data);
    }

    public NBTBase a(short data) {
        return NBTTagShort.a(data);
    }

    public NBTBase a(int data) {
        return NBTTagInt.a(data);
    }

    public NBTBase a(long data) {
        return NBTTagLong.a(data);
    }

    public NBTBase a(float data) {
        return NBTTagFloat.a(data);
    }

    public NBTBase a(double data) {
        return NBTTagDouble.a(data);
    }

    public NBTBase a(boolean data) {
        return NBTTagByte.a(data);
    }

    public DataResult<String> b(NBTBase tag) {
        DataResult dataResult;
        if (tag instanceof NBTTagString) {
            NBTTagString stringTag = (NBTTagString)tag;
            dataResult = DataResult.success((Object)stringTag.u_());
        } else {
            dataResult = DataResult.error(() -> "Not a string");
        }
        return dataResult;
    }

    public NBTBase a(String data) {
        return NBTTagString.a(data);
    }

    public DataResult<NBTBase> a(NBTBase list, NBTBase tag) {
        return DynamicOpsNBT.k(list).map(listCollector -> DataResult.success((Object)listCollector.a(tag).a())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list));
    }

    public DataResult<NBTBase> a(NBTBase list, List<NBTBase> tags) {
        return DynamicOpsNBT.k(list).map(listCollector -> DataResult.success((Object)listCollector.a(tags).a())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list));
    }

    public DataResult<NBTBase> a(NBTBase map, NBTBase key, NBTBase value) {
        NBTTagCompound nBTTagCompound;
        if (!(map instanceof NBTTagCompound) && !(map instanceof NBTTagEnd)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (!(key instanceof NBTTagString)) {
            return DataResult.error(() -> "key is not a string: " + String.valueOf(key), (Object)map);
        }
        if (map instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)map;
            nBTTagCompound = compoundTag.h();
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound compoundTag1 = nBTTagCompound;
        compoundTag1.a(key.u_(), value);
        return DataResult.success((Object)compoundTag1);
    }

    public DataResult<NBTBase> a(NBTBase map, MapLike<NBTBase> otherMap) {
        NBTTagCompound nBTTagCompound;
        if (!(map instanceof NBTTagCompound) && !(map instanceof NBTTagEnd)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (map instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)map;
            nBTTagCompound = compoundTag.h();
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound compoundTag1 = nBTTagCompound;
        ArrayList list = new ArrayList();
        otherMap.entries().forEach(pair -> {
            NBTBase tag = (NBTBase)pair.getFirst();
            if (!(tag instanceof NBTTagString)) {
                list.add(tag);
            } else {
                compoundTag1.a(tag.u_(), (NBTBase)pair.getSecond());
            }
        });
        return !list.isEmpty() ? DataResult.error(() -> "some keys are not strings: " + String.valueOf(list), (Object)compoundTag1) : DataResult.success((Object)compoundTag1);
    }

    public DataResult<NBTBase> a(NBTBase tag, Map<NBTBase, NBTBase> map) {
        NBTTagCompound nBTTagCompound;
        if (!(tag instanceof NBTTagCompound) && !(tag instanceof NBTTagEnd)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(tag), (Object)tag);
        }
        if (tag instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)tag;
            nBTTagCompound = compoundTag.h();
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound compoundTag1 = nBTTagCompound;
        ArrayList<NBTBase> list = new ArrayList<NBTBase>();
        for (Map.Entry<NBTBase, NBTBase> entry : map.entrySet()) {
            NBTBase tag1 = entry.getKey();
            if (tag1 instanceof NBTTagString) {
                compoundTag1.a(tag1.u_(), entry.getValue());
                continue;
            }
            list.add(tag1);
        }
        return !list.isEmpty() ? DataResult.error(() -> "some keys are not strings: " + String.valueOf(list), (Object)compoundTag1) : DataResult.success((Object)compoundTag1);
    }

    public DataResult<Stream<Pair<NBTBase, NBTBase>>> c(NBTBase map) {
        DataResult dataResult;
        if (map instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)map;
            dataResult = DataResult.success(compoundTag.j().stream().map(entry -> Pair.of((Object)this.a((String)entry.getKey()), (Object)((NBTBase)entry.getValue()))));
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        return dataResult;
    }

    public DataResult<Consumer<BiConsumer<NBTBase, NBTBase>>> d(NBTBase map) {
        DataResult dataResult;
        if (map instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)map;
            dataResult = DataResult.success(biConsumer -> {
                for (Map.Entry<String, NBTBase> entry : compoundTag.j()) {
                    biConsumer.accept(this.a(entry.getKey()), entry.getValue());
                }
            });
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        return dataResult;
    }

    public DataResult<MapLike<NBTBase>> e(NBTBase map) {
        DataResult dataResult;
        if (map instanceof NBTTagCompound) {
            final NBTTagCompound compoundTag = (NBTTagCompound)map;
            dataResult = DataResult.success((Object)new MapLike<NBTBase>(){

                @Nullable
                public NBTBase a(NBTBase tag) {
                    return compoundTag.c(tag.u_());
                }

                @Nullable
                public NBTBase a(String string) {
                    return compoundTag.c(string);
                }

                public Stream<Pair<NBTBase, NBTBase>> entries() {
                    return compoundTag.j().stream().map(entry -> Pair.of((Object)DynamicOpsNBT.this.a((String)entry.getKey()), (Object)((NBTBase)entry.getValue())));
                }

                public String toString() {
                    return "MapLike[" + String.valueOf(compoundTag) + "]";
                }
            });
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(map));
        }
        return dataResult;
    }

    public NBTBase a(Stream<Pair<NBTBase, NBTBase>> data) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        data.forEach(pair -> compoundTag.a(((NBTBase)pair.getFirst()).u_(), (NBTBase)pair.getSecond()));
        return compoundTag;
    }

    private static NBTBase a(NBTTagCompound tag) {
        NBTBase tag1;
        if (tag.f() == 1 && (tag1 = tag.c(b)) != null) {
            return tag1;
        }
        return tag;
    }

    public DataResult<Stream<NBTBase>> f(NBTBase tag) {
        DataResult dataResult;
        if (tag instanceof NBTTagList) {
            NBTTagList listTag = (NBTTagList)tag;
            return listTag.f() == 10 ? DataResult.success(listTag.stream().map(tag1 -> DynamicOpsNBT.a((NBTTagCompound)tag1))) : DataResult.success(listTag.stream());
        }
        if (tag instanceof NBTList) {
            NBTList collectionTag = (NBTList)tag;
            dataResult = DataResult.success(collectionTag.stream().map(tag1 -> tag1));
        } else {
            dataResult = DataResult.error(() -> "Not a list");
        }
        return dataResult;
    }

    public DataResult<Consumer<Consumer<NBTBase>>> g(NBTBase tag) {
        DataResult dataResult;
        if (tag instanceof NBTTagList) {
            NBTTagList listTag = (NBTTagList)tag;
            return listTag.f() == 10 ? DataResult.success(consumer -> {
                for (NBTBase tag1 : listTag) {
                    consumer.accept(DynamicOpsNBT.a((NBTTagCompound)tag1));
                }
            }) : DataResult.success(listTag::forEach);
        }
        if (tag instanceof NBTList) {
            NBTList collectionTag = (NBTList)tag;
            dataResult = DataResult.success(collectionTag::forEach);
        } else {
            dataResult = DataResult.error(() -> "Not a list: " + String.valueOf(tag));
        }
        return dataResult;
    }

    public DataResult<ByteBuffer> h(NBTBase tag) {
        DataResult dataResult;
        if (tag instanceof NBTTagByteArray) {
            NBTTagByteArray byteArrayTag = (NBTTagByteArray)tag;
            dataResult = DataResult.success((Object)ByteBuffer.wrap(byteArrayTag.e()));
        } else {
            dataResult = super.getByteBuffer((Object)tag);
        }
        return dataResult;
    }

    public NBTBase a(ByteBuffer data) {
        ByteBuffer byteBuffer = data.duplicate().clear();
        byte[] bytes = new byte[data.capacity()];
        byteBuffer.get(0, bytes, 0, bytes.length);
        return new NBTTagByteArray(bytes);
    }

    public DataResult<IntStream> i(NBTBase tag) {
        DataResult dataResult;
        if (tag instanceof NBTTagIntArray) {
            NBTTagIntArray intArrayTag = (NBTTagIntArray)tag;
            dataResult = DataResult.success((Object)Arrays.stream(intArrayTag.g()));
        } else {
            dataResult = super.getIntStream((Object)tag);
        }
        return dataResult;
    }

    public NBTBase a(IntStream data) {
        return new NBTTagIntArray(data.toArray());
    }

    public DataResult<LongStream> j(NBTBase tag) {
        DataResult dataResult;
        if (tag instanceof NBTTagLongArray) {
            NBTTagLongArray longArrayTag = (NBTTagLongArray)tag;
            dataResult = DataResult.success((Object)Arrays.stream(longArrayTag.g()));
        } else {
            dataResult = super.getLongStream((Object)tag);
        }
        return dataResult;
    }

    public NBTBase a(LongStream data) {
        return new NBTTagLongArray(data.toArray());
    }

    public NBTBase b(Stream<NBTBase> data) {
        return d.a.a(data).a();
    }

    public NBTBase a(NBTBase map, String removeKey) {
        if (map instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)map;
            NBTTagCompound compoundTag1 = compoundTag.h();
            compoundTag1.r(removeKey);
            return compoundTag1;
        }
        return map;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<NBTBase> mapBuilder() {
        return new h(this);
    }

    private static Optional<f> k(NBTBase tag) {
        if (tag instanceof NBTTagEnd) {
            return Optional.of(d.a);
        }
        if (tag instanceof NBTList) {
            NBTList collectionTag = (NBTList)tag;
            if (collectionTag.isEmpty()) {
                return Optional.of(d.a);
            }
            if (collectionTag instanceof NBTTagList) {
                NBTTagList listTag = (NBTTagList)collectionTag;
                return switch (listTag.f()) {
                    case 0 -> Optional.of(d.a);
                    case 10 -> Optional.of(new b(listTag));
                    default -> Optional.of(new c(listTag));
                };
            }
            if (collectionTag instanceof NBTTagByteArray) {
                NBTTagByteArray byteArrayTag = (NBTTagByteArray)collectionTag;
                return Optional.of(new a(byteArrayTag.e()));
            }
            if (collectionTag instanceof NBTTagIntArray) {
                NBTTagIntArray intArrayTag = (NBTTagIntArray)collectionTag;
                return Optional.of(new e(intArrayTag.g()));
            }
            if (collectionTag instanceof NBTTagLongArray) {
                NBTTagLongArray longArrayTag = (NBTTagLongArray)collectionTag;
                return Optional.of(new g(longArrayTag.g()));
            }
        }
        return Optional.empty();
    }

    static class d
    implements f {
        public static final d a = new d();

        private d() {
        }

        @Override
        public f a(NBTBase tag) {
            f f2;
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compoundTag = (NBTTagCompound)tag;
                return new b().a(compoundTag);
            }
            if (tag instanceof NBTTagByte) {
                NBTTagByte byteTag = (NBTTagByte)tag;
                return new a(byteTag.i());
            }
            if (tag instanceof NBTTagInt) {
                NBTTagInt intTag = (NBTTagInt)tag;
                return new e(intTag.g());
            }
            if (tag instanceof NBTTagLong) {
                NBTTagLong longTag = (NBTTagLong)tag;
                f2 = new g(longTag.f());
            } else {
                f2 = new c(tag);
            }
            return f2;
        }

        @Override
        public NBTBase a() {
            return new NBTTagList();
        }
    }

    static interface f {
        public f a(NBTBase var1);

        default public f a(Iterable<NBTBase> tags) {
            f listCollector = this;
            for (NBTBase tag : tags) {
                listCollector = listCollector.a(tag);
            }
            return listCollector;
        }

        default public f a(Stream<NBTBase> tags) {
            return this.a(tags::iterator);
        }

        public NBTBase a();
    }

    class h
    extends RecordBuilder.AbstractStringBuilder<NBTBase, NBTTagCompound> {
        protected h(DynamicOpsNBT this$0) {
            super((DynamicOps)this$0);
        }

        protected NBTTagCompound a() {
            return new NBTTagCompound();
        }

        protected NBTTagCompound a(String key, NBTBase value, NBTTagCompound tag) {
            tag.a(key, value);
            return tag;
        }

        protected DataResult<NBTBase> a(NBTTagCompound compoundTag, NBTBase tag) {
            if (tag == null || tag == NBTTagEnd.b) {
                return DataResult.success((Object)compoundTag);
            }
            if (!(tag instanceof NBTTagCompound)) {
                return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(tag), (Object)tag);
            }
            NBTTagCompound compoundTag1 = (NBTTagCompound)tag;
            NBTTagCompound compoundTag2 = compoundTag1.h();
            for (Map.Entry<String, NBTBase> entry : compoundTag.j()) {
                compoundTag2.a(entry.getKey(), entry.getValue());
            }
            return DataResult.success((Object)compoundTag2);
        }
    }

    static class b
    implements f {
        private final NBTTagList a = new NBTTagList();

        public b() {
        }

        public b(Collection<NBTBase> tags) {
            this.a.addAll(tags);
        }

        public b(IntArrayList data) {
            data.forEach(i2 -> this.a.add(net.minecraft.nbt.DynamicOpsNBT$b.c(NBTTagInt.a(i2))));
        }

        public b(ByteArrayList data) {
            data.forEach(b2 -> this.a.add(net.minecraft.nbt.DynamicOpsNBT$b.c(NBTTagByte.a(b2))));
        }

        public b(LongArrayList data) {
            data.forEach(l2 -> this.a.add(net.minecraft.nbt.DynamicOpsNBT$b.c(NBTTagLong.a(l2))));
        }

        private static boolean a(NBTTagCompound tag) {
            return tag.f() == 1 && tag.e(DynamicOpsNBT.b);
        }

        private static NBTBase b(NBTBase tag) {
            NBTTagCompound compoundTag;
            return tag instanceof NBTTagCompound && !net.minecraft.nbt.DynamicOpsNBT$b.a(compoundTag = (NBTTagCompound)tag) ? compoundTag : net.minecraft.nbt.DynamicOpsNBT$b.c(tag);
        }

        private static NBTTagCompound c(NBTBase tag) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a(DynamicOpsNBT.b, tag);
            return compoundTag;
        }

        @Override
        public f a(NBTBase tag) {
            this.a.add(net.minecraft.nbt.DynamicOpsNBT$b.b(tag));
            return this;
        }

        @Override
        public NBTBase a() {
            return this.a;
        }
    }

    static class c
    implements f {
        private final NBTTagList a = new NBTTagList();

        c(NBTBase value) {
            this.a.add(value);
        }

        c(NBTTagList values) {
            this.a.addAll(values);
        }

        @Override
        public f a(NBTBase tag) {
            if (tag.b() != this.a.f()) {
                return new b().a(this.a).a(tag);
            }
            this.a.add(tag);
            return this;
        }

        @Override
        public NBTBase a() {
            return this.a;
        }
    }

    static class a
    implements f {
        private final ByteArrayList a = new ByteArrayList();

        public a(byte value) {
            this.a.add(value);
        }

        public a(byte[] values) {
            this.a.addElements(0, values);
        }

        @Override
        public f a(NBTBase tag) {
            if (tag instanceof NBTTagByte) {
                NBTTagByte byteTag = (NBTTagByte)tag;
                this.a.add(byteTag.i());
                return this;
            }
            return new b(this.a).a(tag);
        }

        @Override
        public NBTBase a() {
            return new NBTTagByteArray(this.a.toByteArray());
        }
    }

    static class e
    implements f {
        private final IntArrayList a = new IntArrayList();

        public e(int value) {
            this.a.add(value);
        }

        public e(int[] values) {
            this.a.addElements(0, values);
        }

        @Override
        public f a(NBTBase tag) {
            if (tag instanceof NBTTagInt) {
                NBTTagInt intTag = (NBTTagInt)tag;
                this.a.add(intTag.g());
                return this;
            }
            return new b(this.a).a(tag);
        }

        @Override
        public NBTBase a() {
            return new NBTTagIntArray(this.a.toIntArray());
        }
    }

    static class g
    implements f {
        private final LongArrayList a = new LongArrayList();

        public g(long value) {
            this.a.add(value);
        }

        public g(long[] values) {
            this.a.addElements(0, values);
        }

        @Override
        public f a(NBTBase tag) {
            if (tag instanceof NBTTagLong) {
                NBTTagLong longTag = (NBTTagLong)tag;
                this.a.add(longTag.f());
                return this;
            }
            return new b(this.a).a(tag);
        }

        @Override
        public NBTBase a() {
            return new NBTTagLongArray(this.a.toLongArray());
        }
    }
}

