/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.List;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.gametest.framework.ExhaustedAttemptsException;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ReportGameListener
implements GameTestHarnessListener {
    private int a = 0;
    private int b = 0;

    @Override
    public void a(GameTestHarnessInfo testInfo) {
        ReportGameListener.a(testInfo, Blocks.eD);
        ++this.a;
    }

    private void a(GameTestHarnessInfo testInfo, GameTestHarnessRunner runner, boolean passed) {
        RetryOptions retryOptions = testInfo.A();
        Object string = String.format("[Run: %4d, Ok: %4d, Fail: %4d", this.a, this.b, this.a - this.b);
        if (!retryOptions.b()) {
            string = (String)string + String.format(", Left: %4d", retryOptions.d() - this.a);
        }
        string = (String)string + "]";
        String string1 = testInfo.b() + " " + (passed ? "passed" : "failed") + "! " + testInfo.l() + "ms";
        String string2 = String.format("%-53s%s", string, string1);
        if (passed) {
            ReportGameListener.a(testInfo, string2);
        } else {
            ReportGameListener.a(testInfo.g(), EnumChatFormat.m, string2);
        }
        if (retryOptions.a(this.a, this.b)) {
            runner.a(testInfo);
        }
    }

    @Override
    public void a(GameTestHarnessInfo test, GameTestHarnessRunner runner) {
        ++this.b;
        if (test.A().c()) {
            this.a(test, runner, true);
        } else if (!test.x()) {
            ReportGameListener.a(test, test.b() + " passed! (" + test.l() + "ms)");
        } else if (this.b >= test.z()) {
            ReportGameListener.a(test, String.valueOf(test) + " passed " + this.b + " times of " + this.a + " attempts.");
        } else {
            ReportGameListener.a(test.g(), EnumChatFormat.k, "Flaky test " + String.valueOf(test) + " succeeded, attempt: " + this.a + " successes: " + this.b);
            runner.a(test);
        }
    }

    @Override
    public void b(GameTestHarnessInfo test, GameTestHarnessRunner runner) {
        if (!test.x()) {
            ReportGameListener.a(test, test.n());
            if (test.A().c()) {
                this.a(test, runner, false);
            }
        } else {
            GameTestHarnessTestFunction testFunction = test.v();
            String string = "Flaky test " + String.valueOf(test) + " failed, attempt: " + this.a + "/" + testFunction.j();
            if (testFunction.k() > 1) {
                string = string + ", successes: " + this.b + " (" + testFunction.k() + " required)";
            }
            ReportGameListener.a(test.g(), EnumChatFormat.o, string);
            if (test.y() - this.a + this.b >= test.z()) {
                runner.a(test);
            } else {
                ReportGameListener.a(test, new ExhaustedAttemptsException(this.a, this.b, test));
            }
        }
    }

    @Override
    public void a(GameTestHarnessInfo oldTest, GameTestHarnessInfo newTest, GameTestHarnessRunner runner) {
        newTest.a(this);
    }

    public static void a(GameTestHarnessInfo testInfo, String message) {
        ReportGameListener.b(testInfo, Blocks.eA);
        ReportGameListener.b(testInfo, message);
    }

    private static void b(GameTestHarnessInfo testInfo, String message) {
        ReportGameListener.a(testInfo.g(), EnumChatFormat.k, message);
        GlobalTestReporter.b(testInfo);
    }

    protected static void a(GameTestHarnessInfo testInfo, Throwable error) {
        ReportGameListener.b(testInfo, testInfo.r() ? Blocks.eJ : Blocks.ew);
        ReportGameListener.c(testInfo, SystemUtils.c(error));
        ReportGameListener.b(testInfo, error);
    }

    protected static void b(GameTestHarnessInfo testInfo, Throwable error) {
        String string = error.getMessage() + (String)(error.getCause() == null ? "" : " cause: " + SystemUtils.c(error.getCause()));
        String string1 = (testInfo.r() ? "" : "(optional) ") + testInfo.b() + " failed! " + string;
        ReportGameListener.a(testInfo.g(), testInfo.r() ? EnumChatFormat.m : EnumChatFormat.o, string1);
        Throwable throwable = (Throwable)MoreObjects.firstNonNull((Object)ExceptionUtils.getRootCause((Throwable)error), (Object)error);
        if (throwable instanceof GameTestHarnessAssertionPosition) {
            GameTestHarnessAssertionPosition gameTestAssertPosException = (GameTestHarnessAssertionPosition)throwable;
            ReportGameListener.a(testInfo.g(), gameTestAssertPosException.c(), gameTestAssertPosException.a());
        }
        GlobalTestReporter.a(testInfo);
    }

    protected static void a(GameTestHarnessInfo testInfo, Block block) {
        WorldServer level = testInfo.g();
        BlockPosition beaconPos = ReportGameListener.b(testInfo);
        level.b(beaconPos, Blocks.gj.m().a(testInfo.u()));
        ReportGameListener.b(testInfo, block);
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int i1 = -1; i1 <= 1; ++i1) {
                BlockPosition blockPos = beaconPos.b(i2, -1, i1);
                level.b(blockPos, Blocks.cp.m());
            }
        }
    }

    private static BlockPosition b(GameTestHarnessInfo testInfo) {
        BlockPosition structureBlockPos = testInfo.c();
        BlockPosition blockPos = new BlockPosition(-1, -2, -1);
        return DefinedStructure.a(structureBlockPos.a(blockPos), EnumBlockMirror.a, testInfo.u(), structureBlockPos);
    }

    private static void b(GameTestHarnessInfo testInfo, Block newBlock) {
        BlockPosition beaconPos;
        WorldServer level = testInfo.g();
        if (level.a_(beaconPos = ReportGameListener.b(testInfo)).a(Blocks.gj)) {
            BlockPosition blockPos = beaconPos.b(0, 1, 0);
            level.b(blockPos, newBlock.m());
        }
    }

    private static void c(GameTestHarnessInfo testInfo, String message) {
        WorldServer level = testInfo.g();
        BlockPosition structureBlockPos = testInfo.c();
        BlockPosition blockPos = new BlockPosition(-1, 0, -1);
        BlockPosition blockPos1 = DefinedStructure.a(structureBlockPos.a(blockPos), EnumBlockMirror.a, testInfo.u(), structureBlockPos);
        level.b(blockPos1, Blocks.oC.m().a(testInfo.u()));
        IBlockData blockState = level.a_(blockPos1);
        ItemStack itemStack = ReportGameListener.a(testInfo.b(), testInfo.r(), message);
        BlockLectern.a(null, (World)level, blockPos1, blockState, itemStack);
    }

    private static ItemStack a(String testName, boolean required, String message) {
        StringBuffer stringBuffer = new StringBuffer();
        Arrays.stream(testName.split("\\.")).forEach(subName -> stringBuffer.append((String)subName).append('\n'));
        if (!required) {
            stringBuffer.append("(optional)\n");
        }
        stringBuffer.append("-------------------\n");
        ItemStack itemStack = new ItemStack(Items.uX);
        itemStack.b(DataComponents.S, new WritableBookContent(List.of(Filterable.a(String.valueOf(stringBuffer) + message))));
        return itemStack;
    }

    protected static void a(WorldServer serverLevel, EnumChatFormat formatting, String message) {
        serverLevel.a((? super EntityPlayer serverPlayer) -> true).forEach(serverPlayer -> serverPlayer.a(IChatBaseComponent.b(message).a(formatting)));
    }

    private static void a(WorldServer serverLevel, BlockPosition pos, String displayMessage) {
        PacketDebug.a(serverLevel, pos, displayMessage, -2130771968, Integer.MAX_VALUE);
    }
}

