/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestBatchListener;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRegistry;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestClassArgument;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTestFunctionArgument;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureBlockPosFinder;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.gametest.framework.TestFinder;
import net.minecraft.gametest.framework.TestFunctionFinder;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class GameTestHarnessTestCommand {
    public static final int a = 15;
    public static final int b = 200;
    public static final int c = 10;
    public static final int d = 100;
    private static final Logger e = LogUtils.getLogger();
    private static final int f = 200;
    private static final int g = 1024;
    private static final int h = 3;
    private static final int i = 10000;
    private static final int j = 5;
    private static final int k = 5;
    private static final int l = 5;
    private static final String m = "Structure block entity could not be found";
    private static final TestFinder.a<a> n = new TestFinder.a<a>(a::new);

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder, Function<CommandContext<CommandListenerWrapper>, a> runnerGetter, Function<ArgumentBuilder<CommandListenerWrapper, ?>, ArgumentBuilder<CommandListenerWrapper, ?>> modifier) {
        return ((ArgumentBuilder)argumentBuilder.executes((Command<CommandListenerWrapper>)((Command)context -> ((a)runnerGetter.apply(context)).d()))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("numberOfTimes", IntegerArgumentType.integer((int)0)).executes(context -> ((a)runnerGetter.apply(context)).a(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)context, (String)"numberOfTimes"), false)))).then(modifier.apply(net.minecraft.commands.CommandDispatcher.a("untilFailed", BoolArgumentType.bool()).executes(context -> ((a)runnerGetter.apply(context)).a(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)context, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)context, (String)"untilFailed")))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> a(ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder, Function<CommandContext<CommandListenerWrapper>, a> runnerGetter) {
        return GameTestHarnessTestCommand.a(argumentBuilder, runnerGetter, (ArgumentBuilder<CommandListenerWrapper, ?> builder) -> builder);
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> b(ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder, Function<CommandContext<CommandListenerWrapper>, a> runnerGetter) {
        return GameTestHarnessTestCommand.a(argumentBuilder, runnerGetter, (ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder1) -> argumentBuilder1.then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("rotationSteps", IntegerArgumentType.integer()).executes(context -> ((a)runnerGetter.apply(context)).a(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)context, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)context, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)context, (String)"rotationSteps")))).then(net.minecraft.commands.CommandDispatcher.a("testsPerRow", IntegerArgumentType.integer()).executes(context -> ((a)runnerGetter.apply(context)).a(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)context, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)context, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)context, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)context, (String)"testsPerRow"))))));
    }

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder = GameTestHarnessTestCommand.b(net.minecraft.commands.CommandDispatcher.a("onlyRequiredTests", BoolArgumentType.bool()), (CommandContext<CommandListenerWrapper> context) -> n.a((CommandContext<CommandListenerWrapper>)context, BoolArgumentType.getBool((CommandContext)context, (String)"onlyRequiredTests")));
        ArgumentBuilder<CommandListenerWrapper, ?> argumentBuilder1 = GameTestHarnessTestCommand.b(net.minecraft.commands.CommandDispatcher.a("testClassName", GameTestHarnessTestClassArgument.a()), (CommandContext<CommandListenerWrapper> context) -> n.a((CommandContext<CommandListenerWrapper>)context, GameTestHarnessTestClassArgument.a((CommandContext<CommandListenerWrapper>)context, "testClassName")));
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("test").then(net.minecraft.commands.CommandDispatcher.a("run").then(GameTestHarnessTestCommand.b(net.minecraft.commands.CommandDispatcher.a("testName", GameTestHarnessTestFunctionArgument.a()), (CommandContext<CommandListenerWrapper> context) -> n.b((CommandContext<CommandListenerWrapper>)context, "testName"))))).then(net.minecraft.commands.CommandDispatcher.a("runmultiple").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("testName", GameTestHarnessTestFunctionArgument.a()).executes(context -> n.b((CommandContext<CommandListenerWrapper>)context, "testName").d())).then(net.minecraft.commands.CommandDispatcher.a("amount", IntegerArgumentType.integer()).executes(context -> n.a(IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")).b((CommandContext<CommandListenerWrapper>)context, "testName").d()))))).then(GameTestHarnessTestCommand.b(net.minecraft.commands.CommandDispatcher.a("runall").then(argumentBuilder1), n::d))).then(GameTestHarnessTestCommand.a(net.minecraft.commands.CommandDispatcher.a("runthese"), n::b))).then(GameTestHarnessTestCommand.a(net.minecraft.commands.CommandDispatcher.a("runclosest"), n::a))).then(GameTestHarnessTestCommand.a(net.minecraft.commands.CommandDispatcher.a("runthat"), n::c))).then(GameTestHarnessTestCommand.b(net.minecraft.commands.CommandDispatcher.a("runfailed").then(argumentBuilder), n::e))).then(net.minecraft.commands.CommandDispatcher.a("verify").then(net.minecraft.commands.CommandDispatcher.a("testName", GameTestHarnessTestFunctionArgument.a()).executes(context -> n.b((CommandContext<CommandListenerWrapper>)context, "testName").f())))).then(net.minecraft.commands.CommandDispatcher.a("verifyclass").then(net.minecraft.commands.CommandDispatcher.a("testClassName", GameTestHarnessTestClassArgument.a()).executes(context -> n.a((CommandContext<CommandListenerWrapper>)context, GameTestHarnessTestClassArgument.a((CommandContext<CommandListenerWrapper>)context, "testClassName")).f())))).then(net.minecraft.commands.CommandDispatcher.a("locate").then(net.minecraft.commands.CommandDispatcher.a("testName", GameTestHarnessTestFunctionArgument.a()).executes(context -> n.c((CommandContext<CommandListenerWrapper>)context, "minecraft:" + GameTestHarnessTestFunctionArgument.a((CommandContext<CommandListenerWrapper>)context, "testName").d()).e())))).then(net.minecraft.commands.CommandDispatcher.a("resetclosest").executes(context -> n.a((CommandContext<CommandListenerWrapper>)context).a()))).then(net.minecraft.commands.CommandDispatcher.a("resetthese").executes(context -> n.b((CommandContext<CommandListenerWrapper>)context).a()))).then(net.minecraft.commands.CommandDispatcher.a("resetthat").executes(context -> n.c((CommandContext<CommandListenerWrapper>)context).a()))).then(net.minecraft.commands.CommandDispatcher.a("export").then(net.minecraft.commands.CommandDispatcher.a("testName", StringArgumentType.word()).executes(context -> GameTestHarnessTestCommand.b((CommandListenerWrapper)context.getSource(), "minecraft:" + StringArgumentType.getString((CommandContext)context, (String)"testName")))))).then(net.minecraft.commands.CommandDispatcher.a("exportclosest").executes(context -> n.a((CommandContext<CommandListenerWrapper>)context).c()))).then(net.minecraft.commands.CommandDispatcher.a("exportthese").executes(context -> n.b((CommandContext<CommandListenerWrapper>)context).c()))).then(net.minecraft.commands.CommandDispatcher.a("exportthat").executes(context -> n.c((CommandContext<CommandListenerWrapper>)context).c()))).then(net.minecraft.commands.CommandDispatcher.a("clearthat").executes(context -> n.c((CommandContext<CommandListenerWrapper>)context).b()))).then(net.minecraft.commands.CommandDispatcher.a("clearthese").executes(context -> n.b((CommandContext<CommandListenerWrapper>)context).b()))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("clearall").executes(context -> n.a((CommandContext<CommandListenerWrapper>)context, 200).b())).then(net.minecraft.commands.CommandDispatcher.a("radius", IntegerArgumentType.integer()).executes(context -> n.a((CommandContext<CommandListenerWrapper>)context, MathHelper.a(IntegerArgumentType.getInteger((CommandContext)context, (String)"radius"), 0, 1024)).b())))).then(net.minecraft.commands.CommandDispatcher.a("import").then(net.minecraft.commands.CommandDispatcher.a("testName", StringArgumentType.word()).executes(context -> GameTestHarnessTestCommand.d((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"testName")))))).then(net.minecraft.commands.CommandDispatcher.a("stop").executes(context -> GameTestHarnessTestCommand.a()))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("pos").executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), "pos"))).then(net.minecraft.commands.CommandDispatcher.a("var", StringArgumentType.word()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"var")))))).then(net.minecraft.commands.CommandDispatcher.a("create").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("testName", StringArgumentType.word()).suggests(GameTestHarnessTestFunctionArgument::a).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"testName"), 5, 5, 5))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("width", IntegerArgumentType.integer()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width")))).then(net.minecraft.commands.CommandDispatcher.a("height", IntegerArgumentType.integer()).then(net.minecraft.commands.CommandDispatcher.a("depth", IntegerArgumentType.integer()).executes(context -> GameTestHarnessTestCommand.a((CommandListenerWrapper)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"height"), IntegerArgumentType.getInteger((CommandContext)context, (String)"depth"))))))))));
    }

    private static int a(GameTestHarnessInfo gameTestInfo) {
        gameTestInfo.g().a_(null, gameTestInfo.e()).stream().forEach(entity -> entity.remove(Entity.RemovalReason.b, EntityRemoveEvent.Cause.DISCARD));
        gameTestInfo.f().c(gameTestInfo.g());
        GameTestHarnessStructures.a(gameTestInfo.e(), gameTestInfo.g());
        GameTestHarnessTestCommand.a(gameTestInfo.g(), "Reset succeded for: " + gameTestInfo.b(), EnumChatFormat.k);
        return 1;
    }

    static Stream<GameTestHarnessInfo> a(CommandListenerWrapper source, RetryOptions retryOptions, StructureBlockPosFinder structureBlockPosFinder) {
        return structureBlockPosFinder.findStructureBlockPos().map(blockPos -> GameTestHarnessTestCommand.a(blockPos, source.e(), retryOptions)).flatMap(Optional::stream);
    }

    static Stream<GameTestHarnessInfo> a(CommandListenerWrapper source, RetryOptions retryOptions, TestFunctionFinder testFunctionFinder, int rotationSteps) {
        return testFunctionFinder.findTestFunctions().filter(function -> GameTestHarnessTestCommand.a(source.e(), function.d())).map(function -> new GameTestHarnessInfo((GameTestHarnessTestFunction)function, GameTestHarnessStructures.a(rotationSteps), source.e(), retryOptions));
    }

    private static Optional<GameTestHarnessInfo> a(BlockPosition pos, WorldServer level, RetryOptions retryOptions) {
        TileEntityStructure structureBlockEntity = (TileEntityStructure)level.c_(pos);
        if (structureBlockEntity == null) {
            GameTestHarnessTestCommand.a(level, m, EnumChatFormat.m);
            return Optional.empty();
        }
        String metaData = structureBlockEntity.t();
        Optional<GameTestHarnessTestFunction> optional = GameTestHarnessRegistry.e(metaData);
        if (optional.isEmpty()) {
            GameTestHarnessTestCommand.a(level, "Test function for test " + metaData + " could not be found", EnumChatFormat.m);
            return Optional.empty();
        }
        GameTestHarnessTestFunction testFunction = optional.get();
        GameTestHarnessInfo gameTestInfo = new GameTestHarnessInfo(testFunction, structureBlockEntity.s(), level, retryOptions);
        gameTestInfo.a(pos);
        return !GameTestHarnessTestCommand.a(level, gameTestInfo.t()) ? Optional.empty() : Optional.of(gameTestInfo);
    }

    private static int a(CommandListenerWrapper source, String structureName, int x2, int y2, int z2) {
        if (x2 <= 48 && y2 <= 48 && z2 <= 48) {
            WorldServer level = source.e();
            BlockPosition blockPos = GameTestHarnessTestCommand.a(source).e();
            GameTestHarnessStructures.a(structureName.toLowerCase(), blockPos, new BaseBlockPosition(x2, y2, z2), EnumBlockRotation.a, level);
            BlockPosition blockPos1 = blockPos.d();
            BlockPosition blockPos2 = blockPos1.b(x2 - 1, 0, z2 - 1);
            BlockPosition.d(blockPos1, blockPos2).forEach(pos -> level.b((BlockPosition)pos, Blocks.I.m()));
            GameTestHarnessStructures.a(blockPos, new BlockPosition(1, 0, -1), EnumBlockRotation.a, level);
            return 0;
        }
        throw new IllegalArgumentException("The structure must be less than 48 blocks big in each axis");
    }

    private static int a(CommandListenerWrapper source, String variableName) throws CommandSyntaxException {
        WorldServer level;
        MovingObjectPositionBlock blockHitResult = (MovingObjectPositionBlock)source.h().a(10.0, 1.0f, false);
        BlockPosition blockPos = blockHitResult.b();
        Optional<BlockPosition> optional = GameTestHarnessStructures.a(blockPos, 15, level = source.e());
        if (optional.isEmpty()) {
            optional = GameTestHarnessStructures.a(blockPos, 200, level);
        }
        if (optional.isEmpty()) {
            source.b(IChatBaseComponent.b("Can't find a structure block that contains the targeted pos " + String.valueOf(blockPos)));
            return 0;
        }
        TileEntityStructure structureBlockEntity = (TileEntityStructure)level.c_(optional.get());
        if (structureBlockEntity == null) {
            GameTestHarnessTestCommand.a(level, m, EnumChatFormat.m);
            return 0;
        }
        BlockPosition blockPos1 = blockPos.b(optional.get());
        String string = blockPos1.u() + ", " + blockPos1.v() + ", " + blockPos1.w();
        String metaData = structureBlockEntity.t();
        IChatMutableComponent component = IChatBaseComponent.b(string).b(ChatModifier.a.a(true).a(EnumChatFormat.k).a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, IChatBaseComponent.b("Click to copy to clipboard"))).a(new ChatClickable(ChatClickable.EnumClickAction.f, "final BlockPos " + variableName + " = new BlockPos(" + string + ");")));
        source.a(() -> IChatBaseComponent.b("Position relative to " + metaData + ": ").b(component), false);
        PacketDebug.a(level, new BlockPosition(blockPos), string, -2147418368, 10000);
        return 1;
    }

    static int a() {
        GameTestHarnessTicker.a.a();
        return 1;
    }

    static int a(CommandListenerWrapper source, WorldServer level, GameTestHarnessRunner runner) {
        runner.a(new b(source));
        GameTestHarnessCollector multipleTestTracker = new GameTestHarnessCollector(runner.a());
        multipleTestTracker.a(new c(level, multipleTestTracker));
        multipleTestTracker.a(testInfo -> GameTestHarnessRegistry.a(testInfo.v()));
        runner.b();
        return 1;
    }

    static int a(CommandListenerWrapper source, TileEntityStructure structureBlockEntity) {
        String structureName = structureBlockEntity.c();
        if (!structureBlockEntity.b(true)) {
            GameTestHarnessTestCommand.c(source, "Failed to save structure " + structureName);
        }
        return GameTestHarnessTestCommand.b(source, structureName);
    }

    private static int b(CommandListenerWrapper source, String structurePath) {
        Path path = Paths.get(GameTestHarnessStructures.c, new String[0]);
        MinecraftKey resourceLocation = MinecraftKey.a(structurePath);
        Path path1 = source.e().r().a(resourceLocation, ".nbt");
        Path path2 = DebugReportNBT.a(CachedOutput.a, path1, resourceLocation.a(), path);
        if (path2 == null) {
            GameTestHarnessTestCommand.c(source, "Failed to export " + String.valueOf(path1));
            return 1;
        }
        try {
            FileUtils.c(path2.getParent());
        }
        catch (IOException var7) {
            GameTestHarnessTestCommand.c(source, "Could not create folder " + String.valueOf(path2.getParent()));
            e.error("Could not create export folder", (Throwable)var7);
            return 1;
        }
        GameTestHarnessTestCommand.c(source, "Exported " + structurePath + " to " + String.valueOf(path2.toAbsolutePath()));
        return 0;
    }

    private static boolean a(WorldServer level, String structure) {
        if (level.r().b(MinecraftKey.a(structure)).isEmpty()) {
            GameTestHarnessTestCommand.a(level, "Test structure " + structure + " could not be found", EnumChatFormat.m);
            return false;
        }
        return true;
    }

    static BlockPosition a(CommandListenerWrapper source) {
        BlockPosition blockPos = BlockPosition.a(source.d());
        int y2 = source.e().a(HeightMap.Type.b, blockPos).v();
        return new BlockPosition(blockPos.u(), y2 + 1, blockPos.w() + 3);
    }

    static void c(CommandListenerWrapper source, String message) {
        source.a(() -> IChatBaseComponent.b(message), false);
    }

    private static int d(CommandListenerWrapper source, String structurePath) {
        Path path = Paths.get(GameTestHarnessStructures.c, structurePath + ".snbt");
        MinecraftKey resourceLocation = MinecraftKey.b(structurePath);
        Path path1 = source.e().r().a(resourceLocation, ".nbt");
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            String string = IOUtils.toString((Reader)bufferedReader);
            Files.createDirectories(path1.getParent(), new FileAttribute[0]);
            try (OutputStream outputStream = Files.newOutputStream(path1, new OpenOption[0]);){
                NBTCompressedStreamTools.a(GameProfileSerializer.a(string), outputStream);
            }
            source.e().r().d(resourceLocation);
            GameTestHarnessTestCommand.c(source, "Imported to " + String.valueOf(path1.toAbsolutePath()));
            return 0;
        }
        catch (CommandSyntaxException | IOException var12) {
            e.error("Failed to load structure {}", (Object)structurePath, (Object)var12);
            return 1;
        }
    }

    static void a(WorldServer serverLevel, String message, EnumChatFormat formatting) {
        serverLevel.a(player -> true).forEach(player -> player.a(IChatBaseComponent.b(message).a(formatting)));
    }

    record b(CommandListenerWrapper a) implements GameTestBatchListener
    {
        @Override
        public void a(GameTestHarnessBatch batch) {
            GameTestHarnessTestCommand.c(this.a, "Starting batch: " + batch.a());
        }

        @Override
        public void b(GameTestHarnessBatch batch) {
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "source", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "source", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "source", "a"}, this, o2);
        }
    }

    public record c(WorldServer a, GameTestHarnessCollector b) implements GameTestHarnessListener
    {
        @Override
        public void a(GameTestHarnessInfo testInfo) {
        }

        @Override
        public void a(GameTestHarnessInfo test, GameTestHarnessRunner runner) {
            net.minecraft.gametest.framework.GameTestHarnessTestCommand$c.a(this.a, this.b);
        }

        @Override
        public void b(GameTestHarnessInfo test, GameTestHarnessRunner runner) {
            net.minecraft.gametest.framework.GameTestHarnessTestCommand$c.a(this.a, this.b);
        }

        @Override
        public void a(GameTestHarnessInfo oldTest, GameTestHarnessInfo newTest, GameTestHarnessRunner runner) {
            this.b.a(newTest);
        }

        private static void a(WorldServer level, GameTestHarnessCollector tracker) {
            if (tracker.i()) {
                GameTestHarnessTestCommand.a(level, "GameTest done! " + tracker.h() + " tests were run", EnumChatFormat.p);
                if (tracker.d()) {
                    GameTestHarnessTestCommand.a(level, tracker.a() + " required tests failed :(", EnumChatFormat.m);
                } else {
                    GameTestHarnessTestCommand.a(level, "All required tests passed :)", EnumChatFormat.k);
                }
                if (tracker.e()) {
                    GameTestHarnessTestCommand.a(level, tracker.b() + " optional tests failed", EnumChatFormat.h);
                }
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "level;tracker", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "level;tracker", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "level;tracker", "a", "b"}, this, o2);
        }
    }

    public static class a {
        private final TestFinder<a> a;

        public a(TestFinder<a> finder) {
            this.a = finder;
        }

        public int a() {
            GameTestHarnessTestCommand.a();
            return GameTestHarnessTestCommand.a(this.a.a(), RetryOptions.a(), this.a).map(GameTestHarnessTestCommand::a).toList().isEmpty() ? 0 : 1;
        }

        private <T> void a(Stream<T> structureBlockPos, ToIntFunction<T> testCounter, Runnable onFail, Consumer<Integer> onSuccess) {
            int i2 = structureBlockPos.mapToInt(testCounter).sum();
            if (i2 == 0) {
                onFail.run();
            } else {
                onSuccess.accept(i2);
            }
        }

        public int b() {
            GameTestHarnessTestCommand.a();
            CommandListenerWrapper commandSourceStack = this.a.a();
            WorldServer level = commandSourceStack.e();
            GameTestHarnessRunner.a(level);
            this.a(this.a.findStructureBlockPos(), pos -> {
                TileEntityStructure structureBlockEntity = (TileEntityStructure)level.c_((BlockPosition)pos);
                if (structureBlockEntity == null) {
                    return 0;
                }
                StructureBoundingBox structureBoundingBox = GameTestHarnessStructures.b(structureBlockEntity);
                GameTestHarnessStructures.a(structureBoundingBox, level);
                return 1;
            }, () -> GameTestHarnessTestCommand.a(level, "Could not find any structures to clear", EnumChatFormat.m), integer -> GameTestHarnessTestCommand.c(commandSourceStack, "Cleared " + integer + " structures"));
            return 1;
        }

        public int c() {
            MutableBoolean mutableBoolean = new MutableBoolean(true);
            CommandListenerWrapper commandSourceStack = this.a.a();
            WorldServer level = commandSourceStack.e();
            this.a(this.a.findStructureBlockPos(), pos -> {
                TileEntityStructure structureBlockEntity = (TileEntityStructure)level.c_((BlockPosition)pos);
                if (structureBlockEntity == null) {
                    GameTestHarnessTestCommand.a(level, GameTestHarnessTestCommand.m, EnumChatFormat.m);
                    mutableBoolean.setFalse();
                    return 0;
                }
                if (GameTestHarnessTestCommand.a(commandSourceStack, structureBlockEntity) != 0) {
                    mutableBoolean.setFalse();
                }
                return 1;
            }, () -> GameTestHarnessTestCommand.a(level, "Could not find any structures to export", EnumChatFormat.m), integer -> GameTestHarnessTestCommand.c(commandSourceStack, "Exported " + integer + " structures"));
            return mutableBoolean.getValue() != false ? 0 : 1;
        }

        int f() {
            GameTestHarnessTestCommand.a();
            CommandListenerWrapper commandSourceStack = this.a.a();
            WorldServer level = commandSourceStack.e();
            BlockPosition blockPos = GameTestHarnessTestCommand.a(commandSourceStack);
            List<GameTestHarnessInfo> collection = Stream.concat(GameTestHarnessTestCommand.a(commandSourceStack, RetryOptions.a(), this.a), GameTestHarnessTestCommand.a(commandSourceStack, RetryOptions.a(), this.a, 0)).toList();
            GameTestHarnessRunner.a(level);
            GameTestHarnessRegistry.d();
            ArrayList<GameTestHarnessBatch> collection1 = new ArrayList<GameTestHarnessBatch>();
            for (GameTestHarnessInfo gameTestInfo : collection) {
                for (EnumBlockRotation rotation : EnumBlockRotation.values()) {
                    ArrayList<GameTestHarnessInfo> collection2 = new ArrayList<GameTestHarnessInfo>();
                    for (int i2 = 0; i2 < 100; ++i2) {
                        GameTestHarnessInfo gameTestInfo1 = new GameTestHarnessInfo(gameTestInfo.v(), rotation, level, new RetryOptions(1, true));
                        collection2.add(gameTestInfo1);
                    }
                    GameTestHarnessBatch gameTestBatch = GameTestBatchFactory.a(collection2, gameTestInfo.v().b(), (long)rotation.ordinal());
                    collection1.add(gameTestBatch);
                }
            }
            StructureGridSpawner structureGridSpawner = new StructureGridSpawner(blockPos, 10, true);
            GameTestHarnessRunner gameTestRunner = GameTestHarnessRunner.a.a(collection1, level).a(GameTestBatchFactory.a(100)).a((GameTestHarnessRunner.c)structureGridSpawner).a(structureGridSpawner).a(true).a();
            return GameTestHarnessTestCommand.a(commandSourceStack, level, gameTestRunner);
        }

        public int a(RetryOptions retryOptions, int rotationSteps, int testsPerRow) {
            GameTestHarnessTestCommand.a();
            CommandListenerWrapper commandSourceStack = this.a.a();
            WorldServer level = commandSourceStack.e();
            BlockPosition blockPos = GameTestHarnessTestCommand.a(commandSourceStack);
            List<GameTestHarnessInfo> collection = Stream.concat(GameTestHarnessTestCommand.a(commandSourceStack, retryOptions, this.a), GameTestHarnessTestCommand.a(commandSourceStack, retryOptions, this.a, rotationSteps)).toList();
            if (collection.isEmpty()) {
                GameTestHarnessTestCommand.c(commandSourceStack, "No tests found");
                return 0;
            }
            GameTestHarnessRunner.a(level);
            GameTestHarnessRegistry.d();
            GameTestHarnessTestCommand.c(commandSourceStack, "Running " + collection.size() + " tests...");
            GameTestHarnessRunner gameTestRunner = GameTestHarnessRunner.a.b(collection, level).a((GameTestHarnessRunner.c)new StructureGridSpawner(blockPos, testsPerRow, false)).a();
            return GameTestHarnessTestCommand.a(commandSourceStack, level, gameTestRunner);
        }

        public int a(int rotationSteps, int testsPerRow) {
            return this.a(RetryOptions.a(), rotationSteps, testsPerRow);
        }

        public int a(int rotationSteps) {
            return this.a(RetryOptions.a(), rotationSteps, 8);
        }

        public int a(RetryOptions retryOptions, int rotationSteps) {
            return this.a(retryOptions, rotationSteps, 8);
        }

        public int a(RetryOptions retryOptions) {
            return this.a(retryOptions, 0, 8);
        }

        public int d() {
            return this.a(RetryOptions.a());
        }

        public int e() {
            GameTestHarnessTestCommand.c(this.a.a(), "Started locating test structures, this might take a while..");
            MutableInt mutableInt = new MutableInt(0);
            BlockPosition blockPos = BlockPosition.a(this.a.a().d());
            this.a.findStructureBlockPos().forEach(pos -> {
                TileEntityStructure structureBlockEntity = (TileEntityStructure)this.a.a().e().c_((BlockPosition)pos);
                if (structureBlockEntity != null) {
                    EnumDirection direction = structureBlockEntity.s().a(EnumDirection.c);
                    BlockPosition blockPos1 = structureBlockEntity.aA_().a(direction, 2);
                    int i1 = (int)direction.g().p();
                    String string = String.format("/tp @s %d %d %d %d 0", blockPos1.u(), blockPos1.v(), blockPos1.w(), i1);
                    int i2 = blockPos.u() - pos.u();
                    int i3 = blockPos.w() - pos.w();
                    int floor = MathHelper.d(MathHelper.c((float)(i2 * i2 + i3 * i3)));
                    IChatMutableComponent component = ChatComponentUtils.a(IChatBaseComponent.a("chat.coordinates", pos.u(), pos.v(), pos.w())).a(style -> style.a(EnumChatFormat.k).a(new ChatClickable(ChatClickable.EnumClickAction.d, string)).a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, IChatBaseComponent.c("chat.coordinates.tooltip"))));
                    IChatMutableComponent component1 = IChatBaseComponent.b("Found structure at: ").b(component).f(" (distance: " + floor + ")");
                    this.a.a().a(() -> component1, false);
                    mutableInt.increment();
                }
            });
            int i2 = mutableInt.intValue();
            if (i2 == 0) {
                GameTestHarnessTestCommand.a(this.a.a().e(), "No such test structure found", EnumChatFormat.m);
                return 0;
            }
            GameTestHarnessTestCommand.a(this.a.a().e(), "Finished locating, found " + i2 + " structure(s)", EnumChatFormat.k);
            return 1;
        }
    }
}

