/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class GameTestHarnessStructures {
    private static final Logger d = LogUtils.getLogger();
    public static final int a = 10;
    public static final String b = "gameteststructures";
    public static String c = "gameteststructures";

    public static EnumBlockRotation a(int rotationSteps) {
        switch (rotationSteps) {
            case 0: {
                return EnumBlockRotation.a;
            }
            case 1: {
                return EnumBlockRotation.b;
            }
            case 2: {
                return EnumBlockRotation.c;
            }
            case 3: {
                return EnumBlockRotation.d;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + rotationSteps);
    }

    public static int a(EnumBlockRotation rotation) {
        switch (rotation) {
            case a: {
                return 0;
            }
            case b: {
                return 1;
            }
            case c: {
                return 2;
            }
            case d: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + String.valueOf(rotation));
    }

    public static AxisAlignedBB a(TileEntityStructure structureBlockEntity) {
        return AxisAlignedBB.a(GameTestHarnessStructures.b(structureBlockEntity));
    }

    public static StructureBoundingBox b(TileEntityStructure structureBlockEntity) {
        BlockPosition structureOrigin = GameTestHarnessStructures.c(structureBlockEntity);
        BlockPosition transformedFarCorner = GameTestHarnessStructures.a(structureOrigin, structureBlockEntity.j(), structureBlockEntity.s());
        return StructureBoundingBox.a(structureOrigin, transformedFarCorner);
    }

    public static BlockPosition c(TileEntityStructure structureBlockEntity) {
        return structureBlockEntity.aA_().a(structureBlockEntity.f());
    }

    public static void a(BlockPosition structureBlockPos, BlockPosition offset, EnumBlockRotation rotation, WorldServer serverLevel) {
        BlockPosition blockPos = DefinedStructure.a(structureBlockPos.a(offset), EnumBlockMirror.a, rotation, structureBlockPos);
        serverLevel.b(blockPos, Blocks.gi.m());
        TileEntityCommand commandBlockEntity = (TileEntityCommand)serverLevel.c_(blockPos);
        commandBlockEntity.b().a("test runclosest");
        BlockPosition blockPos1 = DefinedStructure.a(blockPos.b(0, 0, -1), EnumBlockMirror.a, rotation, blockPos);
        serverLevel.b(blockPos1, Blocks.dZ.m().a(rotation));
    }

    public static void a(String structureName, BlockPosition pos, BaseBlockPosition size, EnumBlockRotation rotation, WorldServer serverLevel) {
        StructureBoundingBox structureBoundingBox = GameTestHarnessStructures.b(pos.d(), size, rotation);
        GameTestHarnessStructures.a(structureBoundingBox, serverLevel);
        serverLevel.b(pos, Blocks.pC.m());
        TileEntityStructure structureBlockEntity = (TileEntityStructure)serverLevel.c_(pos);
        structureBlockEntity.a(false);
        structureBlockEntity.a(MinecraftKey.a(structureName));
        structureBlockEntity.b(structureName);
        structureBlockEntity.a(size);
        structureBlockEntity.a(BlockPropertyStructureMode.a);
        structureBlockEntity.e(true);
    }

    public static BlockPosition a(GameTestHarnessInfo gameTestInfo, BlockPosition pos, EnumBlockRotation rotation, WorldServer level) {
        BlockPosition blockPos;
        BaseBlockPosition size = level.r().b(MinecraftKey.a(gameTestInfo.t())).orElseThrow(() -> new IllegalStateException("Missing test structure: " + gameTestInfo.t())).a();
        if (rotation == EnumBlockRotation.a) {
            blockPos = pos;
        } else if (rotation == EnumBlockRotation.b) {
            blockPos = pos.b(size.w() - 1, 0, 0);
        } else if (rotation == EnumBlockRotation.c) {
            blockPos = pos.b(size.u() - 1, 0, size.w() - 1);
        } else {
            if (rotation != EnumBlockRotation.d) {
                throw new IllegalArgumentException("Invalid rotation: " + String.valueOf(rotation));
            }
            blockPos = pos.b(0, 0, size.u() - 1);
        }
        return blockPos;
    }

    public static TileEntityStructure b(GameTestHarnessInfo gameTestInfo, BlockPosition pos, EnumBlockRotation rotation, WorldServer level) {
        BaseBlockPosition size = level.r().b(MinecraftKey.a(gameTestInfo.t())).orElseThrow(() -> new IllegalStateException("Missing test structure: " + gameTestInfo.t())).a();
        StructureBoundingBox structureBoundingBox = GameTestHarnessStructures.b(pos, size, rotation);
        BlockPosition startCorner = GameTestHarnessStructures.a(gameTestInfo, pos, rotation, level);
        GameTestHarnessStructures.b(structureBoundingBox, level);
        GameTestHarnessStructures.a(structureBoundingBox, level);
        return GameTestHarnessStructures.c(gameTestInfo, startCorner.e(), rotation, level);
    }

    public static void a(AxisAlignedBB bounds, WorldServer level, boolean placeBarriers) {
        BlockPosition blockPos = BlockPosition.a(bounds.a, bounds.b, bounds.c).b(-1, 0, -1);
        BlockPosition blockPos1 = BlockPosition.a(bounds.d, bounds.e, bounds.f);
        BlockPosition.d(blockPos, blockPos1).forEach(blockPos2 -> {
            boolean flag1;
            boolean flag = blockPos2.u() == blockPos.u() || blockPos2.u() == blockPos1.u() || blockPos2.w() == blockPos.w() || blockPos2.w() == blockPos1.w();
            boolean bl = flag1 = blockPos2.v() == blockPos1.v();
            if (flag || flag1 && placeBarriers) {
                level.b((BlockPosition)blockPos2, Blocks.iu.m());
            }
        });
    }

    public static void a(AxisAlignedBB bounds, WorldServer level) {
        BlockPosition blockPos = BlockPosition.a(bounds.a, bounds.b, bounds.c).b(-1, 0, -1);
        BlockPosition blockPos1 = BlockPosition.a(bounds.d, bounds.e, bounds.f);
        BlockPosition.d(blockPos, blockPos1).forEach(blockPos2 -> {
            boolean flag1;
            boolean flag = blockPos2.u() == blockPos.u() || blockPos2.u() == blockPos1.u() || blockPos2.w() == blockPos.w() || blockPos2.w() == blockPos1.w();
            boolean bl = flag1 = blockPos2.v() == blockPos1.v();
            if (level.a_((BlockPosition)blockPos2).a(Blocks.iu) && (flag || flag1)) {
                level.b((BlockPosition)blockPos2, Blocks.a.m());
            }
        });
    }

    private static void b(StructureBoundingBox boundingBox, WorldServer level) {
        boundingBox.b().forEach(chunkPos -> level.a(chunkPos.h, chunkPos.i, true));
    }

    public static void a(StructureBoundingBox boundingBox, WorldServer level) {
        int i2 = boundingBox.i() - 1;
        StructureBoundingBox boundingBox1 = new StructureBoundingBox(boundingBox.h() - 2, boundingBox.i() - 3, boundingBox.j() - 3, boundingBox.k() + 3, boundingBox.l() + 20, boundingBox.m() + 3);
        BlockPosition.a(boundingBox1).forEach(blockPos -> GameTestHarnessStructures.a(i2, blockPos, level));
        level.n().a(boundingBox1);
        level.a(boundingBox1);
        AxisAlignedBB aabb = AxisAlignedBB.a(boundingBox1);
        List<Entity> entitiesOfClass = level.a(Entity.class, aabb, entity -> !(entity instanceof EntityHuman));
        entitiesOfClass.forEach(entity -> entity.discard(EntityRemoveEvent.Cause.DISCARD));
    }

    public static BlockPosition a(BlockPosition pos, BaseBlockPosition offset, EnumBlockRotation rotation) {
        BlockPosition blockPos = pos.a(offset).b(-1, -1, -1);
        return DefinedStructure.a(blockPos, EnumBlockMirror.a, rotation, pos);
    }

    public static StructureBoundingBox b(BlockPosition pos, BaseBlockPosition offset, EnumBlockRotation rotation) {
        BlockPosition transformedFarCorner = GameTestHarnessStructures.a(pos, offset, rotation);
        StructureBoundingBox boundingBox = StructureBoundingBox.a(pos, transformedFarCorner);
        int min = Math.min(boundingBox.h(), boundingBox.k());
        int min1 = Math.min(boundingBox.j(), boundingBox.m());
        return boundingBox.a(pos.u() - min, 0, pos.w() - min1);
    }

    public static Optional<BlockPosition> a(BlockPosition pos, int radius, WorldServer serverLevel) {
        return GameTestHarnessStructures.c(pos, radius, serverLevel).filter(blockPos -> GameTestHarnessStructures.a(blockPos, pos, serverLevel)).findFirst();
    }

    public static Optional<BlockPosition> b(BlockPosition pos, int radius, WorldServer level) {
        Comparator<BlockPosition> comparator = Comparator.comparingInt(blockPos -> blockPos.k(pos));
        return GameTestHarnessStructures.c(pos, radius, level).min(comparator);
    }

    public static Stream<BlockPosition> a(BlockPosition pos, int radius, WorldServer level, String testName) {
        return GameTestHarnessStructures.c(pos, radius, level).map(blockPos -> (TileEntityStructure)level.c_((BlockPosition)blockPos)).filter(Objects::nonNull).filter(structureBlockEntity -> Objects.equals(structureBlockEntity.c(), testName)).map(TileEntity::aA_).map(BlockPosition::j);
    }

    public static Stream<BlockPosition> c(BlockPosition pos, int radius, WorldServer level) {
        StructureBoundingBox boundingBoxAtGround = GameTestHarnessStructures.d(pos, radius, level);
        return BlockPosition.a(boundingBoxAtGround).filter(blockPos -> level.a_((BlockPosition)blockPos).a(Blocks.pC)).map(BlockPosition::j);
    }

    private static TileEntityStructure c(GameTestHarnessInfo gameTestInfo, BlockPosition pos, EnumBlockRotation rotation, WorldServer level) {
        level.b(pos, Blocks.pC.m());
        TileEntityStructure structureBlockEntity = (TileEntityStructure)level.c_(pos);
        structureBlockEntity.a(BlockPropertyStructureMode.b);
        structureBlockEntity.a(rotation);
        structureBlockEntity.a(false);
        structureBlockEntity.a(MinecraftKey.a(gameTestInfo.t()));
        structureBlockEntity.b(gameTestInfo.b());
        if (!structureBlockEntity.b(level)) {
            throw new RuntimeException("Failed to load structure info for test: " + gameTestInfo.b() + ". Structure name: " + gameTestInfo.t());
        }
        return structureBlockEntity;
    }

    private static StructureBoundingBox d(BlockPosition pos, int radius, WorldServer level) {
        BlockPosition blockPos = BlockPosition.a((double)pos.u(), (double)level.a(HeightMap.Type.b, pos).v(), (double)pos.w());
        return new StructureBoundingBox(blockPos).c(radius, 10, radius);
    }

    public static Stream<BlockPosition> a(BlockPosition pos, Entity entity, WorldServer level) {
        int i2 = 200;
        Vec3D eyePosition = entity.bF();
        Vec3D vec3 = eyePosition.e(entity.bT().c(200.0));
        return GameTestHarnessStructures.c(pos, 200, level).map(blockPos -> level.a((BlockPosition)blockPos, TileEntityTypes.v)).flatMap(Optional::stream).filter(structureBlockEntity -> GameTestHarnessStructures.a(structureBlockEntity).b(eyePosition, vec3).isPresent()).map(TileEntity::aA_).sorted(Comparator.comparing(pos::j)).limit(1L);
    }

    private static void a(int structureBlockY, BlockPosition pos, WorldServer serverLevel) {
        IBlockData blockState = pos.v() < structureBlockY ? Blocks.b.m() : Blocks.a.m();
        ArgumentTileLocation blockInput = new ArgumentTileLocation(blockState, Collections.emptySet(), null);
        blockInput.a(serverLevel, pos, 2);
        serverLevel.b(pos, blockState.b());
    }

    private static boolean a(BlockPosition structureBlockPos, BlockPosition posToTest, WorldServer serverLevel) {
        TileEntityStructure structureBlockEntity = (TileEntityStructure)serverLevel.c_(structureBlockPos);
        return GameTestHarnessStructures.b(structureBlockEntity).b(posToTest);
    }
}

