/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.gametest.framework.AfterBatch;
import net.minecraft.gametest.framework.BeforeBatch;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.EnumBlockRotation;

public class GameTestHarnessRegistry {
    private static final Collection<GameTestHarnessTestFunction> a = Lists.newArrayList();
    private static final Set<String> b = Sets.newHashSet();
    private static final Map<String, Consumer<WorldServer>> c = Maps.newHashMap();
    private static final Map<String, Consumer<WorldServer>> d = Maps.newHashMap();
    private static final Set<GameTestHarnessTestFunction> e = Sets.newHashSet();

    public static void a(Class<?> testClass) {
        Arrays.stream(testClass.getDeclaredMethods()).sorted(Comparator.comparing(Method::getName)).forEach(GameTestHarnessRegistry::a);
    }

    public static void a(Method testMethod) {
        GameTestGenerator gameTestGenerator;
        String simpleName = testMethod.getDeclaringClass().getSimpleName();
        GameTest gameTest = testMethod.getAnnotation(GameTest.class);
        if (gameTest != null) {
            a.add(GameTestHarnessRegistry.c(testMethod));
            b.add(simpleName);
        }
        if ((gameTestGenerator = testMethod.getAnnotation(GameTestGenerator.class)) != null) {
            a.addAll(GameTestHarnessRegistry.b(testMethod));
            b.add(simpleName);
        }
        GameTestHarnessRegistry.a(testMethod, BeforeBatch.class, BeforeBatch::a, c);
        GameTestHarnessRegistry.a(testMethod, AfterBatch.class, AfterBatch::a, d);
    }

    private static <T extends Annotation> void a(Method testMethod, Class<T> annotationType, Function<T, String> valueGetter, Map<String, Consumer<WorldServer>> positioning) {
        String string;
        Consumer<?> consumer;
        T annotation = testMethod.getAnnotation(annotationType);
        if (annotation != null && (consumer = positioning.putIfAbsent(string = valueGetter.apply(annotation), GameTestHarnessRegistry.d(testMethod))) != null) {
            throw new RuntimeException("Hey, there should only be one " + String.valueOf(annotationType) + " method per batch. Batch '" + string + "' has more than one!");
        }
    }

    public static Stream<GameTestHarnessTestFunction> a(String className) {
        return a.stream().filter(testFunction -> GameTestHarnessRegistry.a(testFunction, className));
    }

    public static Collection<GameTestHarnessTestFunction> a() {
        return a;
    }

    public static Collection<String> b() {
        return b;
    }

    public static boolean b(String className) {
        return b.contains(className);
    }

    public static Consumer<WorldServer> c(String functionName) {
        return c.getOrDefault(functionName, serverLevel -> {});
    }

    public static Consumer<WorldServer> d(String functionName) {
        return d.getOrDefault(functionName, serverLevel -> {});
    }

    public static Optional<GameTestHarnessTestFunction> e(String testName) {
        return GameTestHarnessRegistry.a().stream().filter(testFunction -> testFunction.c().equalsIgnoreCase(testName)).findFirst();
    }

    public static GameTestHarnessTestFunction f(String testName) {
        Optional<GameTestHarnessTestFunction> optional = GameTestHarnessRegistry.e(testName);
        if (optional.isEmpty()) {
            throw new IllegalArgumentException("Can't find the test function for " + testName);
        }
        return optional.get();
    }

    private static Collection<GameTestHarnessTestFunction> b(Method testMethod) {
        try {
            Object instance = testMethod.getDeclaringClass().newInstance();
            return (Collection)testMethod.invoke(instance, new Object[0]);
        }
        catch (ReflectiveOperationException var2) {
            throw new RuntimeException(var2);
        }
    }

    private static GameTestHarnessTestFunction c(Method testMethod) {
        GameTest gameTest = testMethod.getAnnotation(GameTest.class);
        String simpleName = testMethod.getDeclaringClass().getSimpleName();
        String string = simpleName.toLowerCase();
        String string1 = string + "." + testMethod.getName().toLowerCase();
        String string2 = gameTest.g().isEmpty() ? string1 : string + "." + gameTest.g();
        String string3 = gameTest.b();
        EnumBlockRotation rotationForRotationSteps = GameTestHarnessStructures.a(gameTest.d());
        return new GameTestHarnessTestFunction(string3, string1, string2, rotationForRotationSteps, gameTest.a(), gameTest.h(), gameTest.e(), gameTest.f(), gameTest.j(), gameTest.i(), gameTest.c(), GameTestHarnessRegistry.d(testMethod));
    }

    private static Consumer<?> d(Method testMethod) {
        return object -> {
            try {
                Object instance = testMethod.getDeclaringClass().newInstance();
                testMethod.invoke(instance, object);
            }
            catch (InvocationTargetException var3) {
                if (var3.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)var3.getCause();
                }
                throw new RuntimeException(var3.getCause());
            }
            catch (ReflectiveOperationException var4) {
                throw new RuntimeException(var4);
            }
        };
    }

    private static boolean a(GameTestHarnessTestFunction testFunction, String className) {
        return testFunction.c().toLowerCase().startsWith(className.toLowerCase() + ".");
    }

    public static Stream<GameTestHarnessTestFunction> c() {
        return e.stream();
    }

    public static void a(GameTestHarnessTestFunction testFunction) {
        e.add(testFunction);
    }

    public static void d() {
        e.clear();
    }
}

