/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.biome;

import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.data.worldgen.BiomeSettings;
import net.minecraft.data.worldgen.WorldGenCarvers;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeFog;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.CaveSoundSettings;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class OverworldBiomes {
    protected static final int a = 4159204;
    protected static final int b = 329011;
    private static final int d = 12638463;
    @Nullable
    private static final Music e = null;
    public static final int c = 70;

    protected static int a(float temperature) {
        float f2 = temperature / 3.0f;
        f2 = MathHelper.a(f2, -1.0f, 1.0f);
        return MathHelper.g(0.62222224f - f2 * 0.05f, 0.5f + f2 * 0.1f, 1.0f);
    }

    private static BiomeBase a(boolean hasPercipitation, float temperature, float downfall, BiomeSettingsMobs.a mobSpawnSettings, BiomeSettingsGeneration.a generationSettings, @Nullable Music backgroundMusic) {
        return OverworldBiomes.a(hasPercipitation, temperature, downfall, 4159204, 329011, null, null, mobSpawnSettings, generationSettings, backgroundMusic);
    }

    private static BiomeBase a(boolean hasPrecipitation, float temperature, float downfall, int waterColor, int waterFogColor, @Nullable Integer grassColorOverride, @Nullable Integer foliageColorOverride, BiomeSettingsMobs.a mobSpawnSettings, BiomeSettingsGeneration.a generationSettings, @Nullable Music backgroundMusic) {
        BiomeFog.a builder = new BiomeFog.a().b(waterColor).c(waterFogColor).a(12638463).d(OverworldBiomes.a(temperature)).a(CaveSoundSettings.b).a(backgroundMusic);
        if (grassColorOverride != null) {
            builder.f(grassColorOverride);
        }
        if (foliageColorOverride != null) {
            builder.e(foliageColorOverride);
        }
        return new BiomeBase.a().a(hasPrecipitation).a(temperature).b(downfall).a(builder.b()).a(mobSpawnSettings.a()).a(generationSettings.a()).a();
    }

    private static void a(BiomeSettingsGeneration.a generationSettings) {
        BiomeSettings.a(generationSettings);
        BiomeSettings.av(generationSettings);
        BiomeSettings.b(generationSettings);
        BiomeSettings.c(generationSettings);
        BiomeSettings.ao(generationSettings);
        BiomeSettings.as(generationSettings);
    }

    public static BiomeBase a(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isSpruce) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.a(builder);
        builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.bL, 8, 4, 4));
        builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aX, 4, 2, 3));
        builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aa, 8, 2, 4));
        if (isSpruce) {
            BiomeSettings.c(builder);
        } else {
            BiomeSettings.b(builder);
            BiomeSettings.a(builder, 100, 25, 100, false);
        }
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder1);
        BiomeSettings.m(builder1);
        BiomeSettings.n(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.j(builder1);
        builder1.a(WorldGenStage.Decoration.j, isSpruce ? VegetationPlacements.av : VegetationPlacements.aw);
        BiomeSettings.V(builder1);
        BiomeSettings.U(builder1);
        BiomeSettings.ac(builder1);
        BiomeSettings.ad(builder1);
        BiomeSettings.p(builder1);
        Music music = Musics.a(SoundEffects.qK);
        return OverworldBiomes.a(true, isSpruce ? 0.25f : 0.3f, 0.8f, builder, builder1, music);
    }

    public static BiomeBase a(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.i(builder);
        builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.bL, 8, 2, 4));
        return OverworldBiomes.a(placedFeatures, worldCarvers, 0.8f, false, true, false, builder, Musics.a(SoundEffects.qX));
    }

    public static BiomeBase b(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.i(builder);
        builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aO, 40, 1, 2)).a(EnumCreatureType.a, new BiomeSettingsMobs.c(EntityTypes.aI, 2, 1, 3)).a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aN, 1, 1, 2));
        return OverworldBiomes.a(placedFeatures, worldCarvers, 0.9f, false, false, true, builder, Musics.a(SoundEffects.qW));
    }

    public static BiomeBase c(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.i(builder);
        builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aO, 40, 1, 2)).a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aN, 80, 1, 2)).a(EnumCreatureType.a, new BiomeSettingsMobs.c(EntityTypes.aI, 2, 1, 1));
        return OverworldBiomes.a(placedFeatures, worldCarvers, 0.9f, true, false, true, builder, Musics.a(SoundEffects.qY));
    }

    private static BiomeBase a(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, float downfall, boolean isBambooJungle, boolean isSparse, boolean addBamboo, BiomeSettingsMobs.a mobSpawnSettings, Music backgroudMusic) {
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder);
        BiomeSettings.f(builder);
        BiomeSettings.j(builder);
        if (isBambooJungle) {
            BiomeSettings.r(builder);
        } else {
            if (addBamboo) {
                BiomeSettings.q(builder);
            }
            if (isSparse) {
                BiomeSettings.F(builder);
            } else {
                BiomeSettings.E(builder);
            }
        }
        BiomeSettings.Y(builder);
        BiomeSettings.I(builder);
        BiomeSettings.ac(builder);
        BiomeSettings.ad(builder);
        BiomeSettings.ah(builder);
        if (isSparse) {
            BiomeSettings.ag(builder);
        } else {
            BiomeSettings.af(builder);
        }
        return OverworldBiomes.a(true, 0.95f, downfall, mobSpawnSettings, builder, backgroudMusic);
    }

    public static BiomeBase b(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isForest) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.a(builder);
        builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.ax, 5, 4, 6));
        BiomeSettings.c(builder);
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.j(builder1);
        if (isForest) {
            BiomeSettings.D(builder1);
        } else {
            BiomeSettings.C(builder1);
        }
        BiomeSettings.V(builder1);
        BiomeSettings.Z(builder1);
        BiomeSettings.ac(builder1);
        BiomeSettings.ad(builder1);
        BiomeSettings.h(builder1);
        BiomeSettings.i(builder1);
        return OverworldBiomes.a(true, 0.2f, 0.3f, builder, builder1, e);
    }

    public static BiomeBase d(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.f(builder);
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        BiomeSettings.al(builder1);
        OverworldBiomes.a(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.j(builder1);
        BiomeSettings.V(builder1);
        BiomeSettings.Z(builder1);
        BiomeSettings.T(builder1);
        BiomeSettings.ac(builder1);
        BiomeSettings.ai(builder1);
        BiomeSettings.ak(builder1);
        return OverworldBiomes.a(false, 2.0f, 0.0f, builder, builder1, Musics.a(SoundEffects.qU));
    }

    public static BiomeBase a(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isSunflowerPlains, boolean isCold, boolean isIceSpikes) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder1);
        if (isCold) {
            builder.a(0.07f);
            BiomeSettings.e(builder);
            if (isIceSpikes) {
                builder1.a(WorldGenStage.Decoration.e, MiscOverworldPlacements.a);
                builder1.a(WorldGenStage.Decoration.e, MiscOverworldPlacements.b);
            }
        } else {
            BiomeSettings.d(builder);
            BiomeSettings.ab(builder1);
            if (isSunflowerPlains) {
                builder1.a(WorldGenStage.Decoration.j, VegetationPlacements.d);
            }
        }
        BiomeSettings.f(builder1);
        BiomeSettings.j(builder1);
        if (isCold) {
            BiomeSettings.H(builder1);
            BiomeSettings.V(builder1);
            BiomeSettings.Z(builder1);
        } else {
            BiomeSettings.S(builder1);
        }
        BiomeSettings.ac(builder1);
        if (isSunflowerPlains) {
            builder1.a(WorldGenStage.Decoration.j, VegetationPlacements.E);
            builder1.a(WorldGenStage.Decoration.j, VegetationPlacements.e);
        } else {
            BiomeSettings.ad(builder1);
        }
        float f2 = isCold ? 0.0f : 0.8f;
        return OverworldBiomes.a(true, f2, isCold ? 0.5f : 0.4f, builder, builder1, e);
    }

    public static BiomeBase e(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.h(builder);
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.j(builder1);
        BiomeSettings.R(builder1);
        BiomeSettings.ad(builder1);
        return OverworldBiomes.a(true, 0.9f, 1.0f, builder, builder1, e);
    }

    public static BiomeBase a(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isShatteredSavanna, boolean isPlateau) {
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder);
        if (!isShatteredSavanna) {
            BiomeSettings.J(builder);
        }
        BiomeSettings.f(builder);
        BiomeSettings.j(builder);
        if (isShatteredSavanna) {
            BiomeSettings.z(builder);
            BiomeSettings.V(builder);
            BiomeSettings.K(builder);
        } else {
            BiomeSettings.y(builder);
            BiomeSettings.Y(builder);
            BiomeSettings.L(builder);
        }
        BiomeSettings.ac(builder);
        BiomeSettings.ad(builder);
        BiomeSettingsMobs.a builder1 = new BiomeSettingsMobs.a();
        BiomeSettings.a(builder1);
        builder1.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.al, 1, 2, 6)).a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.I, 1, 1, 1)).a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.e, 10, 2, 3));
        BiomeSettings.c(builder1);
        if (isPlateau) {
            builder1.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.ax, 8, 4, 4));
            builder1.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.bL, 8, 4, 8));
        }
        return OverworldBiomes.a(false, 2.0f, 0.0f, builder1, builder, e);
    }

    public static BiomeBase c(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean trees) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.c(builder);
        builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.e, 6, 1, 2));
        builder.a(0.03f);
        if (trees) {
            builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.bL, 2, 4, 8));
            builder.a(0.04f);
        }
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.g(builder1);
        BiomeSettings.j(builder1);
        if (trees) {
            BiomeSettings.G(builder1);
        }
        BiomeSettings.M(builder1);
        BiomeSettings.ac(builder1);
        BiomeSettings.ae(builder1);
        return new BiomeBase.a().a(false).a(2.0f).b(0.0f).a(new BiomeFog.a().b(4159204).c(329011).a(12638463).d(OverworldBiomes.a(2.0f)).e(10387789).f(9470285).a(CaveSoundSettings.b).a(Musics.a(SoundEffects.qV)).b()).a(builder.a()).a(builder1.a()).a();
    }

    private static BiomeBase a(BiomeSettingsMobs.a mobSpawnSettings, int waterColor, int waterFogColor, BiomeSettingsGeneration.a generationSettings) {
        return OverworldBiomes.a(true, 0.5f, 0.5f, waterColor, waterFogColor, null, null, mobSpawnSettings, generationSettings, e);
    }

    private static BiomeSettingsGeneration.a r(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder);
        BiomeSettings.f(builder);
        BiomeSettings.j(builder);
        BiomeSettings.u(builder);
        BiomeSettings.V(builder);
        BiomeSettings.Z(builder);
        BiomeSettings.ac(builder);
        BiomeSettings.ad(builder);
        return builder;
    }

    public static BiomeBase d(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isDeep) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.a(builder, 3, 4, 15);
        builder.a(EnumCreatureType.g, new BiomeSettingsMobs.c(EntityTypes.aZ, 15, 1, 5));
        BiomeSettingsGeneration.a builder1 = OverworldBiomes.r(placedFeatures, worldCarvers);
        builder1.a(WorldGenStage.Decoration.j, isDeep ? AquaticPlacements.h : AquaticPlacements.c);
        BiomeSettings.am(builder1);
        return OverworldBiomes.a(builder, 4020182, 329011, builder1);
    }

    public static BiomeBase e(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isDeep) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.a(builder, 1, 4, 10);
        builder.a(EnumCreatureType.f, new BiomeSettingsMobs.c(EntityTypes.H, 1, 1, 2));
        BiomeSettingsGeneration.a builder1 = OverworldBiomes.r(placedFeatures, worldCarvers);
        builder1.a(WorldGenStage.Decoration.j, isDeep ? AquaticPlacements.g : AquaticPlacements.b);
        BiomeSettings.am(builder1);
        return OverworldBiomes.a(builder, 4159204, 329011, builder1);
    }

    public static BiomeBase f(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isDeep) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        if (isDeep) {
            BiomeSettings.a(builder, 8, 4, 8);
        } else {
            BiomeSettings.a(builder, 10, 2, 15);
        }
        builder.a(EnumCreatureType.g, new BiomeSettingsMobs.c(EntityTypes.aW, 5, 1, 3)).a(EnumCreatureType.g, new BiomeSettingsMobs.c(EntityTypes.bz, 25, 8, 8)).a(EnumCreatureType.f, new BiomeSettingsMobs.c(EntityTypes.H, 2, 1, 2));
        BiomeSettingsGeneration.a builder1 = OverworldBiomes.r(placedFeatures, worldCarvers);
        builder1.a(WorldGenStage.Decoration.j, isDeep ? AquaticPlacements.f : AquaticPlacements.a);
        BiomeSettings.an(builder1);
        return OverworldBiomes.a(builder, 4566514, 267827, builder1);
    }

    public static BiomeBase f(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a().a(EnumCreatureType.g, new BiomeSettingsMobs.c(EntityTypes.aW, 15, 1, 3));
        BiomeSettings.a(builder, 10, 4);
        BiomeSettingsGeneration.a builder1 = OverworldBiomes.r(placedFeatures, worldCarvers).a(WorldGenStage.Decoration.j, AquaticPlacements.l).a(WorldGenStage.Decoration.j, AquaticPlacements.a).a(WorldGenStage.Decoration.j, AquaticPlacements.i);
        return OverworldBiomes.a(builder, 4445678, 270131, builder1);
    }

    public static BiomeBase g(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isDeep) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a().a(EnumCreatureType.f, new BiomeSettingsMobs.c(EntityTypes.bq, 1, 1, 4)).a(EnumCreatureType.g, new BiomeSettingsMobs.c(EntityTypes.aZ, 15, 1, 5)).a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aU, 1, 1, 2));
        BiomeSettings.c(builder);
        builder.a(EnumCreatureType.a, new BiomeSettingsMobs.c(EntityTypes.K, 5, 1, 1));
        float f2 = isDeep ? 0.5f : 0.0f;
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        BiomeSettings.aq(builder1);
        OverworldBiomes.a(builder1);
        BiomeSettings.ar(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.j(builder1);
        BiomeSettings.u(builder1);
        BiomeSettings.V(builder1);
        BiomeSettings.Z(builder1);
        BiomeSettings.ac(builder1);
        BiomeSettings.ad(builder1);
        return new BiomeBase.a().a(true).a(f2).a(BiomeBase.TemperatureModifier.b).b(0.5f).a(new BiomeFog.a().b(3750089).c(329011).a(12638463).d(OverworldBiomes.a(f2)).a(CaveSoundSettings.b).b()).a(builder.a()).a(builder1.a()).a();
    }

    public static BiomeBase b(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isBirchForest, boolean tallBirchTrees, boolean isFlowerForest) {
        Music music;
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder);
        if (isFlowerForest) {
            music = Musics.a(SoundEffects.qT);
            builder.a(WorldGenStage.Decoration.j, VegetationPlacements.aa);
        } else {
            music = Musics.a(SoundEffects.qJ);
            BiomeSettings.N(builder);
        }
        BiomeSettings.f(builder);
        BiomeSettings.j(builder);
        if (isFlowerForest) {
            builder.a(WorldGenStage.Decoration.j, VegetationPlacements.ae);
            builder.a(WorldGenStage.Decoration.j, VegetationPlacements.R);
            BiomeSettings.Z(builder);
        } else {
            if (isBirchForest) {
                if (tallBirchTrees) {
                    BiomeSettings.x(builder);
                } else {
                    BiomeSettings.v(builder);
                }
            } else {
                BiomeSettings.w(builder);
            }
            BiomeSettings.V(builder);
            BiomeSettings.O(builder);
        }
        BiomeSettings.ac(builder);
        BiomeSettings.ad(builder);
        BiomeSettingsMobs.a builder1 = new BiomeSettingsMobs.a();
        BiomeSettings.a(builder1);
        BiomeSettings.c(builder1);
        if (isFlowerForest) {
            builder1.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aX, 4, 2, 3));
        } else if (!isBirchForest) {
            builder1.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.bL, 5, 4, 4));
        }
        float f2 = isBirchForest ? 0.6f : 0.7f;
        return OverworldBiomes.a(true, f2, isBirchForest ? 0.6f : 0.8f, builder1, builder, music);
    }

    public static BiomeBase h(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isCold) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.a(builder);
        builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.bL, 8, 4, 4)).a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aX, 4, 2, 3)).a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aa, 8, 2, 4));
        BiomeSettings.c(builder);
        float f2 = isCold ? -0.5f : 0.25f;
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder1);
        BiomeSettings.n(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.j(builder1);
        BiomeSettings.s(builder1);
        BiomeSettings.V(builder1);
        BiomeSettings.aa(builder1);
        BiomeSettings.ad(builder1);
        if (isCold) {
            BiomeSettings.o(builder1);
        } else {
            BiomeSettings.p(builder1);
        }
        return OverworldBiomes.a(true, f2, isCold ? 0.4f : 0.8f, isCold ? 4020182 : 4159204, 329011, null, null, builder, builder1, e);
    }

    public static BiomeBase i(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isPaleGarden) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        if (!isPaleGarden) {
            BiomeSettings.a(builder);
        }
        BiomeSettings.c(builder);
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder1);
        builder1.a(WorldGenStage.Decoration.j, isPaleGarden ? VegetationPlacements.Z : VegetationPlacements.Y);
        if (!isPaleGarden) {
            BiomeSettings.N(builder1);
        } else {
            builder1.a(WorldGenStage.Decoration.j, VegetationPlacements.ad);
            builder1.a(WorldGenStage.Decoration.j, VegetationPlacements.ac);
        }
        BiomeSettings.f(builder1);
        BiomeSettings.j(builder1);
        if (!isPaleGarden) {
            BiomeSettings.V(builder1);
        } else {
            builder1.a(WorldGenStage.Decoration.j, VegetationPlacements.W);
        }
        BiomeSettings.O(builder1);
        if (!isPaleGarden) {
            BiomeSettings.ac(builder1);
        }
        BiomeSettings.ad(builder1);
        return new BiomeBase.a().a(true).a(0.7f).b(0.8f).a(isPaleGarden ? new BiomeFog.a().b(7768221).c(5597568).a(8484720).d(0xB9B9B9).f(0x778272).e(8883574).a(CaveSoundSettings.b).a().b() : new BiomeFog.a().b(4159204).c(329011).a(12638463).d(OverworldBiomes.a(0.7f)).a(BiomeFog.GrassColor.b).a(CaveSoundSettings.b).a(Musics.a(SoundEffects.qJ)).b()).a(builder.a()).a(builder1.a()).a();
    }

    public static BiomeBase g(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.a(builder);
        BiomeSettings.a(builder, 70);
        builder.a(EnumCreatureType.a, new BiomeSettingsMobs.c(EntityTypes.bg, 1, 1, 1));
        builder.a(EnumCreatureType.a, new BiomeSettingsMobs.c(EntityTypes.q, 30, 4, 4));
        builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.ab, 10, 2, 5));
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        BiomeSettings.al(builder1);
        OverworldBiomes.a(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.k(builder1);
        BiomeSettings.P(builder1);
        BiomeSettings.ac(builder1);
        BiomeSettings.aj(builder1);
        builder1.a(WorldGenStage.Decoration.j, AquaticPlacements.e);
        Music music = Musics.a(SoundEffects.qI);
        return new BiomeBase.a().a(true).a(0.8f).b(0.9f).a(new BiomeFog.a().b(6388580).c(2302743).a(12638463).d(OverworldBiomes.a(0.8f)).e(6975545).a(BiomeFog.GrassColor.c).a(CaveSoundSettings.b).a(music).b()).a(builder.a()).a(builder1.a()).a();
    }

    public static BiomeBase h(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.a(builder, 70);
        builder.a(EnumCreatureType.a, new BiomeSettingsMobs.c(EntityTypes.bg, 1, 1, 1));
        builder.a(EnumCreatureType.a, new BiomeSettingsMobs.c(EntityTypes.q, 30, 4, 4));
        builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.ab, 10, 2, 5));
        builder.a(EnumCreatureType.g, new BiomeSettingsMobs.c(EntityTypes.bz, 25, 8, 8));
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        BiomeSettings.al(builder1);
        OverworldBiomes.a(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.l(builder1);
        BiomeSettings.Q(builder1);
        builder1.a(WorldGenStage.Decoration.j, AquaticPlacements.e);
        Music music = Musics.a(SoundEffects.qI);
        return new BiomeBase.a().a(true).a(0.8f).b(0.9f).a(new BiomeFog.a().b(3832426).c(5077600).a(12638463).d(OverworldBiomes.a(0.8f)).e(9285927).a(BiomeFog.GrassColor.c).a(CaveSoundSettings.b).a(music).b()).a(builder.a()).a(builder1.a()).a();
    }

    public static BiomeBase j(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isCold) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a().a(EnumCreatureType.f, new BiomeSettingsMobs.c(EntityTypes.bq, 2, 1, 4)).a(EnumCreatureType.g, new BiomeSettingsMobs.c(EntityTypes.aZ, 5, 1, 5));
        BiomeSettings.c(builder);
        builder.a(EnumCreatureType.a, new BiomeSettingsMobs.c(EntityTypes.K, isCold ? 1 : 100, 1, 1));
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.j(builder1);
        BiomeSettings.u(builder1);
        BiomeSettings.V(builder1);
        BiomeSettings.Z(builder1);
        BiomeSettings.ac(builder1);
        BiomeSettings.ad(builder1);
        if (!isCold) {
            builder1.a(WorldGenStage.Decoration.j, AquaticPlacements.d);
        }
        float f2 = isCold ? 0.0f : 0.5f;
        return OverworldBiomes.a(true, f2, 0.5f, isCold ? 3750089 : 4159204, 329011, null, null, builder, builder1, e);
    }

    public static BiomeBase b(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isCold, boolean isStony) {
        boolean flag;
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        boolean bl = flag = !isStony && !isCold;
        if (flag) {
            builder.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.bA, 5, 2, 5));
        }
        BiomeSettings.c(builder);
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.j(builder1);
        BiomeSettings.V(builder1);
        BiomeSettings.Z(builder1);
        BiomeSettings.ac(builder1);
        BiomeSettings.ad(builder1);
        float f2 = isCold ? 0.05f : (isStony ? 0.2f : 0.8f);
        return OverworldBiomes.a(true, f2, flag ? 0.4f : 0.3f, isCold ? 4020182 : 4159204, 329011, null, null, builder, builder1, e);
    }

    public static BiomeBase i(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        builder.a(WorldGenStage.Decoration.k, MiscOverworldPlacements.n);
        return OverworldBiomes.a(false, 0.5f, 0.5f, new BiomeSettingsMobs.a(), builder, e);
    }

    public static BiomeBase k(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers, boolean isCherryGrove) {
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        BiomeSettingsMobs.a builder1 = new BiomeSettingsMobs.a();
        builder1.a(EnumCreatureType.b, new BiomeSettingsMobs.c(isCherryGrove ? EntityTypes.aQ : EntityTypes.I, 1, 1, 2)).a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aX, 2, 2, 6)).a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.ba, 2, 2, 4));
        BiomeSettings.c(builder1);
        OverworldBiomes.a(builder);
        BiomeSettings.ab(builder);
        BiomeSettings.f(builder);
        BiomeSettings.j(builder);
        if (isCherryGrove) {
            BiomeSettings.W(builder);
        } else {
            BiomeSettings.X(builder);
        }
        BiomeSettings.h(builder);
        BiomeSettings.i(builder);
        Music music = Musics.a(isCherryGrove ? SoundEffects.qM : SoundEffects.qL);
        return isCherryGrove ? OverworldBiomes.a(true, 0.5f, 0.8f, 6141935, 6141935, 11983713, 11983713, builder1, builder, music) : OverworldBiomes.a(true, 0.5f, 0.8f, 937679, 329011, null, null, builder1, builder, music);
    }

    public static BiomeBase j(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        BiomeSettingsMobs.a builder1 = new BiomeSettingsMobs.a();
        builder1.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.ah, 5, 1, 3));
        BiomeSettings.c(builder1);
        OverworldBiomes.a(builder);
        BiomeSettings.ap(builder);
        BiomeSettings.f(builder);
        BiomeSettings.j(builder);
        BiomeSettings.h(builder);
        BiomeSettings.i(builder);
        Music music = Musics.a(SoundEffects.qO);
        return OverworldBiomes.a(true, -0.7f, 0.9f, builder1, builder, music);
    }

    public static BiomeBase k(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        BiomeSettingsMobs.a builder1 = new BiomeSettingsMobs.a();
        builder1.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.ah, 5, 1, 3));
        BiomeSettings.c(builder1);
        OverworldBiomes.a(builder);
        BiomeSettings.ap(builder);
        BiomeSettings.f(builder);
        BiomeSettings.j(builder);
        BiomeSettings.h(builder);
        BiomeSettings.i(builder);
        Music music = Musics.a(SoundEffects.qG);
        return OverworldBiomes.a(true, -0.7f, 0.9f, builder1, builder, music);
    }

    public static BiomeBase l(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        BiomeSettingsMobs.a builder1 = new BiomeSettingsMobs.a();
        BiomeSettings.c(builder1);
        OverworldBiomes.a(builder);
        BiomeSettings.f(builder);
        BiomeSettings.j(builder);
        BiomeSettings.h(builder);
        BiomeSettings.i(builder);
        Music music = Musics.a(SoundEffects.qR);
        return OverworldBiomes.a(true, 1.0f, 0.3f, builder1, builder, music);
    }

    public static BiomeBase m(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        BiomeSettingsMobs.a builder1 = new BiomeSettingsMobs.a();
        builder1.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aX, 4, 2, 3)).a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.ah, 5, 1, 3));
        BiomeSettings.c(builder1);
        OverworldBiomes.a(builder);
        BiomeSettings.ap(builder);
        BiomeSettings.f(builder);
        BiomeSettings.j(builder);
        BiomeSettings.ad(builder);
        BiomeSettings.h(builder);
        BiomeSettings.i(builder);
        Music music = Musics.a(SoundEffects.qP);
        return OverworldBiomes.a(true, -0.3f, 0.9f, builder1, builder, music);
    }

    public static BiomeBase n(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsGeneration.a builder = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        BiomeSettingsMobs.a builder1 = new BiomeSettingsMobs.a();
        builder1.a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.bL, 1, 1, 1)).a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aX, 8, 2, 3)).a(EnumCreatureType.b, new BiomeSettingsMobs.c(EntityTypes.aa, 4, 2, 4));
        BiomeSettings.c(builder1);
        OverworldBiomes.a(builder);
        BiomeSettings.ap(builder);
        BiomeSettings.f(builder);
        BiomeSettings.j(builder);
        BiomeSettings.t(builder);
        BiomeSettings.ad(builder);
        BiomeSettings.h(builder);
        BiomeSettings.i(builder);
        Music music = Musics.a(SoundEffects.qF);
        return OverworldBiomes.a(true, -0.2f, 0.8f, builder1, builder, music);
    }

    public static BiomeBase o(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        builder.a(EnumCreatureType.d, new BiomeSettingsMobs.c(EntityTypes.h, 10, 4, 6));
        builder.a(EnumCreatureType.g, new BiomeSettingsMobs.c(EntityTypes.bz, 25, 8, 8));
        BiomeSettings.c(builder);
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder1);
        BiomeSettings.ab(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.B(builder1);
        BiomeSettings.j(builder1);
        BiomeSettings.A(builder1);
        Music music = Musics.a(SoundEffects.qH);
        return OverworldBiomes.a(true, 0.5f, 0.5f, builder, builder1, music);
    }

    public static BiomeBase p(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettings.g(builder);
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        OverworldBiomes.a(builder1);
        BiomeSettings.ab(builder1);
        BiomeSettings.a(builder1, true);
        BiomeSettings.j(builder1);
        BiomeSettings.S(builder1);
        BiomeSettings.ac(builder1);
        BiomeSettings.ad(builder1);
        BiomeSettings.d(builder1);
        Music music = Musics.a(SoundEffects.qE);
        return OverworldBiomes.a(true, 0.8f, 0.4f, builder, builder1, music);
    }

    public static BiomeBase q(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<WorldGenCarverWrapper<?>> worldCarvers) {
        BiomeSettingsMobs.a builder = new BiomeSettingsMobs.a();
        BiomeSettingsGeneration.a builder1 = new BiomeSettingsGeneration.a(placedFeatures, worldCarvers);
        builder1.a(WorldGenCarvers.a);
        builder1.a(WorldGenCarvers.b);
        builder1.a(WorldGenCarvers.c);
        BiomeSettings.av(builder1);
        BiomeSettings.b(builder1);
        BiomeSettings.c(builder1);
        BiomeSettings.as(builder1);
        BiomeSettings.ab(builder1);
        BiomeSettings.f(builder1);
        BiomeSettings.j(builder1);
        BiomeSettings.S(builder1);
        BiomeSettings.ac(builder1);
        BiomeSettings.ad(builder1);
        BiomeSettings.e(builder1);
        Music music = Musics.a(SoundEffects.qD);
        return OverworldBiomes.a(true, 0.8f, 0.4f, builder, builder1, music);
    }
}

