/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSingleItem;
import net.minecraft.world.item.crafting.RecipeStonecutting;
import net.minecraft.world.level.IMaterial;

public class SingleItemRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory b;
    private final Item c;
    private final RecipeItemStack d;
    private final int e;
    private final Map<String, Criterion<?>> f = new LinkedHashMap();
    @Nullable
    private String g;
    private final RecipeSingleItem.a<?> h;

    public SingleItemRecipeBuilder(RecipeCategory category, RecipeSingleItem.a<?> factory, RecipeItemStack ingredient, IMaterial result, int count) {
        this.b = category;
        this.h = factory;
        this.c = result.j();
        this.d = ingredient;
        this.e = count;
    }

    public static SingleItemRecipeBuilder a(RecipeItemStack ingredient, RecipeCategory category, IMaterial result) {
        return new SingleItemRecipeBuilder(category, RecipeStonecutting::new, ingredient, result, 1);
    }

    public static SingleItemRecipeBuilder a(RecipeItemStack ingredient, RecipeCategory category, IMaterial result, int count) {
        return new SingleItemRecipeBuilder(category, RecipeStonecutting::new, ingredient, result, count);
    }

    public SingleItemRecipeBuilder b(String name, Criterion<?> criterion) {
        this.f.put(name, criterion);
        return this;
    }

    public SingleItemRecipeBuilder b(@Nullable String groupName) {
        this.g = groupName;
        return this;
    }

    @Override
    public Item a() {
        return this.c;
    }

    @Override
    public void a(RecipeOutput output, ResourceKey<IRecipe<?>> resourceKey) {
        this.a(resourceKey);
        Advancement.SerializedAdvancement builder = output.a().a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(resourceKey)).a(AdvancementRewards.a.c(resourceKey)).a(AdvancementRequirements.a.b);
        this.f.forEach(builder::a);
        Object singleItemRecipe = this.h.create(Objects.requireNonNullElse(this.g, ""), this.d, new ItemStack(this.c, this.e));
        output.a(resourceKey, (IRecipe<?>)singleItemRecipe, builder.b(resourceKey.a().f("recipes/" + this.b.a() + "/")));
    }

    private void a(ResourceKey<IRecipe<?>> recipe) {
        if (this.f.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipe.a()));
        }
    }
}

