/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.FurnaceRecipe;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeBlasting;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeSmoking;
import net.minecraft.world.level.IMaterial;

public class SimpleCookingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory b;
    private final CookingBookCategory c;
    private final Item d;
    private final RecipeItemStack e;
    private final float f;
    private final int g;
    private final Map<String, Criterion<?>> h = new LinkedHashMap();
    @Nullable
    private String i;
    private final RecipeCooking.a<?> j;

    private SimpleCookingRecipeBuilder(RecipeCategory category, CookingBookCategory bookCategory, IMaterial result, RecipeItemStack ingredient, float experience, int cookingTime, RecipeCooking.a<?> factory) {
        this.b = category;
        this.c = bookCategory;
        this.d = result.j();
        this.e = ingredient;
        this.f = experience;
        this.g = cookingTime;
        this.j = factory;
    }

    public static <T extends RecipeCooking> SimpleCookingRecipeBuilder a(RecipeItemStack ingredient, RecipeCategory category, IMaterial result, float experience, int cookingTime, RecipeSerializer<T> cookingSerializer, RecipeCooking.a<T> factory) {
        return new SimpleCookingRecipeBuilder(category, SimpleCookingRecipeBuilder.a(cookingSerializer, result), result, ingredient, experience, cookingTime, factory);
    }

    public static SimpleCookingRecipeBuilder a(RecipeItemStack ingredient, RecipeCategory category, IMaterial result, float experience, int cookingTime) {
        return new SimpleCookingRecipeBuilder(category, CookingBookCategory.a, result, ingredient, experience, cookingTime, RecipeCampfire::new);
    }

    public static SimpleCookingRecipeBuilder b(RecipeItemStack ingredient, RecipeCategory category, IMaterial result, float experience, int cookingTime) {
        return new SimpleCookingRecipeBuilder(category, SimpleCookingRecipeBuilder.c(result), result, ingredient, experience, cookingTime, RecipeBlasting::new);
    }

    public static SimpleCookingRecipeBuilder c(RecipeItemStack ingredient, RecipeCategory category, IMaterial result, float experience, int cookingTime) {
        return new SimpleCookingRecipeBuilder(category, SimpleCookingRecipeBuilder.b(result), result, ingredient, experience, cookingTime, FurnaceRecipe::new);
    }

    public static SimpleCookingRecipeBuilder d(RecipeItemStack ingredient, RecipeCategory category, IMaterial result, float experience, int cookingTime) {
        return new SimpleCookingRecipeBuilder(category, CookingBookCategory.a, result, ingredient, experience, cookingTime, RecipeSmoking::new);
    }

    public SimpleCookingRecipeBuilder b(String name, Criterion<?> criterion) {
        this.h.put(name, criterion);
        return this;
    }

    public SimpleCookingRecipeBuilder b(@Nullable String groupName) {
        this.i = groupName;
        return this;
    }

    @Override
    public Item a() {
        return this.d;
    }

    @Override
    public void a(RecipeOutput output, ResourceKey<IRecipe<?>> resourceKey) {
        this.a(resourceKey);
        Advancement.SerializedAdvancement builder = output.a().a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(resourceKey)).a(AdvancementRewards.a.c(resourceKey)).a(AdvancementRequirements.a.b);
        this.h.forEach(builder::a);
        Object abstractCookingRecipe = this.j.create(Objects.requireNonNullElse(this.i, ""), this.c, this.e, new ItemStack(this.d), this.f, this.g);
        output.a(resourceKey, (IRecipe<?>)abstractCookingRecipe, builder.b(resourceKey.a().f("recipes/" + this.b.a() + "/")));
    }

    private static CookingBookCategory b(IMaterial result) {
        if (result.j().g().b(DataComponents.w)) {
            return CookingBookCategory.a;
        }
        return result.j() instanceof ItemBlock ? CookingBookCategory.b : CookingBookCategory.c;
    }

    private static CookingBookCategory c(IMaterial result) {
        return result.j() instanceof ItemBlock ? CookingBookCategory.b : CookingBookCategory.c;
    }

    private static CookingBookCategory a(RecipeSerializer<? extends RecipeCooking> serializer, IMaterial result) {
        if (serializer == RecipeSerializer.o) {
            return SimpleCookingRecipeBuilder.b(result);
        }
        if (serializer == RecipeSerializer.p) {
            return SimpleCookingRecipeBuilder.c(result);
        }
        if (serializer != RecipeSerializer.q && serializer != RecipeSerializer.r) {
            throw new IllegalStateException("Unknown cooking recipe type");
        }
        return CookingBookCategory.a;
    }

    private void a(ResourceKey<IRecipe<?>> recipe) {
        if (this.h.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipe.a()));
        }
    }
}

