/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.SuppressForbidden;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.packs.VanillaAdvancementProvider;
import net.minecraft.data.info.BiomeParametersDumpReport;
import net.minecraft.data.info.BlockListReport;
import net.minecraft.data.info.CommandsReport;
import net.minecraft.data.info.DatapackStructureReport;
import net.minecraft.data.info.ItemListReport;
import net.minecraft.data.info.PacketReport;
import net.minecraft.data.info.RegistryDumpReport;
import net.minecraft.data.loot.packs.TradeRebalanceLootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.registries.TradeRebalanceRegistries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.data.tags.BannerPatternTagsProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.CatVariantTagsProvider;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.FlatLevelGeneratorPresetTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.GameEventTagsProvider;
import net.minecraft.data.tags.InstrumentTagsProvider;
import net.minecraft.data.tags.PaintingVariantTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.tags.TradeRebalanceEnchantmentTagsProvider;
import net.minecraft.data.tags.TradeRebalanceStructureTagsProvider;
import net.minecraft.data.tags.VanillaBlockTagsProvider;
import net.minecraft.data.tags.VanillaEnchantmentTagsProvider;
import net.minecraft.data.tags.VanillaItemTagsProvider;
import net.minecraft.data.tags.WorldPresetTagsProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class Main {
    @SuppressForbidden(reason="System.out needed before bootstrap")
    @DontObfuscate
    public static void main(String[] args) throws IOException {
        SharedConstants.a();
        OptionParser optionParser = new OptionParser();
        AbstractOptionSpec optionSpec = optionParser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder optionSpec1 = optionParser.accepts("server", "Include server generators");
        OptionSpecBuilder optionSpec2 = optionParser.accepts("dev", "Include development tools");
        OptionSpecBuilder optionSpec3 = optionParser.accepts("reports", "Include data reports");
        optionParser.accepts("validate", "Validate inputs");
        OptionSpecBuilder optionSpec4 = optionParser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec optionSpec5 = optionParser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionSpec6 = optionParser.accepts("input", "Input folder").withRequiredArg();
        OptionSet optionSet = optionParser.parse(args);
        if (!optionSet.has((OptionSpec)optionSpec) && optionSet.hasOptions()) {
            Path path = Paths.get((String)optionSpec5.value(optionSet), new String[0]);
            boolean hasOptionSpec = optionSet.has((OptionSpec)optionSpec4);
            boolean flag = hasOptionSpec || optionSet.has((OptionSpec)optionSpec1);
            boolean flag1 = hasOptionSpec || optionSet.has((OptionSpec)optionSpec2);
            boolean flag2 = hasOptionSpec || optionSet.has((OptionSpec)optionSpec3);
            List<Path> collection = optionSet.valuesOf((OptionSpec)optionSpec6).stream().map(string -> Paths.get(string, new String[0])).toList();
            DataGenerator dataGenerator = new DataGenerator(path, SharedConstants.b(), true);
            Main.a(dataGenerator, collection, flag, flag1, flag2);
            dataGenerator.a();
        } else {
            optionParser.printHelpOn((OutputStream)System.out);
        }
    }

    private static <T extends DebugReportProvider> DebugReportProvider.a<T> a(BiFunction<PackOutput, CompletableFuture<HolderLookup.a>, T> tagProviderFactory, CompletableFuture<HolderLookup.a> lookupProvider) {
        return output -> (DebugReportProvider)tagProviderFactory.apply(output, lookupProvider);
    }

    public static void a(DataGenerator dataGenerator, Collection<Path> paths, boolean server, boolean dev, boolean reports) {
        DataGenerator.a vanillaPack = dataGenerator.a(server);
        vanillaPack.a(output -> new SnbtToNbt(output, paths).a(new StructureUpdater()));
        CompletableFuture<HolderLookup.a> completableFuture = CompletableFuture.supplyAsync(VanillaRegistries::a, SystemUtils.h());
        DataGenerator.a vanillaPack1 = dataGenerator.a(server);
        vanillaPack1.a(Main.a(RegistriesDatapackGenerator::new, completableFuture));
        vanillaPack1.a(Main.a(VanillaAdvancementProvider::a, completableFuture));
        vanillaPack1.a(Main.a(VanillaLootTableProvider::a, completableFuture));
        vanillaPack1.a(Main.a(VanillaRecipeProvider.a::new, completableFuture));
        TagsProvider tagsProvider = vanillaPack1.a(Main.a(VanillaBlockTagsProvider::new, completableFuture));
        TagsProvider tagsProvider1 = vanillaPack1.a(output -> new VanillaItemTagsProvider(output, completableFuture, tagsProvider.c()));
        TagsProvider tagsProvider2 = vanillaPack1.a(Main.a(BiomeTagsProvider::new, completableFuture));
        TagsProvider tagsProvider3 = vanillaPack1.a(Main.a(BannerPatternTagsProvider::new, completableFuture));
        TagsProvider tagsProvider4 = vanillaPack1.a(Main.a(StructureTagsProvider::new, completableFuture));
        vanillaPack1.a(Main.a(CatVariantTagsProvider::new, completableFuture));
        vanillaPack1.a(Main.a(DamageTypeTagsProvider::new, completableFuture));
        vanillaPack1.a(Main.a(EntityTypeTagsProvider::new, completableFuture));
        vanillaPack1.a(Main.a(FlatLevelGeneratorPresetTagsProvider::new, completableFuture));
        vanillaPack1.a(Main.a(FluidTagsProvider::new, completableFuture));
        vanillaPack1.a(Main.a(GameEventTagsProvider::new, completableFuture));
        vanillaPack1.a(Main.a(InstrumentTagsProvider::new, completableFuture));
        vanillaPack1.a(Main.a(PaintingVariantTagsProvider::new, completableFuture));
        vanillaPack1.a(Main.a(PoiTypeTagsProvider::new, completableFuture));
        vanillaPack1.a(Main.a(WorldPresetTagsProvider::new, completableFuture));
        vanillaPack1.a(Main.a(VanillaEnchantmentTagsProvider::new, completableFuture));
        vanillaPack1 = dataGenerator.a(dev);
        vanillaPack1.a(output -> new DebugReportNBT(output, paths));
        vanillaPack1 = dataGenerator.a(reports);
        vanillaPack1.a(Main.a(BiomeParametersDumpReport::new, completableFuture));
        vanillaPack1.a(Main.a(ItemListReport::new, completableFuture));
        vanillaPack1.a(Main.a(BlockListReport::new, completableFuture));
        vanillaPack1.a(Main.a(CommandsReport::new, completableFuture));
        vanillaPack1.a(RegistryDumpReport::new);
        vanillaPack1.a(PacketReport::new);
        vanillaPack1.a(DatapackStructureReport::new);
        CompletableFuture<RegistrySetBuilder.g> completableFuture1 = TradeRebalanceRegistries.a(completableFuture);
        CompletionStage completableFuture2 = completableFuture1.thenApply(RegistrySetBuilder.g::b);
        DataGenerator.a builtinDatapack = dataGenerator.a(server, "trade_rebalance");
        builtinDatapack.a(Main.a(RegistriesDatapackGenerator::new, (CompletableFuture<HolderLookup.a>)completableFuture2));
        builtinDatapack.a(output -> PackMetadataGenerator.a(output, IChatBaseComponent.c("dataPack.trade_rebalance.description"), FeatureFlagSet.a(FeatureFlags.b)));
        builtinDatapack.a(Main.a(TradeRebalanceLootTableProvider::a, completableFuture));
        builtinDatapack.a(Main.a(TradeRebalanceStructureTagsProvider::new, completableFuture));
        builtinDatapack.a(Main.a(TradeRebalanceEnchantmentTagsProvider::new, completableFuture));
        vanillaPack1 = dataGenerator.a(server, "redstone_experiments");
        vanillaPack1.a(output -> PackMetadataGenerator.a(output, IChatBaseComponent.c("dataPack.redstone_experiments.description"), FeatureFlagSet.a(FeatureFlags.c)));
        vanillaPack1 = dataGenerator.a(server, "minecart_improvements");
        vanillaPack1.a(output -> PackMetadataGenerator.a(output, IChatBaseComponent.c("dataPack.minecart_improvements.description"), FeatureFlagSet.a(FeatureFlags.d)));
    }
}

