/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ChatDeserializer;
import org.slf4j.Logger;

public interface DebugReportProvider {
    public static final ToIntFunction<String> a = (ToIntFunction)SystemUtils.a(new Object2IntOpenHashMap(), (? super T map) -> {
        map.put((Object)"type", 0);
        map.put((Object)"parent", 1);
        map.defaultReturnValue(2);
    });
    public static final Comparator<String> b = Comparator.comparingInt(a).thenComparing(string -> string);
    public static final Logger c = LogUtils.getLogger();

    public CompletableFuture<?> a(CachedOutput var1);

    public String a();

    public static <T> CompletableFuture<?> a(CachedOutput output, Codec<T> codec, PackOutput.a pathProvider, Map<MinecraftKey, T> entries) {
        return DebugReportProvider.a(output, codec, pathProvider::a, entries);
    }

    public static <T, E> CompletableFuture<?> a(CachedOutput output, Codec<E> codec, Function<T, Path> pathGetter, Map<T, E> entries) {
        return DebugReportProvider.a(output, (E object) -> (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object).getOrThrow(), pathGetter, entries);
    }

    public static <T, E> CompletableFuture<?> a(CachedOutput output, Function<E, JsonElement> serializer, Function<T, Path> pathGetter, Map<T, E> entries) {
        return CompletableFuture.allOf((CompletableFuture[])entries.entrySet().stream().map(entry -> {
            Path path = (Path)pathGetter.apply(entry.getKey());
            JsonElement jsonElement = (JsonElement)serializer.apply(entry.getValue());
            return DebugReportProvider.a(output, jsonElement, path);
        }).toArray(CompletableFuture[]::new));
    }

    public static <T> CompletableFuture<?> a(CachedOutput output, HolderLookup.a registries, Codec<T> codec, T value, Path path) {
        RegistryOps<JsonElement> registryOps = registries.a(JsonOps.INSTANCE);
        return DebugReportProvider.a(output, registryOps, codec, value, path);
    }

    public static <T> CompletableFuture<?> a(CachedOutput output, Codec<T> codec, T value, Path path) {
        return DebugReportProvider.a(output, (DynamicOps<JsonElement>)JsonOps.INSTANCE, codec, value, path);
    }

    private static <T> CompletableFuture<?> a(CachedOutput output, DynamicOps<JsonElement> ops, Codec<T> codec, T value, Path path) {
        JsonElement jsonElement = (JsonElement)codec.encodeStart(ops, value).getOrThrow();
        return DebugReportProvider.a(output, jsonElement, path);
    }

    public static CompletableFuture<?> a(CachedOutput output, JsonElement json, Path path) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HashingOutputStream hashingOutputStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)byteArrayOutputStream);
                try (JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingOutputStream, StandardCharsets.UTF_8));){
                    jsonWriter.setSerializeNulls(false);
                    jsonWriter.setIndent("  ");
                    ChatDeserializer.a(jsonWriter, json, b);
                }
                output.writeIfNeeded(path, byteArrayOutputStream.toByteArray(), hashingOutputStream.hash());
            }
            catch (IOException var10) {
                c.error("Failed to save file to {}", (Object)path, (Object)var10);
            }
        }, SystemUtils.h().a("saveStable"));
    }

    @FunctionalInterface
    public static interface a<T extends DebugReportProvider> {
        public T create(PackOutput var1);
    }
}

