/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.WorldVersion;
import net.minecraft.data.DebugReportProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.PackOutput;
import net.minecraft.server.DispenserRegistry;
import org.slf4j.Logger;

public class DataGenerator {
    private static final Logger a = LogUtils.getLogger();
    private final Path b;
    private final PackOutput c;
    final Set<String> d = new HashSet<String>();
    final Map<String, DebugReportProvider> e = new LinkedHashMap<String, DebugReportProvider>();
    private final WorldVersion f;
    private final boolean g;

    public DataGenerator(Path rootOutputFolder, WorldVersion version, boolean alwaysGenerate) {
        this.b = rootOutputFolder;
        this.c = new PackOutput(this.b);
        this.f = version;
        this.g = alwaysGenerate;
    }

    public void a() throws IOException {
        HashCache hashCache = new HashCache(this.b, this.d, this.f);
        Stopwatch stopwatch = Stopwatch.createStarted();
        Stopwatch stopwatch1 = Stopwatch.createUnstarted();
        this.e.forEach((providerName, dataProvider) -> {
            if (!this.g && !hashCache.a((String)providerName)) {
                a.debug("Generator {} already run for version {}", providerName, (Object)this.f.c());
            } else {
                a.info("Starting provider: {}", providerName);
                stopwatch1.start();
                hashCache.a(hashCache.a((String)providerName, dataProvider::a).join());
                stopwatch1.stop();
                a.info("{} finished after {} ms", providerName, (Object)stopwatch1.elapsed(TimeUnit.MILLISECONDS));
                stopwatch1.reset();
            }
        });
        a.info("All providers took: {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        hashCache.a();
    }

    public a a(boolean toRun) {
        return new a(toRun, "vanilla", this.c);
    }

    public a a(boolean toRun, String providerPrefix) {
        Path path = this.c.a(PackOutput.b.a).resolve("minecraft").resolve("datapacks").resolve(providerPrefix);
        return new a(toRun, providerPrefix, new PackOutput(path));
    }

    static {
        DispenserRegistry.a();
    }

    public class a {
        private final boolean b;
        private final String c;
        private final PackOutput d;

        a(boolean toRun, String providerPrefix, PackOutput output) {
            this.b = toRun;
            this.c = providerPrefix;
            this.d = output;
        }

        public <T extends DebugReportProvider> T a(DebugReportProvider.a<T> factory) {
            T dataProvider = factory.create(this.d);
            String string = this.c + "/" + dataProvider.a();
            if (!DataGenerator.this.d.add(string)) {
                throw new IllegalStateException("Duplicate provider: " + string);
            }
            if (this.b) {
                DataGenerator.this.e.put(string, (DebugReportProvider)dataProvider);
            }
            return dataProvider;
        }
    }
}

