/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import io.papermc.paper.annotation.DoNotUse;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.inventory.ItemStack;

public class EquipmentDispenseItemBehavior
extends DispenseBehaviorItem {
    public static final EquipmentDispenseItemBehavior c = new EquipmentDispenseItemBehavior();

    @Override
    protected net.minecraft.world.item.ItemStack a(SourceBlock blockSource, net.minecraft.world.item.ItemStack item) {
        return EquipmentDispenseItemBehavior.dispenseEquipment(blockSource, item, this) ? item : super.a(blockSource, item);
    }

    @Deprecated
    @DoNotUse
    public static boolean b(SourceBlock blockSource, net.minecraft.world.item.ItemStack item) {
        return EquipmentDispenseItemBehavior.dispenseEquipment(blockSource, item, null);
    }

    public static boolean dispenseEquipment(SourceBlock blockSource, net.minecraft.world.item.ItemStack item, @Nullable IDispenseBehavior currentBehavior) {
        BlockPosition blockPos = blockSource.c().a(blockSource.d().c(BlockDispenser.b));
        List<EntityLiving> entitiesOfClass = blockSource.b().a(EntityLiving.class, new AxisAlignedBB(blockPos), (? super T entity) -> entity.e(item));
        if (entitiesOfClass.isEmpty()) {
            return false;
        }
        EntityLiving livingEntity = entitiesOfClass.getFirst();
        EnumItemSlot equipmentSlotForItem = livingEntity.f(item);
        net.minecraft.world.item.ItemStack itemStack = item.c(1);
        WorldServer world = blockSource.b();
        CraftBlock block = CraftBlock.at(world, blockSource.c());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemStack);
        BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)livingEntity.getBukkitEntity()));
        if (!BlockDispenser.eventFired) {
            world.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        boolean shrink = true;
        if (!event.getItem().equals((Object)craftItem)) {
            shrink = false;
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            IDispenseBehavior dispenseItemBehavior = BlockDispenser.getDispenseBehavior(blockSource, eventStack);
            if (dispenseItemBehavior != IDispenseBehavior.b && (currentBehavior == null || dispenseItemBehavior != currentBehavior)) {
                dispenseItemBehavior.dispense(blockSource, eventStack);
                return true;
            }
        }
        livingEntity.a(equipmentSlotForItem, CraftItemStack.asNMSCopy(event.getItem()));
        if (livingEntity instanceof EntityInsentient) {
            EntityInsentient mob = (EntityInsentient)livingEntity;
            mob.a(equipmentSlotForItem, 2.0f);
            mob.fY();
        }
        if (shrink) {
            item.h(1);
        }
        return true;
    }
}

