/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.papermc.paper.util.ItemComponentSanitizer;
import io.papermc.paper.util.ItemObfuscationSession;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.Unit;

public final class DataComponentPatch {
    public static final DataComponentPatch a = new DataComponentPatch(Reference2ObjectMaps.emptyMap());
    public static final Codec<DataComponentPatch> b = Codec.dispatchedMap(net.minecraft.core.component.DataComponentPatch$b.a, b::a).xmap(map -> {
        if (map.isEmpty()) {
            return a;
        }
        Reference2ObjectArrayMap map1 = new Reference2ObjectArrayMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            b patchKey = (b)entry.getKey();
            if (patchKey.c()) {
                map1.put(patchKey.b(), Optional.empty());
                continue;
            }
            map1.put(patchKey.b(), Optional.of(entry.getValue()));
        }
        return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)map1);
    }, dataComponentPatch -> {
        Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(dataComponentPatch.d.size());
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(dataComponentPatch.d)) {
            DataComponentType dataComponentType = (DataComponentType)entry.getKey();
            if (dataComponentType.d()) continue;
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                map.put((Object)new b(dataComponentType, false), optional.get());
                continue;
            }
            map.put((Object)new b(dataComponentType, true), (Object)Unit.a);
        }
        return map;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> c = new StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch>(){

        public DataComponentPatch a(RegistryFriendlyByteBuf buffer) {
            DataComponentType dataComponentType;
            int i1;
            int varInt = buffer.l();
            int varInt1 = buffer.l();
            if (varInt == 0 && varInt1 == 0) {
                return a;
            }
            int i2 = varInt + varInt1;
            Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(Math.min(i2, 65536));
            for (i1 = 0; i1 < varInt; ++i1) {
                dataComponentType = (DataComponentType)DataComponentType.b.decode(buffer);
                Object object = dataComponentType.e().decode(buffer);
                map.put((Object)dataComponentType, Optional.of(object));
            }
            for (i1 = 0; i1 < varInt1; ++i1) {
                dataComponentType = (DataComponentType)DataComponentType.b.decode(buffer);
                map.put((Object)dataComponentType, Optional.empty());
            }
            return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)map);
        }

        public void a(RegistryFriendlyByteBuf buffer, DataComponentPatch value) {
            if (value.d()) {
                buffer.c(0);
                buffer.c(0);
            } else {
                ItemObfuscationSession itemObfuscationSession = value.d.isEmpty() ? null : ItemObfuscationSession.currentSession();
                int i2 = 0;
                int i1 = 0;
                for (Reference2ObjectMap.Entry entry : Reference2ObjectMaps.fastIterable(value.d)) {
                    if (((Optional)entry.getValue()).isPresent()) {
                        if (ItemComponentSanitizer.shouldDrop(itemObfuscationSession, (DataComponentType)entry.getKey())) continue;
                        ++i2;
                        continue;
                    }
                    ++i1;
                }
                buffer.c(i2);
                buffer.c(i1);
                for (Reference2ObjectMap.Entry entryx : Reference2ObjectMaps.fastIterable(value.d)) {
                    Optional<?> optional = (Optional<?>)entryx.getValue();
                    optional = ItemComponentSanitizer.override(itemObfuscationSession, (DataComponentType)entryx.getKey(), (Optional)entryx.getValue());
                    if (!optional.isPresent()) continue;
                    DataComponentType dataComponentType = (DataComponentType)entryx.getKey();
                    DataComponentType.b.encode(buffer, dataComponentType);
                    1.a(buffer, dataComponentType, optional.get());
                }
                for (Reference2ObjectMap.Entry entryxx : Reference2ObjectMaps.fastIterable(value.d)) {
                    if (!((Optional)entryxx.getValue()).isEmpty()) continue;
                    DataComponentType dataComponentType1 = (DataComponentType)entryxx.getKey();
                    DataComponentType.b.encode(buffer, dataComponentType1);
                }
            }
        }

        private static <T> void a(RegistryFriendlyByteBuf buffer, DataComponentType<T> component, Object value) {
            try {
                component.e().encode(buffer, value);
            }
            catch (Exception e2) {
                throw new RuntimeException("Error encoding component " + String.valueOf(component), e2);
            }
        }
    };
    private static final String e = "!";
    final Reference2ObjectMap<DataComponentType<?>, Optional<?>> d;

    DataComponentPatch(Reference2ObjectMap<DataComponentType<?>, Optional<?>> map) {
        this.d = map;
    }

    public static a a() {
        return new a();
    }

    @Nullable
    public <T> Optional<? extends T> a(DataComponentType<? extends T> component) {
        return (Optional)this.d.get(component);
    }

    public Set<Map.Entry<DataComponentType<?>, Optional<?>>> b() {
        return this.d.entrySet();
    }

    public int c() {
        return this.d.size();
    }

    public DataComponentPatch a(Predicate<DataComponentType<?>> predicate) {
        if (this.d()) {
            return a;
        }
        Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(this.d);
        map.keySet().removeIf(predicate);
        return map.isEmpty() ? a : new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)map);
    }

    public boolean d() {
        return this.d.isEmpty();
    }

    public c e() {
        if (this.d()) {
            return net.minecraft.core.component.DataComponentPatch$c.a;
        }
        DataComponentMap.a builder = DataComponentMap.a();
        Set set = Sets.newIdentityHashSet();
        this.d.forEach((dataComponentType, optional) -> {
            if (optional.isPresent()) {
                builder.b(dataComponentType, optional.get());
            } else {
                set.add(dataComponentType);
            }
        });
        return new c(builder.a(), set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof DataComponentPatch)) return false;
        DataComponentPatch dataComponentPatch = (DataComponentPatch)other;
        if (!this.d.equals(dataComponentPatch.d)) return false;
        return true;
    }

    public int hashCode() {
        return this.d.hashCode();
    }

    public String toString() {
        return DataComponentPatch.a(this.d);
    }

    static String a(Reference2ObjectMap<DataComponentType<?>, Optional<?>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        boolean flag = true;
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(map)) {
            if (flag) {
                flag = false;
            } else {
                stringBuilder.append(", ");
            }
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append("=>");
                stringBuilder.append(optional.get());
                continue;
            }
            stringBuilder.append(e);
            stringBuilder.append(entry.getKey());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static class a {
        private final Reference2ObjectMap<DataComponentType<?>, Optional<?>> a = new Reference2ObjectArrayMap();

        a() {
        }

        public void copy(DataComponentPatch orig) {
            this.a.putAll(orig.d);
        }

        public void clear(DataComponentType<?> type) {
            this.a.remove(type);
        }

        public boolean isSet(DataComponentType<?> type) {
            return this.a.containsKey(type);
        }

        public boolean isEmpty() {
            return this.a.isEmpty();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof a) {
                a patch = (a)object;
                return this.a.equals(patch.a);
            }
            return false;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public <T> a a(DataComponentType<T> component, T value) {
            this.a.put(component, Optional.of(value));
            return this;
        }

        public <T> a a(DataComponentType<T> component) {
            this.a.put(component, Optional.empty());
            return this;
        }

        public <T> a a(TypedDataComponent<T> component) {
            return this.a(component.a(), component.b());
        }

        public DataComponentPatch a() {
            return this.a.isEmpty() ? a : new DataComponentPatch(this.a);
        }
    }

    public static final class c
    extends Record {
        private final DataComponentMap b;
        private final Set<DataComponentType<?>> c;
        public static final c a = new c(DataComponentMap.a, Set.of());

        public c(DataComponentMap added, Set<DataComponentType<?>> removed) {
            this.b = added;
            this.c = removed;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "added;removed", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "added;removed", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "added;removed", "b", "c"}, this, o2);
        }

        public DataComponentMap a() {
            return this.b;
        }

        public Set<DataComponentType<?>> b() {
            return this.c;
        }
    }

    record b(DataComponentType<?> b, boolean c) {
        public static final Codec<b> a = Codec.STRING.flatXmap(sub -> {
            MinecraftKey resourceLocation;
            DataComponentType<?> dataComponentType;
            boolean flag = sub.startsWith(DataComponentPatch.e);
            if (flag) {
                sub = sub.substring(DataComponentPatch.e.length());
            }
            if ((dataComponentType = BuiltInRegistries.ao.a(resourceLocation = MinecraftKey.c(sub))) == null) {
                return DataResult.error(() -> "No component with type: '" + String.valueOf(resourceLocation) + "'");
            }
            return dataComponentType.d() ? DataResult.error(() -> "'" + String.valueOf(resourceLocation) + "' is not a persistent component") : DataResult.success((Object)new b(dataComponentType, flag));
        }, patchKey -> {
            DataComponentType<?> dataComponentType = patchKey.b();
            MinecraftKey key = BuiltInRegistries.ao.b(dataComponentType);
            return key == null ? DataResult.error(() -> "Unregistered component: " + String.valueOf(dataComponentType)) : DataResult.success((Object)(patchKey.c() ? DataComponentPatch.e + String.valueOf(key) : key.toString()));
        });

        public Codec<?> a() {
            return this.c ? Codec.EMPTY.codec() : this.b.c();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "type;removed", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "type;removed", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "type;removed", "b", "c"}, this, o2);
        }
    }
}

