/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;

public interface DataComponentMap
extends Iterable<TypedDataComponent<?>> {
    public static final DataComponentMap a = new DataComponentMap(){

        @Override
        @Nullable
        public <T> T a(DataComponentType<? extends T> component) {
            return null;
        }

        @Override
        public Set<DataComponentType<?>> b() {
            return Set.of();
        }

        @Override
        public Iterator<TypedDataComponent<?>> iterator() {
            return Collections.emptyIterator();
        }
    };
    public static final Codec<DataComponentMap> b = DataComponentMap.b(DataComponentType.d);

    public static Codec<DataComponentMap> a(Codec<DataComponentType<?>> codec) {
        return DataComponentMap.b(Codec.dispatchedMap(codec, DataComponentType::c));
    }

    public static Codec<DataComponentMap> b(Codec<Map<DataComponentType<?>, Object>> codec) {
        return codec.flatComapMap(a::a, map -> {
            int size = map.d();
            if (size == 0) {
                return DataResult.success((Object)Reference2ObjectMaps.emptyMap());
            }
            Reference2ObjectArrayMap map1 = new Reference2ObjectArrayMap(size);
            for (TypedDataComponent<?> typedDataComponent : map) {
                if (typedDataComponent.a().d()) continue;
                map1.put(typedDataComponent.a(), typedDataComponent.b());
            }
            return DataResult.success((Object)map1);
        });
    }

    public static DataComponentMap a(final DataComponentMap map1, final DataComponentMap map2) {
        return new DataComponentMap(){

            @Override
            @Nullable
            public <T> T a(DataComponentType<? extends T> component) {
                T object = map2.a(component);
                return object != null ? object : map1.a(component);
            }

            @Override
            public Set<DataComponentType<?>> b() {
                return Sets.union(map1.b(), map2.b());
            }
        };
    }

    public static a a() {
        return new a();
    }

    @Nullable
    public <T> T a(DataComponentType<? extends T> var1);

    public Set<DataComponentType<?>> b();

    default public boolean b(DataComponentType<?> component) {
        return this.a(component) != null;
    }

    default public <T> T a(DataComponentType<? extends T> component, T defaultValue) {
        T object = this.a(component);
        return object != null ? object : defaultValue;
    }

    @Nullable
    default public <T> TypedDataComponent<T> c(DataComponentType<T> component) {
        T object = this.a(component);
        return object != null ? new TypedDataComponent<T>(component, object) : null;
    }

    @Override
    default public Iterator<TypedDataComponent<?>> iterator() {
        return Iterators.transform(this.b().iterator(), dataComponentType -> Objects.requireNonNull(this.c((DataComponentType)dataComponentType)));
    }

    default public Stream<TypedDataComponent<?>> c() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.d(), 1345), false);
    }

    default public int d() {
        return this.b().size();
    }

    default public boolean e() {
        return this.d() == 0;
    }

    default public DataComponentMap a(final Predicate<DataComponentType<?>> predicate) {
        return new DataComponentMap(){

            @Override
            @Nullable
            public <T> T a(DataComponentType<? extends T> component) {
                return predicate.test(component) ? (T)DataComponentMap.this.a(component) : null;
            }

            @Override
            public Set<DataComponentType<?>> b() {
                return Sets.filter(DataComponentMap.this.b(), predicate::test);
            }
        };
    }

    public static class net.minecraft.core.component.DataComponentMap$a {
        private final Reference2ObjectMap<DataComponentType<?>, Object> a = new Reference2ObjectArrayMap();

        net.minecraft.core.component.DataComponentMap$a() {
        }

        public <T> net.minecraft.core.component.DataComponentMap$a a(DataComponentType<T> component, @Nullable T value) {
            this.b(component, value);
            return this;
        }

        <T> void b(DataComponentType<T> component, @Nullable Object value) {
            if (value != null) {
                this.a.put(component, value);
            } else {
                this.a.remove(component);
            }
        }

        public net.minecraft.core.component.DataComponentMap$a a(DataComponentMap components) {
            for (TypedDataComponent<?> typedDataComponent : components) {
                this.a.put(typedDataComponent.a(), typedDataComponent.b());
            }
            return this;
        }

        public DataComponentMap a() {
            return net.minecraft.core.component.DataComponentMap$a.a(this.a);
        }

        private static DataComponentMap a(Map<DataComponentType<?>, Object> map) {
            if (map.isEmpty()) {
                return a;
            }
            return map.size() < 8 ? new a((Reference2ObjectMap<DataComponentType<?>, Object>)new Reference2ObjectArrayMap(map)) : new a((Reference2ObjectMap<DataComponentType<?>, Object>)new Reference2ObjectOpenHashMap(map));
        }

        static final class a
        extends Record
        implements DataComponentMap {
            private final Reference2ObjectMap<DataComponentType<?>, Object> c;

            a(Reference2ObjectMap<DataComponentType<?>, Object> map) {
                this.c = map;
            }

            @Override
            @Nullable
            public <T> T a(DataComponentType<? extends T> component) {
                return (T)this.c.get(component);
            }

            @Override
            public boolean b(DataComponentType<?> component) {
                return this.c.containsKey(component);
            }

            @Override
            public Set<DataComponentType<?>> b() {
                return this.c.keySet();
            }

            @Override
            public Iterator<TypedDataComponent<?>> iterator() {
                return Iterators.transform((Iterator)Reference2ObjectMaps.fastIterator(this.c), TypedDataComponent::a);
            }

            @Override
            public int d() {
                return this.c.size();
            }

            @Override
            public String toString() {
                return this.c.toString();
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "map", "c"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "map", "c"}, this, o2);
            }

            public Reference2ObjectMap<DataComponentType<?>, Object> f() {
                return this.c;
            }
        }
    }
}

