/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;

public class Vector3f {
    public static final StreamCodec<ByteBuf, Vector3f> a = new StreamCodec<ByteBuf, Vector3f>(){

        public Vector3f a(ByteBuf buffer) {
            return new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }

        public void a(ByteBuf buffer, Vector3f value) {
            buffer.writeFloat(value.b);
            buffer.writeFloat(value.c);
            buffer.writeFloat(value.d);
        }
    };
    protected final float b;
    protected final float c;
    protected final float d;

    public Vector3f(float x2, float y2, float z2) {
        this.b = !Float.isInfinite(x2) && !Float.isNaN(x2) ? x2 % 360.0f : 0.0f;
        this.c = !Float.isInfinite(y2) && !Float.isNaN(y2) ? y2 % 360.0f : 0.0f;
        this.d = !Float.isInfinite(z2) && !Float.isNaN(z2) ? z2 % 360.0f : 0.0f;
    }

    public Vector3f(NBTTagList tag) {
        this(tag.i(0), tag.i(1), tag.i(2));
    }

    private Vector3f(float x2, float y2, float z2, Void dummy_var) {
        this.b = x2;
        this.c = y2;
        this.d = z2;
    }

    public static Vector3f createWithoutValidityChecks(float x2, float y2, float z2) {
        return new Vector3f(x2, y2, z2, null);
    }

    public NBTTagList a() {
        NBTTagList listTag = new NBTTagList();
        listTag.add(NBTTagFloat.a(this.b));
        listTag.add(NBTTagFloat.a(this.c));
        listTag.add(NBTTagFloat.a(this.d));
        return listTag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof Vector3f)) return false;
        Vector3f rotations = (Vector3f)other;
        if (this.b != rotations.b) return false;
        if (this.c != rotations.c) return false;
        if (this.d != rotations.d) return false;
        return true;
    }

    public float b() {
        return this.b;
    }

    public float c() {
        return this.c;
    }

    public float d() {
        return this.d;
    }

    public float e() {
        return MathHelper.h(this.b);
    }

    public float f() {
        return MathHelper.h(this.c);
    }

    public float g() {
        return MathHelper.h(this.d);
    }
}

