/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.util.UndashedUuid;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import net.minecraft.SystemUtils;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;

public final class UUIDUtil {
    public static final Codec<UUID> a = Codec.INT_STREAM.comapFlatMap(uuids -> SystemUtils.a(uuids, 4).map(UUIDUtil::a), uuid -> Arrays.stream(UUIDUtil.a(uuid)));
    public static final Codec<Set<UUID>> b = Codec.list(a).xmap(Sets::newHashSet, Lists::newArrayList);
    public static final Codec<Set<UUID>> c = Codec.list(a).xmap(Sets::newLinkedHashSet, Lists::newArrayList);
    public static final Codec<UUID> d = Codec.STRING.comapFlatMap(uuid -> {
        try {
            return DataResult.success((Object)UUID.fromString(uuid), (Lifecycle)Lifecycle.stable());
        }
        catch (IllegalArgumentException var2) {
            return DataResult.error(() -> "Invalid UUID " + uuid + ": " + var2.getMessage());
        }
    }, UUID::toString);
    public static final Codec<UUID> e = Codec.withAlternative((Codec)Codec.STRING.comapFlatMap(uuid -> {
        try {
            return DataResult.success((Object)UndashedUuid.fromStringLenient((String)uuid), (Lifecycle)Lifecycle.stable());
        }
        catch (IllegalArgumentException var2) {
            return DataResult.error(() -> "Invalid UUID " + uuid + ": " + var2.getMessage());
        }
    }, UndashedUuid::toString), a);
    public static final Codec<UUID> f = Codec.withAlternative(a, d);
    public static final StreamCodec<ByteBuf, UUID> g = new StreamCodec<ByteBuf, UUID>(){

        public UUID a(ByteBuf buffer) {
            return PacketDataSerializer.g(buffer);
        }

        public void a(ByteBuf buffer, UUID value) {
            PacketDataSerializer.a(buffer, value);
        }
    };
    public static final int h = 16;
    private static final String i = "OfflinePlayer:";

    private UUIDUtil() {
    }

    public static UUID a(int[] bits) {
        return new UUID((long)bits[0] << 32 | (long)bits[1] & 0xFFFFFFFFL, (long)bits[2] << 32 | (long)bits[3] & 0xFFFFFFFFL);
    }

    public static int[] a(UUID uuid) {
        long mostSignificantBits = uuid.getMostSignificantBits();
        long leastSignificantBits = uuid.getLeastSignificantBits();
        return UUIDUtil.a(mostSignificantBits, leastSignificantBits);
    }

    private static int[] a(long most, long least) {
        return new int[]{(int)(most >> 32), (int)most, (int)(least >> 32), (int)least};
    }

    public static byte[] b(UUID uuid) {
        byte[] bytes = new byte[16];
        ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        return bytes;
    }

    public static UUID a(Dynamic<?> dynamic) {
        int[] ints = dynamic.asIntStream().toArray();
        if (ints.length != 4) {
            throw new IllegalArgumentException("Could not read UUID. Expected int-array of length 4, got " + ints.length + ".");
        }
        return UUIDUtil.a(ints);
    }

    public static UUID a(String username) {
        return UUID.nameUUIDFromBytes((i + username).getBytes(StandardCharsets.UTF_8));
    }

    public static GameProfile b(String username) {
        UUID uuid = UUIDUtil.a(username);
        return new GameProfile(uuid, username);
    }
}

