/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import ca.spottedleaf.moonrise.patches.collisions.util.CollisionDirection;
import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.Contract;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public final class EnumDirection
extends Enum<EnumDirection>
implements INamable,
CollisionDirection {
    public static final /* enum */ EnumDirection a = new EnumDirection(0, 1, -1, "down", EnumAxisDirection.b, EnumAxis.b, new BaseBlockPosition(0, -1, 0));
    public static final /* enum */ EnumDirection b = new EnumDirection(1, 0, -1, "up", EnumAxisDirection.a, EnumAxis.b, new BaseBlockPosition(0, 1, 0));
    public static final /* enum */ EnumDirection c = new EnumDirection(2, 3, 2, "north", EnumAxisDirection.b, EnumAxis.c, new BaseBlockPosition(0, 0, -1));
    public static final /* enum */ EnumDirection d = new EnumDirection(3, 2, 0, "south", EnumAxisDirection.a, EnumAxis.c, new BaseBlockPosition(0, 0, 1));
    public static final /* enum */ EnumDirection e = new EnumDirection(4, 5, 1, "west", EnumAxisDirection.b, EnumAxis.a, new BaseBlockPosition(-1, 0, 0));
    public static final /* enum */ EnumDirection f = new EnumDirection(5, 4, 3, "east", EnumAxisDirection.a, EnumAxis.a, new BaseBlockPosition(1, 0, 0));
    public static final INamable.a<EnumDirection> g;
    public static final Codec<EnumDirection> h;
    public static final IntFunction<EnumDirection> i;
    public static final StreamCodec<ByteBuf, EnumDirection> j;
    private final int k;
    private final int l;
    private final int m;
    private final String n;
    private final EnumAxis o;
    private final EnumAxisDirection p;
    private final BaseBlockPosition q;
    private final Vec3D r;
    private static final EnumDirection[] s;
    private static final EnumDirection[] t;
    private static final EnumDirection[] u;
    private final int adjX;
    private final int adjY;
    private final int adjZ;
    private static final int RANDOM_OFFSET = 2017601568;
    private EnumDirection opposite;
    private Quaternionf rotation;
    private int id;
    private int stepX;
    private int stepY;
    private int stepZ;
    private static final /* synthetic */ EnumDirection[] v;

    public static EnumDirection[] values() {
        return (EnumDirection[])v.clone();
    }

    public static EnumDirection valueOf(String name) {
        return Enum.valueOf(EnumDirection.class, name);
    }

    private Quaternionf getRotationUncached() {
        switch (this.ordinal()) {
            case 0: {
                return new Quaternionf().rotationX((float)Math.PI);
            }
            case 1: {
                return new Quaternionf();
            }
            case 2: {
                return new Quaternionf().rotationXYZ(1.5707964f, 0.0f, (float)Math.PI);
            }
            case 3: {
                return new Quaternionf().rotationX(1.5707964f);
            }
            case 4: {
                return new Quaternionf().rotationXYZ(1.5707964f, 0.0f, 1.5707964f);
            }
            case 5: {
                return new Quaternionf().rotationXYZ(1.5707964f, 0.0f, -1.5707964f);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final int moonrise$uniqueId() {
        return this.id;
    }

    private EnumDirection(int data3d, int oppositeIndex, int data2d, String name, EnumAxisDirection axisDirection, EnumAxis axis, BaseBlockPosition normal) {
        this.k = data3d;
        this.m = data2d;
        this.l = oppositeIndex;
        this.n = name;
        this.o = axis;
        this.p = axisDirection;
        this.q = normal;
        this.r = Vec3D.a(normal);
        this.adjX = normal.u();
        this.adjY = normal.v();
        this.adjZ = normal.w();
    }

    public static EnumDirection[] a(Entity entity) {
        EnumDirection direction2;
        float f2 = entity.h(1.0f) * ((float)Math.PI / 180);
        float f1 = -entity.i(1.0f) * ((float)Math.PI / 180);
        float sin = MathHelper.a(f2);
        float cos = MathHelper.b(f2);
        float sin1 = MathHelper.a(f1);
        float cos1 = MathHelper.b(f1);
        boolean flag = sin1 > 0.0f;
        boolean flag1 = sin < 0.0f;
        boolean flag2 = cos1 > 0.0f;
        float f22 = flag ? sin1 : -sin1;
        float f3 = flag1 ? -sin : sin;
        float f4 = flag2 ? cos1 : -cos1;
        float f5 = f22 * cos;
        float f6 = f4 * cos;
        EnumDirection direction = flag ? f : e;
        EnumDirection direction1 = flag1 ? b : a;
        EnumDirection enumDirection = direction2 = flag2 ? d : c;
        if (f22 > f4) {
            if (f3 > f5) {
                return EnumDirection.a(direction1, direction, direction2);
            }
            return f6 > f3 ? EnumDirection.a(direction, direction2, direction1) : EnumDirection.a(direction, direction1, direction2);
        }
        if (f3 > f6) {
            return EnumDirection.a(direction1, direction2, direction);
        }
        return f5 > f3 ? EnumDirection.a(direction2, direction, direction1) : EnumDirection.a(direction2, direction1, direction);
    }

    private static EnumDirection[] a(EnumDirection first, EnumDirection second, EnumDirection third) {
        return new EnumDirection[]{first, second, third, third.g(), second.g(), first.g()};
    }

    public static EnumDirection a(Matrix4f matrix, EnumDirection direction) {
        BaseBlockPosition unitVec3i = direction.q();
        Vector4f vector4f = matrix.transform(new Vector4f((float)unitVec3i.u(), (float)unitVec3i.v(), (float)unitVec3i.w(), 0.0f));
        return EnumDirection.a(vector4f.x(), vector4f.y(), vector4f.z());
    }

    public static Collection<EnumDirection> a(RandomSource random) {
        return SystemUtils.b(EnumDirection.values(), random);
    }

    public static Stream<EnumDirection> a() {
        return Stream.of(s);
    }

    public static float a(EnumDirection direction) {
        return switch (direction.ordinal()) {
            case 2 -> 180.0f;
            case 3 -> 0.0f;
            case 4 -> 90.0f;
            case 5 -> -90.0f;
            default -> throw new IllegalStateException("No y-Rot for vertical axis: " + String.valueOf(direction));
        };
    }

    public Quaternionf b() {
        try {
            return (Quaternionf)this.rotation.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex);
        }
    }

    public int d() {
        return this.k;
    }

    public int e() {
        return this.m;
    }

    public EnumAxisDirection f() {
        return this.p;
    }

    public static EnumDirection a(Entity entity, EnumAxis axis) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (f.a(entity.i(1.0f))) {
                    yield f;
                }
                yield e;
            }
            case 1 -> {
                if (entity.h(1.0f) < 0.0f) {
                    yield b;
                }
                yield a;
            }
            case 2 -> d.a(entity.i(1.0f)) ? d : c;
        };
    }

    public EnumDirection g() {
        return this.opposite;
    }

    public EnumDirection a(EnumAxis axis) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this != e && this != f) {
                    yield this.s();
                }
                yield this;
            }
            case 1 -> {
                if (this != b && this != a) {
                    yield this.h();
                }
                yield this;
            }
            case 2 -> this != c && this != d ? this.u() : this;
        };
    }

    public EnumDirection b(EnumAxis axis) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this != e && this != f) {
                    yield this.t();
                }
                yield this;
            }
            case 1 -> {
                if (this != b && this != a) {
                    yield this.i();
                }
                yield this;
            }
            case 2 -> this != c && this != d ? this.v() : this;
        };
    }

    public EnumDirection h() {
        return switch (this.ordinal()) {
            case 2 -> f;
            case 3 -> e;
            case 4 -> c;
            case 5 -> d;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection s() {
        return switch (this.ordinal()) {
            case 0 -> d;
            case 1 -> c;
            case 2 -> a;
            case 3 -> b;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection t() {
        return switch (this.ordinal()) {
            case 0 -> c;
            case 1 -> d;
            case 2 -> b;
            case 3 -> a;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private EnumDirection u() {
        return switch (this.ordinal()) {
            case 0 -> e;
            case 1 -> f;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
            case 4 -> b;
            case 5 -> a;
        };
    }

    private EnumDirection v() {
        return switch (this.ordinal()) {
            case 0 -> f;
            case 1 -> e;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
            case 4 -> a;
            case 5 -> b;
        };
    }

    public EnumDirection i() {
        return switch (this.ordinal()) {
            case 2 -> e;
            case 3 -> f;
            case 4 -> d;
            case 5 -> c;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + String.valueOf(this));
        };
    }

    public int j() {
        return this.adjX;
    }

    public int k() {
        return this.adjY;
    }

    public int l() {
        return this.adjZ;
    }

    public Vector3f m() {
        return new Vector3f((float)this.j(), (float)this.k(), (float)this.l());
    }

    public String n() {
        return this.n;
    }

    public EnumAxis o() {
        return this.o;
    }

    @Nullable
    public static EnumDirection a(@Nullable String name) {
        return g.a(name);
    }

    public static EnumDirection a(int index) {
        return t[MathHelper.a(index % t.length)];
    }

    public static EnumDirection b(int horizontalIndex) {
        return u[MathHelper.a(horizontalIndex % u.length)];
    }

    public static EnumDirection a(double angle) {
        return EnumDirection.b(MathHelper.a(angle / 90.0 + 0.5) & 3);
    }

    public static EnumDirection a(EnumAxis axis, EnumAxisDirection axisDirection) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (axisDirection == EnumAxisDirection.a) {
                    yield f;
                }
                yield e;
            }
            case 1 -> {
                if (axisDirection == EnumAxisDirection.a) {
                    yield b;
                }
                yield a;
            }
            case 2 -> axisDirection == EnumAxisDirection.a ? d : c;
        };
    }

    public float p() {
        return (this.m & 3) * 90;
    }

    public static EnumDirection b(RandomSource random) {
        return SystemUtils.a(s, random);
    }

    public static EnumDirection a(double x2, double y2, double z2) {
        return EnumDirection.a((float)x2, (float)y2, (float)z2);
    }

    public static EnumDirection a(float x2, float y2, float z2) {
        EnumDirection direction = c;
        float f2 = Float.MIN_VALUE;
        for (EnumDirection direction1 : s) {
            float f1 = x2 * (float)direction1.q.u() + y2 * (float)direction1.q.v() + z2 * (float)direction1.q.w();
            if (!(f1 > f2)) continue;
            f2 = f1;
            direction = direction1;
        }
        return direction;
    }

    public static EnumDirection a(Vec3D vector) {
        return EnumDirection.a(vector.d, vector.e, vector.f);
    }

    @Nullable
    @Contract(value="_,_,_,!null->!null;_,_,_,_->_")
    public static EnumDirection a(int x2, int y2, int z2, @Nullable EnumDirection defaultValue) {
        int abs = Math.abs(x2);
        int abs1 = Math.abs(y2);
        int abs2 = Math.abs(z2);
        if (abs > abs2 && abs > abs1) {
            return x2 < 0 ? e : f;
        }
        if (abs2 > abs && abs2 > abs1) {
            return z2 < 0 ? c : d;
        }
        if (abs1 > abs && abs1 > abs2) {
            return y2 < 0 ? a : b;
        }
        return defaultValue;
    }

    @Nullable
    @Contract(value="_,!null->!null;_,_->_")
    public static EnumDirection a(BaseBlockPosition vector, @Nullable EnumDirection defaultValue) {
        return EnumDirection.a(vector.u(), vector.v(), vector.w(), defaultValue);
    }

    public String toString() {
        return this.n;
    }

    @Override
    public String c() {
        return this.n;
    }

    private static DataResult<EnumDirection> b(EnumDirection direction) {
        return direction.o().b() ? DataResult.success((Object)direction) : DataResult.error(() -> "Expected a vertical direction");
    }

    public static EnumDirection a(EnumAxisDirection axisDirection, EnumAxis axis) {
        for (EnumDirection direction : s) {
            if (direction.f() != axisDirection || direction.o() != axis) continue;
            return direction;
        }
        throw new IllegalArgumentException("No such direction: " + String.valueOf((Object)axisDirection) + " " + String.valueOf(axis));
    }

    public BaseBlockPosition q() {
        return this.q;
    }

    public Vec3D r() {
        return this.r;
    }

    public boolean a(float degrees) {
        float f2 = degrees * ((float)Math.PI / 180);
        float f1 = -MathHelper.a(f2);
        float cos = MathHelper.b(f2);
        return (float)this.q.u() * f1 + (float)this.q.w() * cos > 0.0f;
    }

    private static /* synthetic */ EnumDirection[] x() {
        return new EnumDirection[]{a, b, c, d, e, f};
    }

    static {
        v = EnumDirection.x();
        g = INamable.a(EnumDirection::values);
        h = g.validate(EnumDirection::b);
        i = ByIdMap.a(EnumDirection::d, EnumDirection.values(), ByIdMap.a.b);
        j = ByteBufCodecs.a(i, EnumDirection::d);
        s = EnumDirection.values();
        t = (EnumDirection[])Arrays.stream(s).sorted(Comparator.comparingInt(direction -> direction.k)).toArray(EnumDirection[]::new);
        u = (EnumDirection[])Arrays.stream(s).filter(direction -> direction.o().d()).sorted(Comparator.comparingInt(direction -> direction.m)).toArray(EnumDirection[]::new);
        for (EnumDirection direction2 : s) {
            direction2.opposite = EnumDirection.a(direction2.l);
            direction2.rotation = direction2.getRotationUncached();
            direction2.id = HashCommon.murmurHash3((int)(HashCommon.murmurHash3((int)(direction2.ordinal() + 2017601568)) + 2017601568));
            direction2.stepX = direction2.q.u();
            direction2.stepY = direction2.q.v();
            direction2.stepZ = direction2.q.w();
        }
    }

    public static abstract sealed class EnumAxis
    extends Enum<EnumAxis>
    implements INamable,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumAxis a = new EnumAxis("x"){

            @Override
            public int a(int x2, int y2, int z2) {
                return x2;
            }

            @Override
            public double a(double x2, double y2, double z2) {
                return x2;
            }

            @Override
            public EnumDirection e() {
                return EnumDirection.f;
            }

            @Override
            public EnumDirection f() {
                return EnumDirection.e;
            }
        };
        public static final /* enum */ EnumAxis b = new EnumAxis("y"){

            @Override
            public int a(int x2, int y2, int z2) {
                return y2;
            }

            @Override
            public double a(double x2, double y2, double z2) {
                return y2;
            }

            @Override
            public EnumDirection e() {
                return EnumDirection.b;
            }

            @Override
            public EnumDirection f() {
                return EnumDirection.a;
            }
        };
        public static final /* enum */ EnumAxis c = new EnumAxis("z"){

            @Override
            public int a(int x2, int y2, int z2) {
                return z2;
            }

            @Override
            public double a(double x2, double y2, double z2) {
                return z2;
            }

            @Override
            public EnumDirection e() {
                return EnumDirection.d;
            }

            @Override
            public EnumDirection f() {
                return EnumDirection.c;
            }
        };
        public static final EnumAxis[] d;
        public static final INamable.a<EnumAxis> e;
        private final String f;
        private static final /* synthetic */ EnumAxis[] g;

        public static EnumAxis[] values() {
            return (EnumAxis[])g.clone();
        }

        public static EnumAxis valueOf(String name) {
            return Enum.valueOf(EnumAxis.class, name);
        }

        private EnumAxis(String name) {
            this.f = name;
        }

        @Nullable
        public static EnumAxis a(String name) {
            return e.a(name);
        }

        public String a() {
            return this.f;
        }

        public boolean b() {
            return this == b;
        }

        public boolean d() {
            return this == a || this == c;
        }

        public abstract EnumDirection e();

        public abstract EnumDirection f();

        public EnumDirection[] g() {
            return new EnumDirection[]{this.e(), this.f()};
        }

        public String toString() {
            return this.f;
        }

        public static EnumAxis a(RandomSource random) {
            return SystemUtils.a(d, random);
        }

        public boolean a(@Nullable EnumDirection direction) {
            return direction != null && direction.o() == this;
        }

        public EnumDirectionLimit h() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> EnumDirectionLimit.a;
                case 1 -> EnumDirectionLimit.b;
            };
        }

        @Override
        public String c() {
            return this.f;
        }

        public abstract int a(int var1, int var2, int var3);

        public abstract double a(double var1, double var3, double var5);

        private static /* synthetic */ EnumAxis[] i() {
            return new EnumAxis[]{a, b, c};
        }

        static {
            g = EnumAxis.i();
            d = EnumAxis.values();
            e = INamable.a(EnumAxis::values);
        }
    }

    public static final class EnumAxisDirection
    extends Enum<EnumAxisDirection> {
        public static final /* enum */ EnumAxisDirection a = new EnumAxisDirection(1, "Towards positive");
        public static final /* enum */ EnumAxisDirection b = new EnumAxisDirection(-1, "Towards negative");
        private final int c;
        private final String d;
        private static final /* synthetic */ EnumAxisDirection[] e;

        public static EnumAxisDirection[] values() {
            return (EnumAxisDirection[])e.clone();
        }

        public static EnumAxisDirection valueOf(String name) {
            return Enum.valueOf(EnumAxisDirection.class, name);
        }

        private EnumAxisDirection(int step, String name) {
            this.c = step;
            this.d = name;
        }

        public int a() {
            return this.c;
        }

        public String b() {
            return this.d;
        }

        public String toString() {
            return this.d;
        }

        public EnumAxisDirection c() {
            return this == a ? b : a;
        }

        private static /* synthetic */ EnumAxisDirection[] d() {
            return new EnumAxisDirection[]{a, b};
        }

        static {
            e = EnumAxisDirection.d();
        }
    }

    public static final class EnumDirectionLimit
    extends Enum<EnumDirectionLimit>
    implements Iterable<EnumDirection>,
    Predicate<EnumDirection> {
        public static final /* enum */ EnumDirectionLimit a = new EnumDirectionLimit(new EnumDirection[]{c, f, d, e}, new EnumAxis[]{EnumAxis.a, EnumAxis.c});
        public static final /* enum */ EnumDirectionLimit b = new EnumDirectionLimit(new EnumDirection[]{b, a}, new EnumAxis[]{EnumAxis.b});
        private final EnumDirection[] c;
        private final EnumAxis[] d;
        private static final /* synthetic */ EnumDirectionLimit[] e;

        public static EnumDirectionLimit[] values() {
            return (EnumDirectionLimit[])e.clone();
        }

        public static EnumDirectionLimit valueOf(String name) {
            return Enum.valueOf(EnumDirectionLimit.class, name);
        }

        private EnumDirectionLimit(EnumDirection[] faces, EnumAxis[] axis) {
            this.c = faces;
            this.d = axis;
        }

        public EnumDirection a(RandomSource random) {
            return SystemUtils.a(this.c, random);
        }

        public EnumAxis b(RandomSource random) {
            return SystemUtils.a(this.d, random);
        }

        public boolean a(@Nullable EnumDirection direction) {
            return direction != null && direction.o().h() == this;
        }

        @Override
        public Iterator<EnumDirection> iterator() {
            return Iterators.forArray((Object[])this.c);
        }

        public Stream<EnumDirection> a() {
            return Arrays.stream(this.c);
        }

        public List<EnumDirection> c(RandomSource random) {
            return SystemUtils.b(this.c, random);
        }

        public int b() {
            return this.c.length;
        }

        private static /* synthetic */ EnumDirectionLimit[] c() {
            return new EnumDirectionLimit[]{a, b};
        }

        static {
            e = EnumDirectionLimit.c();
        }
    }
}

