/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.synchronization;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import org.slf4j.Logger;

public class ArgumentUtils {
    private static final Logger a = LogUtils.getLogger();
    private static final byte b = 1;
    private static final byte c = 2;

    public static int a(boolean min, boolean max) {
        int i2 = 0;
        if (min) {
            i2 |= 1;
        }
        if (max) {
            i2 |= 2;
        }
        return i2;
    }

    public static boolean a(byte number) {
        return (number & 1) != 0;
    }

    public static boolean b(byte number) {
        return (number & 2) != 0;
    }

    private static <A extends ArgumentType<?>> void a(JsonObject json, ArgumentTypeInfo.a<A> template) {
        ArgumentUtils.a(json, template.a(), template);
    }

    private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.a<A>> void a(JsonObject json, ArgumentTypeInfo<A, T> argumentTypeInfo, ArgumentTypeInfo.a<A> template) {
        argumentTypeInfo.a(template, json);
    }

    private static <T extends ArgumentType<?>> void a(JsonObject json, T type) {
        ArgumentTypeInfo.a<T> template = ArgumentTypeInfos.b(type);
        json.addProperty("type", "argument");
        json.addProperty("parser", BuiltInRegistries.u.b(template.a()).toString());
        JsonObject jsonObject = new JsonObject();
        ArgumentUtils.a(jsonObject, template);
        if (jsonObject.size() > 0) {
            json.add("properties", (JsonElement)jsonObject);
        }
    }

    public static <S> JsonObject a(CommandDispatcher<S> dispatcher, CommandNode<S> node) {
        Collection<String> path;
        JsonObject jsonObject = new JsonObject();
        if (node instanceof RootCommandNode) {
            jsonObject.addProperty("type", "root");
        } else if (node instanceof LiteralCommandNode) {
            jsonObject.addProperty("type", "literal");
        } else if (node instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)node;
            ArgumentUtils.a(jsonObject, argumentCommandNode.getType());
        } else {
            a.error("Could not serialize node {} ({})!", node, node.getClass());
            jsonObject.addProperty("type", "unknown");
        }
        JsonObject jsonObject1 = new JsonObject();
        for (CommandNode<S> commandNode : node.getChildren()) {
            jsonObject1.add(commandNode.getName(), (JsonElement)ArgumentUtils.a(dispatcher, commandNode));
        }
        if (jsonObject1.size() > 0) {
            jsonObject.add("children", (JsonElement)jsonObject1);
        }
        if (node.getCommand() != null) {
            jsonObject.addProperty("executable", Boolean.valueOf(true));
        }
        if (node.getRedirect() != null && !(path = dispatcher.getPath(node.getRedirect())).isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (String string : path) {
                jsonArray.add(string);
            }
            jsonObject.add("redirect", (JsonElement)jsonArray);
        }
        return jsonObject;
    }

    public static <T> Set<ArgumentType<?>> a(CommandNode<T> node) {
        Set set = Sets.newIdentityHashSet();
        HashSet set1 = Sets.newHashSet();
        ArgumentUtils.a(node, set1, set);
        return set1;
    }

    private static <T> void a(CommandNode<T> node, Set<ArgumentType<?>> types, Set<CommandNode<T>> nodes) {
        if (nodes.add(node)) {
            if (node instanceof ArgumentCommandNode) {
                ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)node;
                types.add(argumentCommandNode.getType());
            }
            node.getChildren().forEach(childNode -> ArgumentUtils.a(childNode, types, nodes));
            CommandNode<T> redirect = node.getRedirect();
            if (redirect != null) {
                ArgumentUtils.a(redirect, types, nodes);
            }
        }
    }
}

