/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.functions;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.functions.PlainTextFunction;
import net.minecraft.commands.functions.StringTemplate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;

public class MacroFunction<T extends ExecutionCommandSource<T>>
implements CommandFunction<T> {
    private static final DecimalFormat a = SystemUtils.a(new DecimalFormat("#"), (? super T format) -> {
        format.setMaximumFractionDigits(15);
        format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
    });
    private static final int b = 8;
    private final List<String> c;
    private final Object2ObjectLinkedOpenHashMap<List<String>, InstantiatedFunction<T>> d = new Object2ObjectLinkedOpenHashMap(8, 0.25f);
    private final MinecraftKey e;
    private final List<a<T>> f;

    public MacroFunction(MinecraftKey id, List<a<T>> entries, List<String> parameters) {
        this.e = id;
        this.f = entries;
        this.c = parameters;
    }

    @Override
    public MinecraftKey a() {
        return this.e;
    }

    @Override
    public InstantiatedFunction<T> a(@Nullable NBTTagCompound arguments, CommandDispatcher<T> dispatcher) throws FunctionInstantiationException {
        if (arguments == null) {
            throw new FunctionInstantiationException(IChatBaseComponent.a("commands.function.error.missing_arguments", IChatBaseComponent.a(this.a())));
        }
        ArrayList<String> list = new ArrayList<String>(this.c.size());
        for (String string : this.c) {
            NBTBase tag = arguments.c(string);
            if (tag == null) {
                throw new FunctionInstantiationException(IChatBaseComponent.a("commands.function.error.missing_argument", IChatBaseComponent.a(this.a()), string));
            }
            list.add(MacroFunction.a(tag));
        }
        InstantiatedFunction instantiatedFunction = (InstantiatedFunction)this.d.getAndMoveToLast(list);
        if (instantiatedFunction != null) {
            return instantiatedFunction;
        }
        if (this.d.size() >= 8) {
            this.d.removeFirst();
        }
        InstantiatedFunction<T> instantiatedFunction1 = this.a(this.c, list, dispatcher);
        this.d.put(list, instantiatedFunction1);
        return instantiatedFunction1;
    }

    private static String a(NBTBase tag) {
        String string;
        if (tag instanceof NBTTagFloat) {
            NBTTagFloat floatTag = (NBTTagFloat)tag;
            return a.format(floatTag.k());
        }
        if (tag instanceof NBTTagDouble) {
            NBTTagDouble doubleTag = (NBTTagDouble)tag;
            return a.format(doubleTag.j());
        }
        if (tag instanceof NBTTagByte) {
            NBTTagByte byteTag = (NBTTagByte)tag;
            return String.valueOf(byteTag.i());
        }
        if (tag instanceof NBTTagShort) {
            NBTTagShort shortTag = (NBTTagShort)tag;
            return String.valueOf(shortTag.h());
        }
        if (tag instanceof NBTTagLong) {
            NBTTagLong longTag = (NBTTagLong)tag;
            string = String.valueOf(longTag.f());
        } else {
            string = tag.u_();
        }
        return string;
    }

    private static void a(List<String> arguments, IntList parameters, List<String> output) {
        output.clear();
        parameters.forEach(i2 -> output.add((String)arguments.get(i2)));
    }

    private InstantiatedFunction<T> a(List<String> argumentNames, List<String> argumentValues, CommandDispatcher<T> dispatcher) throws FunctionInstantiationException {
        ArrayList list = new ArrayList(this.f.size());
        ArrayList<String> list1 = new ArrayList<String>(argumentValues.size());
        for (a<T> entry : this.f) {
            MacroFunction.a(argumentValues, entry.a(), list1);
            list.add(entry.a(list1, dispatcher, this.e));
        }
        return new PlainTextFunction(this.a().a(string -> string + "/" + argumentNames.hashCode()), list);
    }

    static interface a<T> {
        public IntList a();

        public UnboundEntryAction<T> a(List<String> var1, CommandDispatcher<T> var2, MinecraftKey var3) throws FunctionInstantiationException;
    }

    static class c<T>
    implements a<T> {
        private final UnboundEntryAction<T> a;

        public c(UnboundEntryAction<T> compiledAction) {
            this.a = compiledAction;
        }

        @Override
        public IntList a() {
            return IntLists.emptyList();
        }

        @Override
        public UnboundEntryAction<T> a(List<String> arguments, CommandDispatcher<T> dispatcher, MinecraftKey function) {
            return this.a;
        }
    }

    static class b<T extends ExecutionCommandSource<T>>
    implements a<T> {
        private final StringTemplate a;
        private final IntList b;
        private final T c;

        public b(StringTemplate template, IntList parameters, T compilationContext) {
            this.a = template;
            this.b = parameters;
            this.c = compilationContext;
        }

        @Override
        public IntList a() {
            return this.b;
        }

        @Override
        public UnboundEntryAction<T> a(List<String> arguments, CommandDispatcher<T> dispatcher, MinecraftKey function) throws FunctionInstantiationException {
            String string = this.a.a(arguments);
            try {
                return CommandFunction.a(dispatcher, this.c, new StringReader(string));
            }
            catch (CommandSyntaxException var6) {
                throw new FunctionInstantiationException(IChatBaseComponent.a("commands.function.error.parse", IChatBaseComponent.a(function), string, var6.getMessage()));
            }
        }
    }
}

