/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentParserPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class VectorPosition
implements IVectorPosition {
    private final ArgumentParserPosition a;
    private final ArgumentParserPosition b;
    private final ArgumentParserPosition c;

    public VectorPosition(ArgumentParserPosition x2, ArgumentParserPosition y2, ArgumentParserPosition z2) {
        this.a = x2;
        this.b = y2;
        this.c = z2;
    }

    @Override
    public Vec3D a(CommandListenerWrapper source) {
        Vec3D position = source.d();
        return new Vec3D(this.a.a(position.d), this.b.a(position.e), this.c.a(position.f));
    }

    @Override
    public Vec2F b(CommandListenerWrapper source) {
        Vec2F rotation = source.k();
        return new Vec2F((float)this.a.a(rotation.i), (float)this.b.a(rotation.j));
    }

    @Override
    public boolean a() {
        return this.a.a();
    }

    @Override
    public boolean b() {
        return this.b.a();
    }

    @Override
    public boolean c() {
        return this.c.a();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof VectorPosition)) return false;
        VectorPosition worldCoordinates = (VectorPosition)other;
        if (!this.a.equals(worldCoordinates.a)) return false;
        if (!this.b.equals(worldCoordinates.b)) return false;
        if (!this.c.equals(worldCoordinates.c)) return false;
        return true;
    }

    public static VectorPosition a(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        ArgumentParserPosition worldCoordinate = ArgumentParserPosition.a(reader);
        if (reader.canRead() && reader.peek() == ' ') {
            reader.skip();
            ArgumentParserPosition worldCoordinate1 = ArgumentParserPosition.a(reader);
            if (reader.canRead() && reader.peek() == ' ') {
                reader.skip();
                ArgumentParserPosition worldCoordinate2 = ArgumentParserPosition.a(reader);
                return new VectorPosition(worldCoordinate, worldCoordinate1, worldCoordinate2);
            }
            reader.setCursor(cursor);
            throw ArgumentVec3.a.createWithContext((ImmutableStringReader)reader);
        }
        reader.setCursor(cursor);
        throw ArgumentVec3.a.createWithContext((ImmutableStringReader)reader);
    }

    public static VectorPosition a(StringReader reader, boolean centerCorrect) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        ArgumentParserPosition worldCoordinate = ArgumentParserPosition.a(reader, centerCorrect);
        if (reader.canRead() && reader.peek() == ' ') {
            reader.skip();
            ArgumentParserPosition worldCoordinate1 = ArgumentParserPosition.a(reader, false);
            if (reader.canRead() && reader.peek() == ' ') {
                reader.skip();
                ArgumentParserPosition worldCoordinate2 = ArgumentParserPosition.a(reader, centerCorrect);
                return new VectorPosition(worldCoordinate, worldCoordinate1, worldCoordinate2);
            }
            reader.setCursor(cursor);
            throw ArgumentVec3.a.createWithContext((ImmutableStringReader)reader);
        }
        reader.setCursor(cursor);
        throw ArgumentVec3.a.createWithContext((ImmutableStringReader)reader);
    }

    public static VectorPosition a(double x2, double y2, double z2) {
        return new VectorPosition(new ArgumentParserPosition(false, x2), new ArgumentParserPosition(false, y2), new ArgumentParserPosition(false, z2));
    }

    public static VectorPosition a(Vec2F vector) {
        return new VectorPosition(new ArgumentParserPosition(false, vector.i), new ArgumentParserPosition(false, vector.j), new ArgumentParserPosition(true, 0.0));
    }

    public int hashCode() {
        int hashCode = this.a.hashCode();
        hashCode = 31 * hashCode + this.b.hashCode();
        return 31 * hashCode + this.c.hashCode();
    }
}

