/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.network.chat.IChatBaseComponent;

public class ArgumentParserPosition {
    private static final char c = '~';
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.pos.missing.double"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.pos.missing.int"));
    private final boolean d;
    private final double e;

    public ArgumentParserPosition(boolean relative, double value) {
        this.d = relative;
        this.e = value;
    }

    public double a(double coord) {
        return this.d ? this.e + coord : this.e;
    }

    public static ArgumentParserPosition a(StringReader reader, boolean centerCorrect) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '^') {
            throw ArgumentVec3.b.createWithContext((ImmutableStringReader)reader);
        }
        if (!reader.canRead()) {
            throw a.createWithContext((ImmutableStringReader)reader);
        }
        boolean isRelative = ArgumentParserPosition.b(reader);
        int cursor = reader.getCursor();
        double d2 = reader.canRead() && reader.peek() != ' ' ? reader.readDouble() : 0.0;
        String sub = reader.getString().substring(cursor, reader.getCursor());
        if (isRelative && sub.isEmpty()) {
            return new ArgumentParserPosition(true, 0.0);
        }
        if (!sub.contains(".") && !isRelative && centerCorrect) {
            d2 += 0.5;
        }
        return new ArgumentParserPosition(isRelative, d2);
    }

    public static ArgumentParserPosition a(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '^') {
            throw ArgumentVec3.b.createWithContext((ImmutableStringReader)reader);
        }
        if (!reader.canRead()) {
            throw b.createWithContext((ImmutableStringReader)reader);
        }
        boolean isRelative = ArgumentParserPosition.b(reader);
        double d2 = reader.canRead() && reader.peek() != ' ' ? (isRelative ? reader.readDouble() : (double)reader.readInt()) : 0.0;
        return new ArgumentParserPosition(isRelative, d2);
    }

    public static boolean b(StringReader reader) {
        boolean flag;
        if (reader.peek() == '~') {
            flag = true;
            reader.skip();
        } else {
            flag = false;
        }
        return flag;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ArgumentParserPosition)) return false;
        ArgumentParserPosition worldCoordinate = (ArgumentParserPosition)other;
        if (this.d != worldCoordinate.d) return false;
        if (Double.compare(worldCoordinate.e, this.e) != 0) return false;
        return true;
    }

    public int hashCode() {
        int i2 = this.d ? 1 : 0;
        long l2 = Double.doubleToLongBits(this.e);
        return 31 * i2 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean a() {
        return this.d;
    }
}

