/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class ArgumentBlock {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.block.tag.disallowed"));
    public static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(block -> IChatBaseComponent.b("argument.block.id.invalid", block));
    public static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((block, property) -> IChatBaseComponent.b("argument.block.property.unknown", block, property));
    public static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((property, block) -> IChatBaseComponent.b("argument.block.property.duplicate", block, property));
    public static final Dynamic3CommandExceptionType e = new Dynamic3CommandExceptionType((block, value, property) -> IChatBaseComponent.b("argument.block.property.invalid", block, property, value));
    public static final Dynamic2CommandExceptionType f = new Dynamic2CommandExceptionType((property, block) -> IChatBaseComponent.b("argument.block.property.novalue", property, block));
    public static final SimpleCommandExceptionType g = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.block.property.unclosed"));
    public static final DynamicCommandExceptionType h = new DynamicCommandExceptionType(blockTag -> IChatBaseComponent.b("arguments.block.tag.unknown", blockTag));
    private static final char i = '[';
    private static final char j = '{';
    private static final char k = ']';
    private static final char l = '=';
    private static final char m = ',';
    private static final char n = '#';
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> o = SuggestionsBuilder::buildFuture;
    private final HolderLookup<Block> p;
    private final StringReader q;
    private final boolean r;
    private final boolean s;
    private final Map<IBlockState<?>, Comparable<?>> t = Maps.newLinkedHashMap();
    private final Map<String, String> u = Maps.newHashMap();
    private MinecraftKey v = MinecraftKey.b("");
    @Nullable
    private BlockStateList<Block, IBlockData> w;
    @Nullable
    private IBlockData x;
    @Nullable
    private NBTTagCompound y;
    @Nullable
    private HolderSet<Block> z;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> A = o;

    private ArgumentBlock(HolderLookup<Block> blocks, StringReader reader, boolean forTesting, boolean allowNbt) {
        this.p = blocks;
        this.q = reader;
        this.r = forTesting;
        this.s = allowNbt;
    }

    public static a a(HolderLookup<Block> lookup, String input, boolean allowNbt) throws CommandSyntaxException {
        return ArgumentBlock.a(lookup, new StringReader(input), allowNbt);
    }

    public static a a(HolderLookup<Block> lookup, StringReader reader, boolean allowNbt) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        try {
            ArgumentBlock blockStateParser = new ArgumentBlock(lookup, reader, false, allowNbt);
            blockStateParser.a();
            return new a(blockStateParser.x, blockStateParser.t, blockStateParser.y);
        }
        catch (CommandSyntaxException var5) {
            reader.setCursor(cursor);
            throw var5;
        }
    }

    public static Either<a, b> b(HolderLookup<Block> lookup, String input, boolean allowNbt) throws CommandSyntaxException {
        return ArgumentBlock.b(lookup, new StringReader(input), allowNbt);
    }

    public static Either<a, b> b(HolderLookup<Block> lookup, StringReader reader, boolean allowNbt) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        try {
            ArgumentBlock blockStateParser = new ArgumentBlock(lookup, reader, true, allowNbt);
            blockStateParser.a();
            return blockStateParser.z != null ? Either.right(new b(blockStateParser.z, blockStateParser.u, blockStateParser.y)) : Either.left(new a(blockStateParser.x, blockStateParser.t, blockStateParser.y));
        }
        catch (CommandSyntaxException var5) {
            reader.setCursor(cursor);
            throw var5;
        }
    }

    public static CompletableFuture<Suggestions> a(HolderLookup<Block> lookup, SuggestionsBuilder builder, boolean forTesting, boolean allowNbt) {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        ArgumentBlock blockStateParser = new ArgumentBlock(lookup, stringReader, forTesting, allowNbt);
        try {
            blockStateParser.a();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return blockStateParser.A.apply(builder.createOffset(stringReader.getCursor()));
    }

    private void a() throws CommandSyntaxException {
        this.A = this.r ? this::l : this::k;
        if (this.q.canRead() && this.q.peek() == '#') {
            this.d();
            this.A = this::h;
            if (this.q.canRead() && this.q.peek() == '[') {
                this.f();
                this.A = this::e;
            }
        } else {
            this.c();
            this.A = this::i;
            if (this.q.canRead() && this.q.peek() == '[') {
                this.e();
                this.A = this::e;
            }
        }
        if (this.s && this.q.canRead() && this.q.peek() == '{') {
            this.A = o;
            this.g();
        }
    }

    private CompletableFuture<Suggestions> a(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        return this.c(builder);
    }

    private CompletableFuture<Suggestions> b(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        return this.d(builder);
    }

    private CompletableFuture<Suggestions> c(SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (IBlockState<?> property : this.x.F()) {
            if (this.t.containsKey(property) || !property.f().startsWith(string)) continue;
            builder.suggest(property.f() + "=");
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> d(SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        if (this.z != null) {
            for (Holder holder : this.z) {
                for (IBlockState<?> property : ((Block)holder.a()).l().d()) {
                    if (this.u.containsKey(property.f()) || !property.f().startsWith(string)) continue;
                    builder.suggest(property.f() + "=");
                }
            }
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> e(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty() && this.b()) {
            builder.suggest(String.valueOf('{'));
        }
        return builder.buildFuture();
    }

    private boolean b() {
        if (this.x != null) {
            return this.x.x();
        }
        if (this.z != null) {
            for (Holder holder : this.z) {
                if (!((Block)holder.a()).m().x()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> f(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('='));
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> g(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf(']'));
        }
        if (builder.getRemaining().isEmpty() && this.t.size() < this.x.F().size()) {
            builder.suggest(String.valueOf(','));
        }
        return builder.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder a(SuggestionsBuilder builder, IBlockState<T> property) {
        for (Comparable comparable : property.a()) {
            if (comparable instanceof Integer) {
                Integer integer = (Integer)comparable;
                builder.suggest(integer.intValue());
                continue;
            }
            builder.suggest(property.b(comparable));
        }
        return builder;
    }

    private CompletableFuture<Suggestions> a(SuggestionsBuilder builder, String propertyName) {
        boolean flag = false;
        if (this.z != null) {
            block0: for (Holder holder : this.z) {
                Block block = (Block)holder.a();
                IBlockState<?> property = block.l().a(propertyName);
                if (property != null) {
                    ArgumentBlock.a(builder, property);
                }
                if (flag) continue;
                for (IBlockState<?> property1 : block.l().d()) {
                    if (this.u.containsKey(property1.f())) continue;
                    flag = true;
                    continue block0;
                }
            }
        }
        if (flag) {
            builder.suggest(String.valueOf(','));
        }
        builder.suggest(String.valueOf(']'));
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> h(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty() && this.z != null) {
            Holder holder;
            Block block;
            boolean flag = false;
            boolean flag1 = false;
            Iterator iterator = this.z.iterator();
            while (!(!iterator.hasNext() || (flag |= !(block = (Block)(holder = (Holder)iterator.next()).a()).l().d().isEmpty()) && (flag1 |= block.m().x()))) {
            }
            if (flag) {
                builder.suggest(String.valueOf('['));
            }
            if (flag1) {
                builder.suggest(String.valueOf('{'));
            }
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> i(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            if (!this.w.d().isEmpty()) {
                builder.suggest(String.valueOf('['));
            }
            if (this.x.x()) {
                builder.suggest(String.valueOf('{'));
            }
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> j(SuggestionsBuilder builder) {
        return ICompletionProvider.a(this.p.f().map(TagKey::b), builder, String.valueOf('#'));
    }

    private CompletableFuture<Suggestions> k(SuggestionsBuilder builder) {
        return ICompletionProvider.a(this.p.c_().map(ResourceKey::a), builder);
    }

    private CompletableFuture<Suggestions> l(SuggestionsBuilder builder) {
        this.j(builder);
        this.k(builder);
        return builder.buildFuture();
    }

    private void c() throws CommandSyntaxException {
        int cursor = this.q.getCursor();
        this.v = MinecraftKey.a(this.q);
        Block block = this.p.a(ResourceKey.a(Registries.f, this.v)).orElseThrow(() -> {
            this.q.setCursor(cursor);
            return b.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString());
        }).a();
        this.w = block.l();
        this.x = block.m();
    }

    private void d() throws CommandSyntaxException {
        if (!this.r) {
            throw a.createWithContext((ImmutableStringReader)this.q);
        }
        int cursor = this.q.getCursor();
        this.q.expect('#');
        this.A = this::j;
        MinecraftKey resourceLocation = MinecraftKey.a(this.q);
        this.z = this.p.a(TagKey.a(Registries.f, resourceLocation)).orElseThrow(() -> {
            this.q.setCursor(cursor);
            return h.createWithContext((ImmutableStringReader)this.q, (Object)resourceLocation.toString());
        });
    }

    private void e() throws CommandSyntaxException {
        this.q.skip();
        this.A = this::a;
        this.q.skipWhitespace();
        while (this.q.canRead() && this.q.peek() != ']') {
            this.q.skipWhitespace();
            int cursor = this.q.getCursor();
            String string = this.q.readString();
            IBlockState<?> property = this.w.a(string);
            if (property == null) {
                this.q.setCursor(cursor);
                throw c.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)string);
            }
            if (this.t.containsKey(property)) {
                this.q.setCursor(cursor);
                throw d.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)string);
            }
            this.q.skipWhitespace();
            this.A = this::f;
            if (!this.q.canRead() || this.q.peek() != '=') {
                throw f.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)string);
            }
            this.q.skip();
            this.q.skipWhitespace();
            this.A = builder -> ArgumentBlock.a(builder, property).buildFuture();
            int cursor1 = this.q.getCursor();
            this.a(property, this.q.readString(), cursor1);
            this.A = this::g;
            this.q.skipWhitespace();
            if (!this.q.canRead()) continue;
            if (this.q.peek() != ',') {
                if (this.q.peek() == ']') break;
                throw g.createWithContext((ImmutableStringReader)this.q);
            }
            this.q.skip();
            this.A = this::c;
        }
        if (!this.q.canRead()) {
            throw g.createWithContext((ImmutableStringReader)this.q);
        }
        this.q.skip();
    }

    private void f() throws CommandSyntaxException {
        this.q.skip();
        this.A = this::b;
        int i2 = -1;
        this.q.skipWhitespace();
        while (this.q.canRead() && this.q.peek() != ']') {
            this.q.skipWhitespace();
            int cursor = this.q.getCursor();
            String string = this.q.readString();
            if (this.u.containsKey(string)) {
                this.q.setCursor(cursor);
                throw d.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)string);
            }
            this.q.skipWhitespace();
            if (!this.q.canRead() || this.q.peek() != '=') {
                this.q.setCursor(cursor);
                throw f.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)string);
            }
            this.q.skip();
            this.q.skipWhitespace();
            this.A = builder -> this.a((SuggestionsBuilder)builder, string);
            i2 = this.q.getCursor();
            String string1 = this.q.readString();
            this.u.put(string, string1);
            this.q.skipWhitespace();
            if (!this.q.canRead()) continue;
            i2 = -1;
            if (this.q.peek() != ',') {
                if (this.q.peek() == ']') break;
                throw g.createWithContext((ImmutableStringReader)this.q);
            }
            this.q.skip();
            this.A = this::d;
        }
        if (!this.q.canRead()) {
            if (i2 >= 0) {
                this.q.setCursor(i2);
            }
            throw g.createWithContext((ImmutableStringReader)this.q);
        }
        this.q.skip();
    }

    private void g() throws CommandSyntaxException {
        this.y = new MojangsonParser(this.q).f();
    }

    private <T extends Comparable<T>> void a(IBlockState<T> property, String value, int valuePosition) throws CommandSyntaxException {
        Optional<T> value1 = property.b(value);
        if (!value1.isPresent()) {
            this.q.setCursor(valuePosition);
            throw e.createWithContext((ImmutableStringReader)this.q, (Object)this.v.toString(), (Object)property.f(), (Object)value);
        }
        this.x = (IBlockData)this.x.b(property, (Comparable)value1.get());
        this.t.put(property, (Comparable)value1.get());
    }

    public static String a(IBlockData state) {
        StringBuilder stringBuilder = new StringBuilder(state.c().e().map(blockKey -> blockKey.a().toString()).orElse("air"));
        if (!state.F().isEmpty()) {
            stringBuilder.append('[');
            boolean flag = false;
            for (Map.Entry<IBlockState<?>, Comparable<?>> entry : state.G().entrySet()) {
                if (flag) {
                    stringBuilder.append(',');
                }
                ArgumentBlock.a(stringBuilder, entry.getKey(), entry.getValue());
                flag = true;
            }
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    private static <T extends Comparable<T>> void a(StringBuilder builder, IBlockState<T> property, Comparable<?> value) {
        builder.append(property.f());
        builder.append('=');
        builder.append(property.b(value));
    }

    public record a(IBlockData a, Map<IBlockState<?>, Comparable<?>> b, @Nullable NBTTagCompound c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blockState;properties;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blockState;properties;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blockState;properties;nbt", "a", "b", "c"}, this, o2);
        }
    }

    public record b(HolderSet<Block> a, Map<String, String> b, @Nullable NBTTagCompound c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "tag;vagueProperties;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "tag;vagueProperties;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "tag;vagueProperties;nbt", "a", "b", "c"}, this, o2);
        }
    }
}

