/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public class ResourceOrTagArgument<T>
implements ArgumentType<c<T>> {
    private static final Collection<String> a = Arrays.asList("foo", "foo:bar", "012", "#skeletons", "#minecraft:skeletons");
    private static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((tagName, tagType) -> IChatBaseComponent.b("argument.resource_tag.not_found", tagName, tagType));
    private static final Dynamic3CommandExceptionType c = new Dynamic3CommandExceptionType((tagName, actualTagType, expectedTagType) -> IChatBaseComponent.b("argument.resource_tag.invalid_type", tagName, actualTagType, expectedTagType));
    private final HolderLookup<T> d;
    final ResourceKey<? extends IRegistry<T>> e;

    public ResourceOrTagArgument(CommandBuildContext context, ResourceKey<? extends IRegistry<T>> registryKey) {
        this.e = registryKey;
        this.d = context.d(registryKey);
    }

    public static <T> ResourceOrTagArgument<T> a(CommandBuildContext context, ResourceKey<? extends IRegistry<T>> registryKey) {
        return new ResourceOrTagArgument<T>(context, registryKey);
    }

    public static <T> c<T> a(CommandContext<CommandListenerWrapper> context, String argument, ResourceKey<IRegistry<T>> registryKey) throws CommandSyntaxException {
        c result = (c)context.getArgument(argument, c.class);
        Optional<c<T>> optional = result.a(registryKey);
        return optional.orElseThrow(() -> result.a().map(holder -> {
            ResourceKey resourceKey = holder.h();
            return ResourceArgument.b.create((Object)resourceKey.a(), (Object)resourceKey.b(), (Object)registryKey.a());
        }, holderSet -> {
            TagKey tagKey = holderSet.h();
            return c.create((Object)tagKey.b(), tagKey.a(), (Object)registryKey.a());
        }));
    }

    public c<T> a(StringReader reader) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '#') {
            int cursor = reader.getCursor();
            try {
                reader.skip();
                MinecraftKey resourceLocation = MinecraftKey.a(reader);
                TagKey tagKey = TagKey.a(this.e, resourceLocation);
                HolderSet.Named named = this.d.a(tagKey).orElseThrow(() -> b.createWithContext((ImmutableStringReader)reader, (Object)resourceLocation, (Object)this.e.a()));
                return new d(named);
            }
            catch (CommandSyntaxException var6) {
                reader.setCursor(cursor);
                throw var6;
            }
        }
        MinecraftKey resourceLocation1 = MinecraftKey.a(reader);
        ResourceKey resourceKey = ResourceKey.a(this.e, resourceLocation1);
        Holder.c reference = this.d.a(resourceKey).orElseThrow(() -> ResourceArgument.a.createWithContext((ImmutableStringReader)reader, (Object)resourceLocation1, (Object)this.e.a()));
        return new b(reference);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ICompletionProvider.a(this.d.f().map(TagKey::b), builder, "#");
        return ICompletionProvider.a(this.d.c_().map(ResourceKey::a), builder);
    }

    public Collection<String> getExamples() {
        return a;
    }

    public static interface c<T>
    extends Predicate<Holder<T>> {
        public Either<Holder.c<T>, HolderSet.Named<T>> a();

        public <E> Optional<c<E>> a(ResourceKey<? extends IRegistry<E>> var1);

        public String b();
    }

    record d<T>(HolderSet.Named<T> a) implements c<T>
    {
        private final HolderSet.Named<T> a;

        @Override
        public Either<Holder.c<T>, HolderSet.Named<T>> a() {
            return Either.right(this.a);
        }

        @Override
        public <E> Optional<c<E>> a(ResourceKey<? extends IRegistry<E>> registryKey) {
            return this.a.h().d(registryKey) ? Optional.of(this) : Optional.empty();
        }

        public boolean a(Holder<T> holder) {
            return this.a.a(holder);
        }

        @Override
        public String b() {
            return "#" + String.valueOf(this.a.h().b());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "tag", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "tag", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "tag", "a"}, this, o2);
        }

        public HolderSet.Named<T> c() {
            return this.a;
        }
    }

    record b<T>(Holder.c<T> a) implements c<T>
    {
        private final Holder.c<T> a;

        @Override
        public Either<Holder.c<T>, HolderSet.Named<T>> a() {
            return Either.left(this.a);
        }

        @Override
        public <E> Optional<c<E>> a(ResourceKey<? extends IRegistry<E>> registryKey) {
            return this.a.h().c(registryKey) ? Optional.of(this) : Optional.empty();
        }

        public boolean a(Holder<T> holder) {
            return holder.equals(this.a);
        }

        @Override
        public String b() {
            return this.a.h().a().toString();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "value", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "value", "a"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "value", "a"}, this, o2);
        }

        public Holder.c<T> c() {
            return this.a;
        }
    }

    public static class net.minecraft.commands.arguments.ResourceOrTagArgument$a<T>
    implements ArgumentTypeInfo<ResourceOrTagArgument<T>, a> {
        @Override
        public void a(a template, PacketDataSerializer buffer) {
            buffer.b(template.b);
        }

        @Override
        public a a(PacketDataSerializer buffer) {
            return new a(buffer.r());
        }

        @Override
        public void a(a template, JsonObject json) {
            json.addProperty("registry", template.b.a().toString());
        }

        @Override
        public a a(ResourceOrTagArgument<T> argument) {
            return new a(argument.e);
        }

        public final class a
        implements ArgumentTypeInfo.a<ResourceOrTagArgument<T>> {
            final ResourceKey<? extends IRegistry<T>> b;

            a(ResourceKey<? extends IRegistry<T>> registryKey) {
                this.b = registryKey;
            }

            public ResourceOrTagArgument<T> a(CommandBuildContext context) {
                return new ResourceOrTagArgument(context, this.b);
            }

            @Override
            public ArgumentTypeInfo<ResourceOrTagArgument<T>, ?> a() {
                return a.this;
            }
        }
    }
}

