/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;

public class ArgumentTime
implements ArgumentType<Integer> {
    private static final Collection<String> a = Arrays.asList("0d", "0s", "0t", "0");
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.time.invalid_unit"));
    private static final Dynamic2CommandExceptionType c = new Dynamic2CommandExceptionType((tickCount, minTickCount) -> IChatBaseComponent.b("argument.time.tick_count_too_low", minTickCount, tickCount));
    private static final Object2IntMap<String> d = new Object2IntOpenHashMap();
    final int e;

    private ArgumentTime(int minimum) {
        this.e = minimum;
    }

    public static ArgumentTime a() {
        return new ArgumentTime(0);
    }

    public static ArgumentTime a(int minimum) {
        return new ArgumentTime(minimum);
    }

    public Integer a(StringReader reader) throws CommandSyntaxException {
        float _float = reader.readFloat();
        String unquotedString = reader.readUnquotedString();
        int orDefault = d.getOrDefault((Object)unquotedString, 0);
        if (orDefault == 0) {
            throw b.createWithContext((ImmutableStringReader)reader);
        }
        int rounded = Math.round(_float * (float)orDefault);
        if (rounded < this.e) {
            throw c.createWithContext((ImmutableStringReader)reader, (Object)rounded, (Object)this.e);
        }
        return rounded;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader stringReader = new StringReader(builder.getRemaining());
        try {
            stringReader.readFloat();
        }
        catch (CommandSyntaxException var5) {
            return builder.buildFuture();
        }
        return ICompletionProvider.b((Iterable<String>)d.keySet(), builder.createOffset(builder.getStart() + stringReader.getCursor()));
    }

    public Collection<String> getExamples() {
        return a;
    }

    static {
        d.put((Object)"d", 24000);
        d.put((Object)"s", 20);
        d.put((Object)"t", 1);
        d.put((Object)"", 1);
    }

    public static class net.minecraft.commands.arguments.ArgumentTime$a
    implements ArgumentTypeInfo<ArgumentTime, a> {
        @Override
        public void a(a template, PacketDataSerializer buffer) {
            buffer.q(template.b);
        }

        @Override
        public a a(PacketDataSerializer buffer) {
            int _int = buffer.readInt();
            return new a(_int);
        }

        @Override
        public void a(a template, JsonObject json) {
            json.addProperty("min", (Number)template.b);
        }

        @Override
        public a a(ArgumentTime argument) {
            return new a(argument.e);
        }

        public final class a
        implements ArgumentTypeInfo.a<ArgumentTime> {
            final int b;

            a(int min) {
                this.b = min;
            }

            public ArgumentTime a(CommandBuildContext context) {
                return ArgumentTime.a(this.b);
            }

            @Override
            public ArgumentTypeInfo<ArgumentTime, ?> a() {
                return a.this;
            }
        }
    }
}

