/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class ArgumentNBTKey
implements ArgumentType<g> {
    private static final Collection<String> d = Arrays.asList("foo", "foo.bar", "foo[0]", "[0]", "[]", "{foo=bar}");
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("arguments.nbtpath.node.invalid"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("arguments.nbtpath.too_deep"));
    public static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(path -> IChatBaseComponent.b("arguments.nbtpath.nothing_found", path));
    static final DynamicCommandExceptionType e = new DynamicCommandExceptionType(actualType -> IChatBaseComponent.b("commands.data.modify.expected_list", actualType));
    static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(invalidIndex -> IChatBaseComponent.b("commands.data.modify.invalid_index", invalidIndex));
    private static final char g = '[';
    private static final char h = ']';
    private static final char i = '{';
    private static final char j = '}';
    private static final char k = '\"';
    private static final char l = '\'';

    public static ArgumentNBTKey a() {
        return new ArgumentNBTKey();
    }

    public static g a(CommandContext<CommandListenerWrapper> context, String name) {
        return (g)context.getArgument(name, g.class);
    }

    public g a(StringReader reader) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayList();
        int cursor = reader.getCursor();
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        boolean flag = true;
        while (reader.canRead() && reader.peek() != ' ') {
            char c2;
            h node = ArgumentNBTKey.a(reader, flag);
            list.add(node);
            map.put((Object)node, reader.getCursor() - cursor);
            flag = false;
            if (!reader.canRead() || (c2 = reader.peek()) == ' ' || c2 == '[' || c2 == '{') continue;
            reader.expect('.');
        }
        return new g(reader.getString().substring(cursor, reader.getCursor()), list.toArray(new h[0]), (Object2IntMap<h>)map);
    }

    private static h a(StringReader reader, boolean first) throws CommandSyntaxException {
        return switch (reader.peek()) {
            case '\"', '\'' -> ArgumentNBTKey.a(reader, reader.readString());
            case '[' -> {
                reader.skip();
                char i = reader.peek();
                if (i == '{') {
                    NBTTagCompound struct1 = new MojangsonParser(reader).f();
                    reader.expect(']');
                    yield new d(struct1);
                }
                if (i == ']') {
                    reader.skip();
                    yield net.minecraft.commands.arguments.ArgumentNBTKey$a.a;
                }
                int _int = reader.readInt();
                reader.expect(']');
                yield new c(_int);
            }
            case '{' -> {
                if (!first) {
                    throw a.createWithContext((ImmutableStringReader)reader);
                }
                NBTTagCompound struct = new MojangsonParser(reader).f();
                yield new f(struct);
            }
            default -> ArgumentNBTKey.a(reader, ArgumentNBTKey.b(reader));
        };
    }

    private static h a(StringReader reader, String name) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '{') {
            NBTTagCompound struct = new MojangsonParser(reader).f();
            return new e(name, struct);
        }
        return new b(name);
    }

    private static String b(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        while (reader.canRead() && ArgumentNBTKey.a(reader.peek())) {
            reader.skip();
        }
        if (reader.getCursor() == cursor) {
            throw a.createWithContext((ImmutableStringReader)reader);
        }
        return reader.getString().substring(cursor, reader.getCursor());
    }

    public Collection<String> getExamples() {
        return d;
    }

    private static boolean a(char ch) {
        return ch != ' ' && ch != '\"' && ch != '\'' && ch != '[' && ch != ']' && ch != '.' && ch != '{' && ch != '}';
    }

    static Predicate<NBTBase> a(NBTTagCompound tag) {
        return other -> GameProfileSerializer.a((NBTBase)tag, other, true);
    }

    public static class g {
        private final String b;
        private final Object2IntMap<h> c;
        private final h[] d;
        public static final Codec<g> a = Codec.STRING.comapFlatMap(string -> {
            try {
                g nbtPath = new ArgumentNBTKey().a(new StringReader(string));
                return DataResult.success((Object)nbtPath);
            }
            catch (CommandSyntaxException var2) {
                return DataResult.error(() -> "Failed to parse path " + string + ": " + var2.getMessage());
            }
        }, g::a);

        public static g a(String path) throws CommandSyntaxException {
            return new ArgumentNBTKey().a(new StringReader(path));
        }

        public g(String original, h[] nodes, Object2IntMap<h> nodeToOriginPosition) {
            this.b = original;
            this.d = nodes;
            this.c = nodeToOriginPosition;
        }

        public List<NBTBase> a(NBTBase tag) throws CommandSyntaxException {
            List<NBTBase> list = Collections.singletonList(tag);
            for (h node : this.d) {
                if (!(list = node.a(list)).isEmpty()) continue;
                throw this.a(node);
            }
            return list;
        }

        public int b(NBTBase tag) {
            List<NBTBase> list = Collections.singletonList(tag);
            for (h node : this.d) {
                if (!(list = node.a(list)).isEmpty()) continue;
                return 0;
            }
            return list.size();
        }

        private List<NBTBase> d(NBTBase tag) throws CommandSyntaxException {
            List<NBTBase> list = Collections.singletonList(tag);
            for (int i2 = 0; i2 < this.d.length - 1; ++i2) {
                h node = this.d[i2];
                int i1 = i2 + 1;
                if (!(list = node.a(list, this.d[i1]::a)).isEmpty()) continue;
                throw this.a(node);
            }
            return list;
        }

        public List<NBTBase> a(NBTBase tag, Supplier<NBTBase> supplier) throws CommandSyntaxException {
            List<NBTBase> parents = this.d(tag);
            h node = this.d[this.d.length - 1];
            return node.a(parents, supplier);
        }

        private static int a(List<NBTBase> tags, Function<NBTBase, Integer> function) {
            return tags.stream().map(function).reduce(0, (integer, integer1) -> integer + integer1);
        }

        public static boolean a(NBTBase tag, int currentDepth) {
            block4: {
                block3: {
                    if (currentDepth >= 512) {
                        return true;
                    }
                    if (!(tag instanceof NBTTagCompound)) break block3;
                    NBTTagCompound compoundTag = (NBTTagCompound)tag;
                    for (String string : compoundTag.e()) {
                        NBTBase tag1 = compoundTag.c(string);
                        if (tag1 == null || !net.minecraft.commands.arguments.ArgumentNBTKey$g.a(tag1, currentDepth + 1)) continue;
                        return true;
                    }
                    break block4;
                }
                if (!(tag instanceof NBTTagList)) break block4;
                for (NBTBase tag2 : (NBTTagList)tag) {
                    if (!net.minecraft.commands.arguments.ArgumentNBTKey$g.a(tag2, currentDepth + 1)) continue;
                    return true;
                }
            }
            return false;
        }

        public int a(NBTBase tag, NBTBase other) throws CommandSyntaxException {
            if (net.minecraft.commands.arguments.ArgumentNBTKey$g.a(other, this.b())) {
                throw b.create();
            }
            NBTBase tag1 = other.d();
            List<NBTBase> parents = this.d(tag);
            if (parents.isEmpty()) {
                return 0;
            }
            h node = this.d[this.d.length - 1];
            MutableBoolean mutableBoolean = new MutableBoolean(false);
            return net.minecraft.commands.arguments.ArgumentNBTKey$g.a(parents, (NBTBase tag2) -> node.a((NBTBase)tag2, () -> {
                if (mutableBoolean.isFalse()) {
                    mutableBoolean.setTrue();
                    return tag1;
                }
                return tag1.d();
            }));
        }

        private int b() {
            return this.d.length;
        }

        public int a(int index, NBTTagCompound rootTag, List<NBTBase> tagsToInsert) throws CommandSyntaxException {
            ArrayList<NBTBase> list = new ArrayList<NBTBase>(tagsToInsert.size());
            for (NBTBase tag : tagsToInsert) {
                NBTBase tag1 = tag.d();
                list.add(tag1);
                if (!net.minecraft.commands.arguments.ArgumentNBTKey$g.a(tag1, this.b())) continue;
                throw b.create();
            }
            List<NBTBase> collection = this.a((NBTBase)rootTag, NBTTagList::new);
            int i2 = 0;
            boolean flag = false;
            for (NBTBase tag2 : collection) {
                if (!(tag2 instanceof NBTList)) {
                    throw e.create((Object)tag2);
                }
                NBTList collectionTag = (NBTList)tag2;
                boolean flag1 = false;
                int i1 = index < 0 ? collectionTag.size() + index + 1 : index;
                for (NBTBase tag3 : list) {
                    try {
                        if (!collectionTag.b(i1, flag ? tag3.d() : tag3)) continue;
                        ++i1;
                        flag1 = true;
                    }
                    catch (IndexOutOfBoundsException var16) {
                        throw f.create((Object)i1);
                    }
                }
                flag = true;
                i2 += flag1 ? 1 : 0;
            }
            return i2;
        }

        public int c(NBTBase tag) {
            List<NBTBase> list = Collections.singletonList(tag);
            for (int i2 = 0; i2 < this.d.length - 1; ++i2) {
                list = this.d[i2].a(list);
            }
            h node = this.d[this.d.length - 1];
            return net.minecraft.commands.arguments.ArgumentNBTKey$g.a(list, node::a);
        }

        private CommandSyntaxException a(h node) {
            int _int = this.c.getInt((Object)node);
            return c.create((Object)this.b.substring(0, _int));
        }

        public String toString() {
            return this.b;
        }

        public String a() {
            return this.b;
        }
    }

    static interface h {
        public void a(NBTBase var1, List<NBTBase> var2);

        public void a(NBTBase var1, Supplier<NBTBase> var2, List<NBTBase> var3);

        public NBTBase a();

        public int a(NBTBase var1, Supplier<NBTBase> var2);

        public int a(NBTBase var1);

        default public List<NBTBase> a(List<NBTBase> tags) {
            return this.a(tags, this::a);
        }

        default public List<NBTBase> a(List<NBTBase> tags, Supplier<NBTBase> supplier) {
            return this.a(tags, (NBTBase tag, List<NBTBase> tagList) -> this.a((NBTBase)tag, supplier, (List<NBTBase>)tagList));
        }

        default public List<NBTBase> a(List<NBTBase> tags, BiConsumer<NBTBase, List<NBTBase>> consumer) {
            ArrayList list = Lists.newArrayList();
            for (NBTBase tag : tags) {
                consumer.accept(tag, list);
            }
            return list;
        }
    }

    static class d
    implements h {
        private final NBTTagCompound a;
        private final Predicate<NBTBase> b;

        public d(NBTTagCompound pattern) {
            this.a = pattern;
            this.b = ArgumentNBTKey.a(pattern);
        }

        @Override
        public void a(NBTBase tag, List<NBTBase> tags) {
            if (tag instanceof NBTTagList) {
                NBTTagList listTag = (NBTTagList)tag;
                listTag.stream().filter(this.b).forEach(tags::add);
            }
        }

        @Override
        public void a(NBTBase tag, Supplier<NBTBase> supplier, List<NBTBase> tags) {
            MutableBoolean mutableBoolean = new MutableBoolean();
            if (tag instanceof NBTTagList) {
                NBTTagList listTag = (NBTTagList)tag;
                listTag.stream().filter(this.b).forEach(currentTag -> {
                    tags.add((NBTBase)currentTag);
                    mutableBoolean.setTrue();
                });
                if (mutableBoolean.isFalse()) {
                    NBTTagCompound compoundTag = this.a.i();
                    listTag.add(compoundTag);
                    tags.add(compoundTag);
                }
            }
        }

        @Override
        public NBTBase a() {
            return new NBTTagList();
        }

        @Override
        public int a(NBTBase tag, Supplier<NBTBase> supplier) {
            int i2 = 0;
            if (tag instanceof NBTTagList) {
                NBTTagList listTag = (NBTTagList)tag;
                int size = listTag.size();
                if (size == 0) {
                    listTag.add(supplier.get());
                    ++i2;
                } else {
                    for (int i1 = 0; i1 < size; ++i1) {
                        NBTBase tag2;
                        NBTBase tag1 = listTag.k(i1);
                        if (!this.b.test(tag1) || (tag2 = supplier.get()).equals(tag1) || !listTag.a(i1, tag2)) continue;
                        ++i2;
                    }
                }
            }
            return i2;
        }

        @Override
        public int a(NBTBase tag) {
            int i2 = 0;
            if (tag instanceof NBTTagList) {
                NBTTagList listTag = (NBTTagList)tag;
                for (int i1 = listTag.size() - 1; i1 >= 0; --i1) {
                    if (!this.b.test(listTag.k(i1))) continue;
                    listTag.c(i1);
                    ++i2;
                }
            }
            return i2;
        }
    }

    static class a
    implements h {
        public static final a a = new a();

        private a() {
        }

        @Override
        public void a(NBTBase tag, List<NBTBase> tags) {
            if (tag instanceof NBTList) {
                tags.addAll((NBTList)tag);
            }
        }

        @Override
        public void a(NBTBase tag, Supplier<NBTBase> supplier, List<NBTBase> tags) {
            if (tag instanceof NBTList) {
                NBTList collectionTag = (NBTList)tag;
                if (collectionTag.isEmpty()) {
                    NBTBase tag1 = supplier.get();
                    if (collectionTag.b(0, tag1)) {
                        tags.add(tag1);
                    }
                } else {
                    tags.addAll(collectionTag);
                }
            }
        }

        @Override
        public NBTBase a() {
            return new NBTTagList();
        }

        @Override
        public int a(NBTBase tag, Supplier<NBTBase> supplier) {
            if (!(tag instanceof NBTList)) {
                return 0;
            }
            NBTList collectionTag = (NBTList)tag;
            int size = collectionTag.size();
            if (size == 0) {
                collectionTag.b(0, supplier.get());
                return 1;
            }
            NBTBase tag1 = supplier.get();
            int i2 = size - (int)collectionTag.stream().filter((Predicate<NBTBase>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Lnet/minecraft/nbt/NBTBase;)Z)((NBTBase)tag1)).count();
            if (i2 == 0) {
                return 0;
            }
            collectionTag.clear();
            if (!collectionTag.b(0, tag1)) {
                return 0;
            }
            for (int i1 = 1; i1 < size; ++i1) {
                collectionTag.b(i1, supplier.get());
            }
            return i2;
        }

        @Override
        public int a(NBTBase tag) {
            NBTList collectionTag;
            int size;
            if (tag instanceof NBTList && (size = (collectionTag = (NBTList)tag).size()) > 0) {
                collectionTag.clear();
                return size;
            }
            return 0;
        }
    }

    static class c
    implements h {
        private final int a;

        public c(int index) {
            this.a = index;
        }

        @Override
        public void a(NBTBase tag, List<NBTBase> tags) {
            if (tag instanceof NBTList) {
                int i2;
                NBTList collectionTag = (NBTList)tag;
                int size = collectionTag.size();
                int n2 = i2 = this.a < 0 ? size + this.a : this.a;
                if (0 <= i2 && i2 < size) {
                    tags.add((NBTBase)collectionTag.get(i2));
                }
            }
        }

        @Override
        public void a(NBTBase tag, Supplier<NBTBase> supplier, List<NBTBase> tags) {
            this.a(tag, tags);
        }

        @Override
        public NBTBase a() {
            return new NBTTagList();
        }

        @Override
        public int a(NBTBase tag, Supplier<NBTBase> supplier) {
            if (tag instanceof NBTList) {
                int i2;
                NBTList collectionTag = (NBTList)tag;
                int size = collectionTag.size();
                int n2 = i2 = this.a < 0 ? size + this.a : this.a;
                if (0 <= i2 && i2 < size) {
                    NBTBase tag1 = (NBTBase)collectionTag.get(i2);
                    NBTBase tag2 = supplier.get();
                    if (!tag2.equals(tag1) && collectionTag.a(i2, tag2)) {
                        return 1;
                    }
                }
            }
            return 0;
        }

        @Override
        public int a(NBTBase tag) {
            if (tag instanceof NBTList) {
                int i2;
                NBTList collectionTag = (NBTList)tag;
                int size = collectionTag.size();
                int n2 = i2 = this.a < 0 ? size + this.a : this.a;
                if (0 <= i2 && i2 < size) {
                    collectionTag.c(i2);
                    return 1;
                }
            }
            return 0;
        }
    }

    static class f
    implements h {
        private final Predicate<NBTBase> a;

        public f(NBTTagCompound tag) {
            this.a = ArgumentNBTKey.a(tag);
        }

        @Override
        public void a(NBTBase tag, List<NBTBase> tags) {
            if (tag instanceof NBTTagCompound && this.a.test(tag)) {
                tags.add(tag);
            }
        }

        @Override
        public void a(NBTBase tag, Supplier<NBTBase> supplier, List<NBTBase> tags) {
            this.a(tag, tags);
        }

        @Override
        public NBTBase a() {
            return new NBTTagCompound();
        }

        @Override
        public int a(NBTBase tag, Supplier<NBTBase> supplier) {
            return 0;
        }

        @Override
        public int a(NBTBase tag) {
            return 0;
        }
    }

    static class e
    implements h {
        private final String a;
        private final NBTTagCompound b;
        private final Predicate<NBTBase> c;

        public e(String name, NBTTagCompound pattern) {
            this.a = name;
            this.b = pattern;
            this.c = ArgumentNBTKey.a(pattern);
        }

        @Override
        public void a(NBTBase tag, List<NBTBase> tags) {
            NBTBase tag1;
            if (tag instanceof NBTTagCompound && this.c.test(tag1 = ((NBTTagCompound)tag).c(this.a))) {
                tags.add(tag1);
            }
        }

        @Override
        public void a(NBTBase tag, Supplier<NBTBase> supplier, List<NBTBase> tags) {
            if (tag instanceof NBTTagCompound) {
                NBTTagCompound compoundTag = (NBTTagCompound)tag;
                NBTBase tag1 = compoundTag.c(this.a);
                if (tag1 == null) {
                    NBTTagCompound var6 = this.b.i();
                    compoundTag.a(this.a, var6);
                    tags.add(var6);
                } else if (this.c.test(tag1)) {
                    tags.add(tag1);
                }
            }
        }

        @Override
        public NBTBase a() {
            return new NBTTagCompound();
        }

        @Override
        public int a(NBTBase tag, Supplier<NBTBase> supplier) {
            NBTBase tag2;
            NBTTagCompound compoundTag;
            NBTBase tag1;
            if (tag instanceof NBTTagCompound && this.c.test(tag1 = (compoundTag = (NBTTagCompound)tag).c(this.a)) && !(tag2 = supplier.get()).equals(tag1)) {
                compoundTag.a(this.a, tag2);
                return 1;
            }
            return 0;
        }

        @Override
        public int a(NBTBase tag) {
            NBTTagCompound compoundTag;
            NBTBase tag1;
            if (tag instanceof NBTTagCompound && this.c.test(tag1 = (compoundTag = (NBTTagCompound)tag).c(this.a))) {
                compoundTag.r(this.a);
                return 1;
            }
            return 0;
        }
    }

    static class b
    implements h {
        private final String a;

        public b(String name) {
            this.a = name;
        }

        @Override
        public void a(NBTBase tag, List<NBTBase> tags) {
            NBTBase tag1;
            if (tag instanceof NBTTagCompound && (tag1 = ((NBTTagCompound)tag).c(this.a)) != null) {
                tags.add(tag1);
            }
        }

        @Override
        public void a(NBTBase tag, Supplier<NBTBase> supplier, List<NBTBase> tags) {
            if (tag instanceof NBTTagCompound) {
                NBTBase tag1;
                NBTTagCompound compoundTag = (NBTTagCompound)tag;
                if (compoundTag.e(this.a)) {
                    tag1 = compoundTag.c(this.a);
                } else {
                    tag1 = supplier.get();
                    compoundTag.a(this.a, tag1);
                }
                tags.add(tag1);
            }
        }

        @Override
        public NBTBase a() {
            return new NBTTagCompound();
        }

        @Override
        public int a(NBTBase tag, Supplier<NBTBase> supplier) {
            if (tag instanceof NBTTagCompound) {
                NBTBase tag2;
                NBTTagCompound compoundTag = (NBTTagCompound)tag;
                NBTBase tag1 = supplier.get();
                if (!tag1.equals(tag2 = compoundTag.a(this.a, tag1))) {
                    return 1;
                }
            }
            return 0;
        }

        @Override
        public int a(NBTBase tag) {
            NBTTagCompound compoundTag;
            if (tag instanceof NBTTagCompound && (compoundTag = (NBTTagCompound)tag).e(this.a)) {
                compoundTag.r(this.a);
                return 1;
            }
            return 0;
        }
    }
}

