/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.phys.Vec3D;

public final class SheepPredicate
extends Record
implements EntitySubPredicate {
    private final Optional<Boolean> c;
    private final Optional<EnumColor> d;
    public static final MapCodec<SheepPredicate> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("sheared").forGetter(SheepPredicate::b), (App)EnumColor.q.optionalFieldOf("color").forGetter(SheepPredicate::c)).apply((Applicative)instance, SheepPredicate::new));

    public SheepPredicate(Optional<Boolean> sheared, Optional<EnumColor> color) {
        this.c = sheared;
        this.d = color;
    }

    public MapCodec<SheepPredicate> a() {
        return EntitySubPredicates.f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean a(Entity entity, WorldServer level, @Nullable Vec3D position) {
        if (!(entity instanceof EntitySheep)) return false;
        EntitySheep sheep = (EntitySheep)entity;
        if (this.c.isPresent()) {
            if (sheep.x() != this.c.get().booleanValue()) return false;
        }
        if (!this.d.isPresent()) return true;
        if (sheep.t() != this.d.get()) return false;
        return true;
    }

    public static SheepPredicate a(EnumColor color) {
        return new SheepPredicate(Optional.of(false), Optional.of(color));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SheepPredicate.class, "sheared;color", "c", "d"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SheepPredicate.class, "sheared;color", "c", "d"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SheepPredicate.class, "sheared;color", "c", "d"}, this, o2);
    }

    public Optional<Boolean> b() {
        return this.c;
    }

    public Optional<EnumColor> c() {
        return this.d;
    }
}

