/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.IChatBaseComponent;

public interface CriterionConditionValue<T extends Number> {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.range.empty"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.range.swapped"));

    public Optional<T> a();

    public Optional<T> b();

    default public boolean c() {
        return this.a().isEmpty() && this.b().isEmpty();
    }

    default public Optional<T> d() {
        Optional<T> optional1;
        Optional<T> optional = this.a();
        return optional.equals(optional1 = this.b()) ? optional : Optional.empty();
    }

    public static <T extends Number, R extends CriterionConditionValue<T>> Codec<R> a(Codec<T> codec, a<T, R> boundsFactory) {
        Codec codec1 = RecordCodecBuilder.create(instance -> instance.group((App)codec.optionalFieldOf("min").forGetter(CriterionConditionValue::a), (App)codec.optionalFieldOf("max").forGetter(CriterionConditionValue::b)).apply((Applicative)instance, boundsFactory::create));
        return Codec.either((Codec)codec1, codec).xmap(either -> either.map(min -> min, max -> boundsFactory.create(Optional.of(max), Optional.of(max))), bounds -> {
            Optional optional = bounds.d();
            return optional.isPresent() ? Either.right((Number)optional.get()) : Either.left(bounds);
        });
    }

    public static <T extends Number, R extends CriterionConditionValue<T>> R a(StringReader reader, b<T, R> boundedFactory, Function<String, T> valueFactory, Supplier<DynamicCommandExceptionType> commandExceptionSupplier, Function<T, T> formatter) throws CommandSyntaxException {
        if (!reader.canRead()) {
            throw a.createWithContext((ImmutableStringReader)reader);
        }
        int cursor = reader.getCursor();
        try {
            Optional<T> optional1;
            Optional<T> optional = CriterionConditionValue.a(reader, valueFactory, commandExceptionSupplier).map(formatter);
            if (reader.canRead(2) && reader.peek() == '.' && reader.peek(1) == '.') {
                reader.skip();
                reader.skip();
                optional1 = CriterionConditionValue.a(reader, valueFactory, commandExceptionSupplier).map(formatter);
                if (optional.isEmpty() && optional1.isEmpty()) {
                    throw a.createWithContext((ImmutableStringReader)reader);
                }
            } else {
                optional1 = optional;
            }
            if (optional.isEmpty() && optional1.isEmpty()) {
                throw a.createWithContext((ImmutableStringReader)reader);
            }
            return boundedFactory.create(reader, optional, optional1);
        }
        catch (CommandSyntaxException var8) {
            reader.setCursor(cursor);
            throw new CommandSyntaxException(var8.getType(), var8.getRawMessage(), var8.getInput(), cursor);
        }
    }

    private static <T extends Number> Optional<T> a(StringReader reader, Function<String, T> stringToValueFunction, Supplier<DynamicCommandExceptionType> commandExceptionSupplier) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        while (reader.canRead() && CriterionConditionValue.a(reader)) {
            reader.skip();
        }
        String sub = reader.getString().substring(cursor, reader.getCursor());
        if (sub.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of((Number)stringToValueFunction.apply(sub));
        }
        catch (NumberFormatException var6) {
            throw commandExceptionSupplier.get().createWithContext((ImmutableStringReader)reader, (Object)sub);
        }
    }

    private static boolean a(StringReader reader) {
        char c2 = reader.peek();
        return c2 >= '0' && c2 <= '9' || c2 == '-' || c2 == '.' && (!reader.canRead(2) || reader.peek(1) != '.');
    }

    @FunctionalInterface
    public static interface a<T extends Number, R extends CriterionConditionValue<T>> {
        public R create(Optional<T> var1, Optional<T> var2);
    }

    @FunctionalInterface
    public static interface b<T extends Number, R extends CriterionConditionValue<T>> {
        public R create(StringReader var1, Optional<T> var2, Optional<T> var3) throws CommandSyntaxException;
    }

    public static final class IntegerRange
    extends Record
    implements CriterionConditionValue<Integer> {
        private final Optional<Integer> e;
        private final Optional<Integer> f;
        private final Optional<Long> g;
        private final Optional<Long> h;
        public static final IntegerRange c = new IntegerRange(Optional.empty(), Optional.empty());
        public static final Codec<IntegerRange> d = CriterionConditionValue.a(Codec.INT, IntegerRange::new);

        private IntegerRange(Optional<Integer> min, Optional<Integer> max) {
            this(min, max, min.map(integer -> integer.longValue() * integer.longValue()), IntegerRange.a(max));
        }

        public IntegerRange(Optional<Integer> min, Optional<Integer> max, Optional<Long> minSq, Optional<Long> maxSq) {
            this.e = min;
            this.f = max;
            this.g = minSq;
            this.h = maxSq;
        }

        private static IntegerRange a(StringReader reader, Optional<Integer> min, Optional<Integer> max) throws CommandSyntaxException {
            if (min.isPresent() && max.isPresent() && min.get() > max.get()) {
                throw b.createWithContext((ImmutableStringReader)reader);
            }
            return new IntegerRange(min, max);
        }

        private static Optional<Long> a(Optional<Integer> value) {
            return value.map(integer -> integer.longValue() * integer.longValue());
        }

        public static IntegerRange a(int value) {
            return new IntegerRange(Optional.of(value), Optional.of(value));
        }

        public static IntegerRange a(int min, int max) {
            return new IntegerRange(Optional.of(min), Optional.of(max));
        }

        public static IntegerRange b(int min) {
            return new IntegerRange(Optional.of(min), Optional.empty());
        }

        public static IntegerRange c(int max) {
            return new IntegerRange(Optional.empty(), Optional.of(max));
        }

        public boolean d(int value) {
            return !(this.e.isPresent() && this.e.get() > value || !this.f.isEmpty() && this.f.get() < value);
        }

        public boolean a(long value) {
            return !(this.g.isPresent() && this.g.get() > value || !this.h.isEmpty() && this.h.get() < value);
        }

        public static IntegerRange a(StringReader reader) throws CommandSyntaxException {
            return IntegerRange.a(reader, (Integer integer) -> integer);
        }

        public static IntegerRange a(StringReader reader, Function<Integer, Integer> valueFunction) throws CommandSyntaxException {
            return CriterionConditionValue.a(reader, IntegerRange::a, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), valueFunction);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntegerRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntegerRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntegerRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this, o2);
        }

        @Override
        public Optional<Integer> a() {
            return this.e;
        }

        @Override
        public Optional<Integer> b() {
            return this.f;
        }

        public Optional<Long> e() {
            return this.g;
        }

        public Optional<Long> f() {
            return this.h;
        }
    }

    public static final class DoubleRange
    extends Record
    implements CriterionConditionValue<Double> {
        private final Optional<Double> e;
        private final Optional<Double> f;
        private final Optional<Double> g;
        private final Optional<Double> h;
        public static final DoubleRange c = new DoubleRange(Optional.empty(), Optional.empty());
        public static final Codec<DoubleRange> d = CriterionConditionValue.a(Codec.DOUBLE, DoubleRange::new);

        private DoubleRange(Optional<Double> min, Optional<Double> max) {
            this(min, max, DoubleRange.a(min), DoubleRange.a(max));
        }

        public DoubleRange(Optional<Double> min, Optional<Double> max, Optional<Double> minSq, Optional<Double> maxSq) {
            this.e = min;
            this.f = max;
            this.g = minSq;
            this.h = maxSq;
        }

        private static DoubleRange a(StringReader reader, Optional<Double> min, Optional<Double> max) throws CommandSyntaxException {
            if (min.isPresent() && max.isPresent() && min.get() > max.get()) {
                throw b.createWithContext((ImmutableStringReader)reader);
            }
            return new DoubleRange(min, max);
        }

        private static Optional<Double> a(Optional<Double> value) {
            return value.map(val -> val * val);
        }

        public static DoubleRange a(double value) {
            return new DoubleRange(Optional.of(value), Optional.of(value));
        }

        public static DoubleRange a(double min, double max) {
            return new DoubleRange(Optional.of(min), Optional.of(max));
        }

        public static DoubleRange b(double min) {
            return new DoubleRange(Optional.of(min), Optional.empty());
        }

        public static DoubleRange c(double max) {
            return new DoubleRange(Optional.empty(), Optional.of(max));
        }

        public boolean d(double value) {
            return !(this.e.isPresent() && this.e.get() > value || !this.f.isEmpty() && this.f.get() < value);
        }

        public boolean e(double value) {
            return !(this.g.isPresent() && this.g.get() > value || !this.h.isEmpty() && this.h.get() < value);
        }

        public static DoubleRange a(StringReader reader) throws CommandSyntaxException {
            return DoubleRange.a(reader, (Double _double) -> _double);
        }

        public static DoubleRange a(StringReader reader, Function<Double, Double> formatter) throws CommandSyntaxException {
            return CriterionConditionValue.a(reader, DoubleRange::a, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble(), formatter);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DoubleRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DoubleRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DoubleRange.class, "min;max;minSq;maxSq", "e", "f", "g", "h"}, this, o2);
        }

        @Override
        public Optional<Double> a() {
            return this.e;
        }

        @Override
        public Optional<Double> b() {
            return this.f;
        }

        public Optional<Double> e() {
            return this.g;
        }

        public Optional<Double> f() {
            return this.h;
        }
    }
}

