/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ExtraCodecs;

public class AdvancementProgress
implements Comparable<AdvancementProgress> {
    private static final DateTimeFormatter b = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss Z", Locale.ROOT);
    private static final Codec<Instant> c = ExtraCodecs.a(b).xmap(Instant::from, instant -> instant.atZone(ZoneId.systemDefault()));
    private static final Codec<Map<String, CriterionProgress>> d = Codec.unboundedMap((Codec)Codec.STRING, c).xmap(achievements -> achievements.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new CriterionProgress((Instant)entry.getValue()))), achievements -> achievements.entrySet().stream().filter(criteria -> ((CriterionProgress)criteria.getValue()).a()).collect(Collectors.toMap(Map.Entry::getKey, entry -> Objects.requireNonNull(((CriterionProgress)entry.getValue()).d()))));
    public static final Codec<AdvancementProgress> a = RecordCodecBuilder.create(instance -> instance.group((App)d.optionalFieldOf("criteria", Map.of()).forGetter(progress -> progress.e), (App)Codec.BOOL.fieldOf("done").orElse((Object)true).forGetter(AdvancementProgress::a)).apply((Applicative)instance, (criteria, done) -> new AdvancementProgress(new HashMap<String, CriterionProgress>((Map<String, CriterionProgress>)criteria))));
    private final Map<String, CriterionProgress> e;
    private AdvancementRequirements f = AdvancementRequirements.b;

    private AdvancementProgress(Map<String, CriterionProgress> criteria) {
        this.e = criteria;
    }

    public AdvancementProgress() {
        this.e = Maps.newHashMap();
    }

    public void a(AdvancementRequirements requirements) {
        Set<String> set = requirements.c();
        this.e.entrySet().removeIf(criteria -> !set.contains(criteria.getKey()));
        for (String string : set) {
            this.e.putIfAbsent(string, new CriterionProgress());
        }
        this.f = requirements;
    }

    public boolean a() {
        return this.f.a(this::d);
    }

    public boolean b() {
        for (CriterionProgress criterionProgress : this.e.values()) {
            if (!criterionProgress.a()) continue;
            return true;
        }
        return false;
    }

    public boolean a(String criterionName) {
        CriterionProgress criterionProgress = this.e.get(criterionName);
        if (criterionProgress != null && !criterionProgress.a()) {
            criterionProgress.b();
            return true;
        }
        return false;
    }

    public boolean b(String criterionName) {
        CriterionProgress criterionProgress = this.e.get(criterionName);
        if (criterionProgress != null && criterionProgress.a()) {
            criterionProgress.c();
            return true;
        }
        return false;
    }

    public String toString() {
        return "AdvancementProgress{criteria=" + String.valueOf(this.e) + ", requirements=" + String.valueOf(this.f) + "}";
    }

    public void a(PacketDataSerializer buffer) {
        buffer.a(this.e, PacketDataSerializer::a, (buffer1, criterionProgress) -> criterionProgress.a((PacketDataSerializer)((Object)buffer1)));
    }

    public static AdvancementProgress b(PacketDataSerializer buffer) {
        CriterionProgress map = buffer.a(PacketDataSerializer::p, CriterionProgress::b);
        return new AdvancementProgress((Map<String, CriterionProgress>)((Object)map));
    }

    @Nullable
    public CriterionProgress c(String criterionName) {
        return this.e.get(criterionName);
    }

    private boolean d(String criterionName) {
        CriterionProgress criterion = this.c(criterionName);
        return criterion != null && criterion.a();
    }

    public float c() {
        if (this.e.isEmpty()) {
            return 0.0f;
        }
        float f2 = this.f.a();
        float f1 = this.h();
        return f1 / f2;
    }

    @Nullable
    public IChatBaseComponent d() {
        if (this.e.isEmpty()) {
            return null;
        }
        int size = this.f.a();
        if (size <= 1) {
            return null;
        }
        int i2 = this.h();
        return IChatBaseComponent.a("advancements.progress", i2, size);
    }

    private int h() {
        return this.f.b(this::d);
    }

    public Iterable<String> e() {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, CriterionProgress> entry : this.e.entrySet()) {
            if (entry.getValue().a()) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    public Iterable<String> f() {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, CriterionProgress> entry : this.e.entrySet()) {
            if (!entry.getValue().a()) continue;
            list.add(entry.getKey());
        }
        return list;
    }

    @Nullable
    public Instant g() {
        return this.e.values().stream().map(CriterionProgress::d).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null);
    }

    public int a(AdvancementProgress other) {
        Instant firstProgressDate = this.g();
        Instant firstProgressDate1 = other.g();
        if (firstProgressDate == null && firstProgressDate1 != null) {
            return 1;
        }
        if (firstProgressDate != null && firstProgressDate1 == null) {
            return -1;
        }
        return firstProgressDate == null && firstProgressDate1 == null ? 0 : firstProgressDate.compareTo(firstProgressDate1);
    }
}

