/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import io.papermc.paper.util.StacktraceDeobfuscator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCallable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.IBlockData;

public class CrashReportSystemDetails {
    private final String a;
    private final List<CrashReportDetail> b = Lists.newArrayList();
    private StackTraceElement[] c = new StackTraceElement[0];

    public CrashReportSystemDetails(String title) {
        this.a = title;
    }

    public static String a(LevelHeightAccessor levelHeightAccess, double x2, double y2, double z2) {
        return String.format(Locale.ROOT, "%.2f,%.2f,%.2f - %s", x2, y2, z2, CrashReportSystemDetails.a(levelHeightAccess, BlockPosition.a(x2, y2, z2)));
    }

    public static String a(LevelHeightAccessor levelHeightAccess, BlockPosition pos) {
        return CrashReportSystemDetails.a(levelHeightAccess, pos.u(), pos.v(), pos.w());
    }

    public static String a(LevelHeightAccessor levelHeightAccess, int x2, int y2, int z2) {
        int i4;
        int maxY;
        int i3;
        int blockPosZ;
        int minY;
        int blockPosX;
        int i2;
        int i1;
        int i5;
        int sectionPosZ;
        int sectionPosY;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(String.format(Locale.ROOT, "World: (%d,%d,%d)", x2, y2, z2));
        }
        catch (Throwable var19) {
            stringBuilder.append("(Error finding world loc)");
        }
        stringBuilder.append(", ");
        try {
            int sectionPosX = SectionPosition.a(x2);
            sectionPosY = SectionPosition.a(y2);
            sectionPosZ = SectionPosition.a(z2);
            i5 = x2 & 0xF;
            i1 = y2 & 0xF;
            i2 = z2 & 0xF;
            blockPosX = SectionPosition.c(sectionPosX);
            minY = levelHeightAccess.L_();
            blockPosZ = SectionPosition.c(sectionPosZ);
            i3 = SectionPosition.c(sectionPosX + 1) - 1;
            maxY = levelHeightAccess.an();
            i4 = SectionPosition.c(sectionPosZ + 1) - 1;
            stringBuilder.append(String.format(Locale.ROOT, "Section: (at %d,%d,%d in %d,%d,%d; chunk contains blocks %d,%d,%d to %d,%d,%d)", i5, i1, i2, sectionPosX, sectionPosY, sectionPosZ, blockPosX, minY, blockPosZ, i3, maxY, i4));
        }
        catch (Throwable var18) {
            stringBuilder.append("(Error finding chunk loc)");
        }
        stringBuilder.append(", ");
        try {
            int sectionPosX = x2 >> 9;
            sectionPosY = z2 >> 9;
            sectionPosZ = sectionPosX << 5;
            i5 = sectionPosY << 5;
            i1 = (sectionPosX + 1 << 5) - 1;
            i2 = (sectionPosY + 1 << 5) - 1;
            blockPosX = sectionPosX << 9;
            minY = levelHeightAccess.L_();
            blockPosZ = sectionPosY << 9;
            i3 = (sectionPosX + 1 << 9) - 1;
            maxY = levelHeightAccess.an();
            i4 = (sectionPosY + 1 << 9) - 1;
            stringBuilder.append(String.format(Locale.ROOT, "Region: (%d,%d; contains chunks %d,%d to %d,%d, blocks %d,%d,%d to %d,%d,%d)", sectionPosX, sectionPosY, sectionPosZ, i5, i1, i2, blockPosX, minY, blockPosZ, i3, maxY, i4));
        }
        catch (Throwable var17) {
            stringBuilder.append("(Error finding world loc)");
        }
        return stringBuilder.toString();
    }

    public CrashReportSystemDetails a(String name, CrashReportCallable<String> detail) {
        try {
            this.a(name, detail.call());
        }
        catch (Throwable var4) {
            this.a(name, var4);
        }
        return this;
    }

    public CrashReportSystemDetails a(String sectionName, Object value) {
        this.b.add(new CrashReportDetail(sectionName, value));
        return this;
    }

    public void a(String sectionName, Throwable throwable) {
        this.a(sectionName, (Object)throwable);
    }

    public int a(int size) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length <= 0) {
            return 0;
        }
        this.c = new StackTraceElement[stackTrace.length - 3 - size];
        System.arraycopy(stackTrace, 3 + size, this.c, 0, this.c.length);
        this.c = StacktraceDeobfuscator.INSTANCE.deobfuscateStacktrace(this.c);
        return this.c.length;
    }

    public boolean a(StackTraceElement s1, StackTraceElement s2) {
        if (this.c.length != 0 && s1 != null) {
            StackTraceElement stackTraceElement = this.c[0];
            if (stackTraceElement.isNativeMethod() == s1.isNativeMethod() && stackTraceElement.getClassName().equals(s1.getClassName()) && stackTraceElement.getFileName().equals(s1.getFileName()) && stackTraceElement.getMethodName().equals(s1.getMethodName())) {
                if (s2 != null != this.c.length > 1) {
                    return false;
                }
                if (s2 != null && !this.c[1].equals(s2)) {
                    return false;
                }
                this.c[0] = s1;
                return true;
            }
            return false;
        }
        return false;
    }

    public void b(int amount) {
        StackTraceElement[] stackTraceElements = new StackTraceElement[this.c.length - amount];
        System.arraycopy(this.c, 0, stackTraceElements, 0, stackTraceElements.length);
        this.c = stackTraceElements;
    }

    public void a(StringBuilder builder) {
        builder.append("-- ").append(this.a).append(" --\n");
        builder.append("Details:");
        for (CrashReportDetail entry : this.b) {
            builder.append("\n\t");
            builder.append(entry.a());
            builder.append(": ");
            builder.append(entry.b());
        }
        if (this.c != null && this.c.length > 0) {
            builder.append("\nStacktrace:");
            for (StackTraceElement stackTraceElement : this.c) {
                builder.append("\n\tat ");
                builder.append(stackTraceElement);
            }
        }
    }

    public StackTraceElement[] a() {
        return this.c;
    }

    public static void a(CrashReportSystemDetails category, LevelHeightAccessor levelHeightAccessor, BlockPosition pos, @Nullable IBlockData state) {
        if (state != null) {
            category.a("Block", state::toString);
        }
        category.a("Block location", () -> CrashReportSystemDetails.a(levelHeightAccessor, pos));
    }

    static class CrashReportDetail {
        private final String a;
        private final String b;

        public CrashReportDetail(String key, @Nullable Object value) {
            this.a = key;
            if (value == null) {
                this.b = "~~NULL~~";
            } else if (value instanceof Throwable) {
                Throwable throwable = (Throwable)value;
                this.b = "~~ERROR~~ " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
            } else {
                this.b = value.toString();
            }
        }

        public String a() {
            return this.a;
        }

        public String b() {
            return this.b;
        }
    }
}

