/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import io.papermc.paper.util.StacktraceDeobfuscator;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SystemReport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_21_R3.CraftCrashReport;
import org.slf4j.Logger;

public class CrashReport {
    private static final Logger a = LogUtils.getLogger();
    private static final DateTimeFormatter b = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
    private final String c;
    private final Throwable d;
    private final List<CrashReportSystemDetails> e = Lists.newArrayList();
    @Nullable
    private Path f;
    private boolean g = true;
    private StackTraceElement[] h = new StackTraceElement[0];
    private final SystemReport i = new SystemReport();

    public CrashReport(String title, Throwable exception) {
        StacktraceDeobfuscator.INSTANCE.deobfuscateThrowable(exception);
        this.c = title;
        this.d = exception;
        this.i.a("CraftBukkit Information", new CraftCrashReport());
    }

    public String a() {
        return this.c;
    }

    public Throwable b() {
        return this.d;
    }

    public String c() {
        StringBuilder stringBuilder = new StringBuilder();
        this.a(stringBuilder);
        return stringBuilder.toString();
    }

    public void a(StringBuilder builder) {
        if (!(this.h != null && this.h.length > 0 || this.e.isEmpty())) {
            this.h = (StackTraceElement[])ArrayUtils.subarray((Object[])this.e.get(0).a(), (int)0, (int)1);
        }
        if (this.h != null && this.h.length > 0) {
            builder.append("-- Head --\n");
            builder.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            builder.append("Stacktrace:\n");
            for (StackTraceElement stackTraceElement : this.h) {
                builder.append("\t").append("at ").append(stackTraceElement);
                builder.append("\n");
            }
            builder.append("\n");
        }
        for (CrashReportSystemDetails crashReportCategory : this.e) {
            crashReportCategory.a(builder);
            builder.append("\n\n");
        }
        this.i.a(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String d() {
        String var4;
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        Throwable throwable = this.d;
        if (throwable.getMessage() == null) {
            if (throwable instanceof NullPointerException) {
                throwable = new NullPointerException(this.c);
            } else if (throwable instanceof StackOverflowError) {
                throwable = new StackOverflowError(this.c);
            } else if (throwable instanceof OutOfMemoryError) {
                throwable = new OutOfMemoryError(this.c);
            }
            throwable.setStackTrace(this.d.getStackTrace());
        }
        try {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            var4 = stringWriter.toString();
        }
        catch (Throwable throwable2) {
            IOUtils.closeQuietly((Writer)stringWriter);
            IOUtils.closeQuietly(printWriter);
            throw throwable2;
        }
        IOUtils.closeQuietly((Writer)stringWriter);
        IOUtils.closeQuietly((Writer)printWriter);
        return var4;
    }

    public String a(ReportType type, List<String> links) {
        StringBuilder stringBuilder = new StringBuilder();
        type.a(stringBuilder, links);
        stringBuilder.append("Time: ");
        stringBuilder.append(b.format(ZonedDateTime.now()));
        stringBuilder.append("\n");
        stringBuilder.append("Description: ");
        stringBuilder.append(this.c);
        stringBuilder.append("\n\n");
        stringBuilder.append(this.d());
        stringBuilder.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i2 = 0; i2 < 87; ++i2) {
            stringBuilder.append("-");
        }
        stringBuilder.append("\n\n");
        this.a(stringBuilder);
        return stringBuilder.toString();
    }

    public String a(ReportType type) {
        return this.a(type, List.of());
    }

    @Nullable
    public Path e() {
        return this.f;
    }

    public boolean a(Path path, ReportType type, List<String> links) {
        if (this.f != null) {
            return false;
        }
        try {
            if (path.getParent() != null) {
                FileUtils.c(path.getParent());
            }
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                bufferedWriter.write(this.a(type, links));
            }
            this.f = path;
            return true;
        }
        catch (Throwable var9) {
            a.error("Could not save crash report to {}", (Object)path, (Object)var9);
            return false;
        }
    }

    public boolean a(Path path, ReportType type) {
        return this.a(path, type, List.of());
    }

    public SystemReport f() {
        return this.i;
    }

    public CrashReportSystemDetails a(String name) {
        return this.a(name, 1);
    }

    public CrashReportSystemDetails a(String categoryName, int stacktraceLength) {
        CrashReportSystemDetails crashReportCategory = new CrashReportSystemDetails(categoryName);
        if (this.g) {
            int i2 = crashReportCategory.a(stacktraceLength);
            StackTraceElement[] stackTrace = this.d.getStackTrace();
            StackTraceElement stackTraceElement = null;
            StackTraceElement stackTraceElement1 = null;
            int i1 = stackTrace.length - i2;
            if (i1 < 0) {
                a.error("Negative index in crash report handler ({}/{})", (Object)stackTrace.length, (Object)i2);
            }
            if (stackTrace != null && 0 <= i1 && i1 < stackTrace.length) {
                stackTraceElement = stackTrace[i1];
                if (stackTrace.length + 1 - i2 < stackTrace.length) {
                    stackTraceElement1 = stackTrace[stackTrace.length + 1 - i2];
                }
            }
            this.g = crashReportCategory.a(stackTraceElement, stackTraceElement1);
            if (stackTrace != null && stackTrace.length >= i2 && 0 <= i1 && i1 < stackTrace.length) {
                this.h = new StackTraceElement[i1];
                System.arraycopy(stackTrace, 0, this.h, 0, this.h.length);
            } else {
                this.g = false;
            }
        }
        this.e.add(crashReportCategory);
        return crashReportCategory;
    }

    public static CrashReport a(Throwable cause, String description) {
        CrashReport report;
        while (cause instanceof CompletionException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof ReportedException) {
            ReportedException reportedException = (ReportedException)cause;
            report = reportedException.a();
        } else {
            report = new CrashReport(description, cause);
        }
        return report;
    }

    public static void g() {
        new CrashReport("Don't panic!", new Throwable()).a(ReportType.a);
    }
}

