/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world.flag;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import io.papermc.paper.world.flag.FeatureDependant;
import io.papermc.paper.world.flag.FeatureFlagProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R3.potion.CraftPotionType;
import org.bukkit.entity.EntityType;
import org.bukkit.potion.PotionType;

public class PaperFeatureFlagProviderImpl
implements FeatureFlagProvider {
    public static final BiMap<org.bukkit.FeatureFlag, FeatureFlag> FLAGS = ImmutableBiMap.of((Object)org.bukkit.FeatureFlag.VANILLA, (Object)FeatureFlags.a, (Object)org.bukkit.FeatureFlag.TRADE_REBALANCE, (Object)FeatureFlags.b, (Object)org.bukkit.FeatureFlag.MINECART_IMPROVEMENTS, (Object)FeatureFlags.d, (Object)org.bukkit.FeatureFlag.REDSTONE_EXPERIMENTS, (Object)FeatureFlags.c);

    public Set<org.bukkit.FeatureFlag> requiredFeatures(FeatureDependant dependant) {
        FeatureFlagSet requiredFeatures = PaperFeatureFlagProviderImpl.getFeatureElement(dependant).i();
        return PaperFeatureFlagProviderImpl.fromNms(requiredFeatures);
    }

    public static Set<org.bukkit.FeatureFlag> fromNms(FeatureFlagSet flagSet) {
        HashSet<org.bukkit.FeatureFlag> flags = new HashSet<org.bukkit.FeatureFlag>();
        for (FeatureFlag nmsFlag : FeatureFlags.e.c.values()) {
            if (!flagSet.b(nmsFlag)) continue;
            flags.add((org.bukkit.FeatureFlag)FLAGS.inverse().get((Object)nmsFlag));
        }
        return Collections.unmodifiableSet(flags);
    }

    static FeatureElement getFeatureElement(FeatureDependant dependant) {
        if (dependant instanceof EntityType) {
            EntityType entityType = (EntityType)dependant;
            return CraftEntityType.bukkitToMinecraft(entityType);
        }
        if (dependant instanceof PotionType) {
            PotionType potionType = (PotionType)dependant;
            return CraftPotionType.bukkitToMinecraft(potionType);
        }
        throw new IllegalArgumentException(String.valueOf(dependant) + " is not a valid feature dependant");
    }
}

