/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import io.papermc.paper.util.ItemObfuscationSession;
import io.papermc.paper.util.SafeAutoClosable;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.ItemContainerContents;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class OversizedItemComponentSanitizer {
    public static final StreamCodec<RegistryFriendlyByteBuf, ChargedProjectiles> CHARGED_PROJECTILES = OversizedItemComponentSanitizer.codec(ChargedProjectiles.c, OversizedItemComponentSanitizer::sanitizeChargedProjectiles);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemContainerContents> CONTAINER = OversizedItemComponentSanitizer.codec(ItemContainerContents.c, contents -> ItemContainerContents.a);
    public static final StreamCodec<RegistryFriendlyByteBuf, BundleContents> BUNDLE_CONTENTS = new StreamCodec<RegistryFriendlyByteBuf, BundleContents>(){

        @Override
        public BundleContents decode(RegistryFriendlyByteBuf buffer) {
            return (BundleContents)BundleContents.c.decode(buffer);
        }

        @Override
        public void encode(RegistryFriendlyByteBuf buffer, BundleContents value) {
            if (!ItemObfuscationSession.currentSession().obfuscationLevel().obfuscateOversized()) {
                BundleContents.c.encode(buffer, value);
                return;
            }
            try (SafeAutoClosable ignored = ItemObfuscationSession.withContext(c2 -> c2.level(ItemObfuscationSession.ObfuscationLevel.OVERSIZED));){
                BundleContents.c.encode(buffer, OversizedItemComponentSanitizer.sanitizeBundleContents(value));
            }
        }
    };

    private static <B, A> StreamCodec<B, A> codec(StreamCodec<B, A> delegate, UnaryOperator<A> sanitizer) {
        return new DataSanitizationCodec<B, A>(delegate, sanitizer);
    }

    private static ChargedProjectiles sanitizeChargedProjectiles(ChargedProjectiles projectiles) {
        if (projectiles.b()) {
            return projectiles;
        }
        return ChargedProjectiles.a(List.of(new ItemStack(projectiles.a(Items.vt) ? Items.vt : Items.pb)));
    }

    private static BundleContents sanitizeBundleContents(BundleContents contents) {
        if (contents.g()) {
            return contents;
        }
        int sizeUsed = MathHelper.a(contents.f(), 64);
        if (sizeUsed <= 64) {
            return new BundleContents(List.of(new ItemStack(Items.rv, Math.max(1, sizeUsed))));
        }
        ObjectArrayList sanitizedRepresentation = new ObjectArrayList(sizeUsed / 64 + 1);
        while (sizeUsed > 0) {
            int stackCount = Math.min(64, sizeUsed);
            sanitizedRepresentation.add(new ItemStack(Items.rv, stackCount));
            sizeUsed -= stackCount;
        }
        return new BundleContents((List<ItemStack>)sanitizedRepresentation);
    }

    private record DataSanitizationCodec<B, A>(StreamCodec<B, A> delegate, UnaryOperator<A> sanitizer) implements StreamCodec<B, A>
    {
        @Override
        public @NonNull A decode(@NonNull B buf) {
            return (A)this.delegate.decode(buf);
        }

        @Override
        public void encode(@NonNull B buf, @NonNull A value) {
            if (!ItemObfuscationSession.currentSession().obfuscationLevel().obfuscateOversized()) {
                this.delegate.encode(buf, value);
            } else {
                this.delegate.encode(buf, this.sanitizer.apply(value));
            }
        }
    }
}

