/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.google.common.base.Preconditions;
import io.papermc.paper.util.SafeAutoClosable;
import java.util.function.UnaryOperator;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class ItemObfuscationSession
implements SafeAutoClosable {
    static final ThreadLocal<ItemObfuscationSession> THREAD_LOCAL_SESSION = ThreadLocal.withInitial(ItemObfuscationSession::new);
    private final ObfuscationContext root;
    private ObfuscationContext context;

    public ItemObfuscationSession() {
        this.context = this.root = new ObfuscationContext(this, null, null, ObfuscationLevel.NONE);
    }

    public static ItemObfuscationSession currentSession() {
        return THREAD_LOCAL_SESSION.get();
    }

    public static ItemObfuscationSession start(ObfuscationLevel level) {
        ItemObfuscationSession sanitizer = THREAD_LOCAL_SESSION.get();
        sanitizer.switchContext(new ObfuscationContext(sanitizer, null, null, level));
        return sanitizer;
    }

    public static SafeAutoClosable withContext(UnaryOperator<ObfuscationContext> contextUpdater) {
        ItemObfuscationSession session = THREAD_LOCAL_SESSION.get();
        if (!session.obfuscationLevel().isObfuscating()) {
            return () -> {};
        }
        ObfuscationContext newContext = (ObfuscationContext)contextUpdater.apply(session.context());
        Preconditions.checkState((newContext != session.context() ? 1 : 0) != 0, (Object)"withContext yielded same context instance, this will break the stack on close");
        session.switchContext(newContext);
        return newContext;
    }

    public void switchContext(ObfuscationContext context) {
        this.context = context;
    }

    public ObfuscationContext context() {
        return this.context;
    }

    @Override
    public void close() {
        this.context = this.root;
    }

    public ObfuscationLevel obfuscationLevel() {
        return this.context.level;
    }

    public record ObfuscationContext(ItemObfuscationSession parent, @Nullable ObfuscationContext previousContext, @Nullable ItemStack itemStack, ObfuscationLevel level) implements SafeAutoClosable
    {
        public ObfuscationContext itemStack(ItemStack itemStack) {
            return new ObfuscationContext(this.parent, this, itemStack, this.level);
        }

        public ObfuscationContext level(ObfuscationLevel obfuscationLevel) {
            return new ObfuscationContext(this.parent, this, this.itemStack, obfuscationLevel);
        }

        @Override
        public void close() {
            this.parent().switchContext(this.previousContext);
        }
    }

    public static enum ObfuscationLevel {
        NONE,
        OVERSIZED,
        ALL;


        public boolean obfuscateOversized() {
            return switch (this.ordinal()) {
                case 1, 2 -> true;
                default -> false;
            };
        }

        public boolean isObfuscating() {
            return this != NONE;
        }
    }
}

