/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.ItemComponentSanitizer;
import io.papermc.paper.util.ItemObfuscationSession;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.NullMarked;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Required;

@NullMarked
public final class ItemObfuscationBinding {
    public final ItemObfuscationSession.ObfuscationLevel level;
    private final BoundObfuscationConfiguration base;
    private final Map<MinecraftKey, BoundObfuscationConfiguration> overrides;
    static final Set<DataComponentType<?>> BASE_OVERRIDERS = Set.of(DataComponents.c, DataComponents.d, DataComponents.e, DataComponents.f, DataComponents.g, DataComponents.h, DataComponents.j, DataComponents.k, DataComponents.l, DataComponents.m, DataComponents.n, DataComponents.o, DataComponents.q, DataComponents.r, DataComponents.s, DataComponents.y, DataComponents.w, DataComponents.A, DataComponents.B, DataComponents.C, DataComponents.E, DataComponents.F, DataComponents.G, DataComponents.H, DataComponents.I, DataComponents.L, DataComponents.Q, DataComponents.R, DataComponents.S, DataComponents.T, DataComponents.b, DataComponents.W, DataComponents.X, DataComponents.Y, DataComponents.Z, DataComponents.aa, DataComponents.ab, DataComponents.ad, DataComponents.af, DataComponents.ah, DataComponents.an, DataComponents.ao, DataComponents.ap);

    public ItemObfuscationBinding(GlobalConfiguration.Anticheat.Obfuscation.Items items) {
        this.level = items.enableItemObfuscation ? ItemObfuscationSession.ObfuscationLevel.ALL : ItemObfuscationSession.ObfuscationLevel.OVERSIZED;
        this.base = ItemObfuscationBinding.bind(items.allModels);
        HashMap<MinecraftKey, BoundObfuscationConfiguration> overrides = new HashMap<MinecraftKey, BoundObfuscationConfiguration>();
        for (Map.Entry<MinecraftKey, AssetObfuscationConfiguration> entry : items.modelOverrides.entrySet()) {
            overrides.put(entry.getKey(), ItemObfuscationBinding.bind(entry.getValue()));
        }
        this.overrides = Collections.unmodifiableMap(overrides);
    }

    private static BoundObfuscationConfiguration bind(AssetObfuscationConfiguration config) {
        HashSet base = new HashSet(BASE_OVERRIDERS);
        base.addAll(config.alsoObfuscate());
        base.removeAll(config.dontObfuscate());
        HashMap finalStrategy = new HashMap();
        for (DataComponentType dataComponentType : base) {
            UnaryOperator<?> sanitizationOverride = ItemComponentSanitizer.SANITIZATION_OVERRIDES.get(dataComponentType);
            if (sanitizationOverride != null) {
                finalStrategy.put(dataComponentType, new BoundObfuscationConfiguration.MutationType.Sanitize(sanitizationOverride));
                continue;
            }
            finalStrategy.put(dataComponentType, BoundObfuscationConfiguration.MutationType.Drop.INSTANCE);
        }
        return new BoundObfuscationConfiguration(config.sanitizeCount(), finalStrategy);
    }

    public BoundObfuscationConfiguration getAssetObfuscation(ItemStack itemStack) {
        if (this.overrides.isEmpty()) {
            return this.base;
        }
        return this.overrides.getOrDefault(itemStack.a(DataComponents.i), this.base);
    }

    @ConfigSerializable
    public record AssetObfuscationConfiguration(@Required boolean sanitizeCount, Set<DataComponentType<?>> dontObfuscate, Set<DataComponentType<?>> alsoObfuscate) {
    }

    public record BoundObfuscationConfiguration(boolean sanitizeCount, Map<DataComponentType<?>, MutationType> patchStrategy) {

        static sealed interface MutationType {

            public record Sanitize(UnaryOperator sanitizer) implements MutationType
            {
            }

            public static enum Drop implements MutationType
            {
                INSTANCE;

            }
        }
    }
}

