/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import com.google.common.collect.ImmutableMap;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.ItemObfuscationBinding;
import io.papermc.paper.util.ItemObfuscationSession;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class ItemComponentSanitizer {
    static final Map<DataComponentType<?>, UnaryOperator<?>> SANITIZATION_OVERRIDES = SystemUtils.a(ImmutableMap.builder(), map -> {
        ItemComponentSanitizer.put(map, DataComponents.ad, ItemComponentSanitizer.empty(new LodestoneTracker(Optional.empty(), false)));
        ItemComponentSanitizer.put(map, DataComponents.Q, ItemComponentSanitizer::sanitizePotionContents);
        if (MinecraftServer.getServer().ba().e(Registries.aO).d() > 0) {
            ItemComponentSanitizer.put(map, DataComponents.l, ItemComponentSanitizer.empty(ItemComponentSanitizer.dummyEnchantments()));
            ItemComponentSanitizer.put(map, DataComponents.I, ItemComponentSanitizer.empty(ItemComponentSanitizer.dummyEnchantments()));
        }
    }).build();

    private static <T> void put(ImmutableMap.Builder map, DataComponentType<T> type, UnaryOperator<T> object) {
        map.put(type, object);
    }

    private static <T> UnaryOperator<T> empty(T object) {
        return unused -> object;
    }

    private static PotionContents sanitizePotionContents(PotionContents potionContents) {
        if (potionContents.f().isPresent()) {
            return new PotionContents(Optional.empty(), potionContents.f(), List.of(), Optional.empty());
        }
        return potionContents;
    }

    private static ItemEnchantments dummyEnchantments() {
        ItemEnchantments.a obj = new ItemEnchantments.a(ItemEnchantments.a);
        obj.a((Holder<Enchantment>)MinecraftServer.getServer().ba().e(Registries.aO).a(RandomSource.a()).orElseThrow(), 1);
        return obj.b();
    }

    public static int sanitizeCount(ItemObfuscationSession obfuscationSession, ItemStack itemStack, int count) {
        if (obfuscationSession.obfuscationLevel() != ItemObfuscationSession.ObfuscationLevel.ALL) {
            return count;
        }
        if (GlobalConfiguration.get().anticheat.obfuscation.items.binding.getAssetObfuscation(itemStack).sanitizeCount()) {
            return 1;
        }
        return count;
    }

    public static boolean shouldDrop(ItemObfuscationSession obfuscationSession, DataComponentType<?> key) {
        if (obfuscationSession.obfuscationLevel() != ItemObfuscationSession.ObfuscationLevel.ALL) {
            return false;
        }
        ItemStack targetItemstack = obfuscationSession.context().itemStack();
        return GlobalConfiguration.get().anticheat.obfuscation.items.binding.getAssetObfuscation(targetItemstack).patchStrategy().get(key) == ItemObfuscationBinding.BoundObfuscationConfiguration.MutationType.Drop.INSTANCE;
    }

    public static Optional<?> override(ItemObfuscationSession obfuscationSession, DataComponentType<?> key, Optional<?> value) {
        if (obfuscationSession.obfuscationLevel() != ItemObfuscationSession.ObfuscationLevel.ALL) {
            return value;
        }
        if (value.isEmpty()) {
            return value;
        }
        ItemStack targetItemstack = obfuscationSession.context().itemStack();
        ItemObfuscationBinding.BoundObfuscationConfiguration.MutationType mutationType = GlobalConfiguration.get().anticheat.obfuscation.items.binding.getAssetObfuscation(targetItemstack).patchStrategy().get(key);
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemObfuscationBinding.BoundObfuscationConfiguration.MutationType.Drop.class, ItemObfuscationBinding.BoundObfuscationConfiguration.MutationType.Sanitize.class}, (Object)mutationType, n2)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                ItemObfuscationBinding.BoundObfuscationConfiguration.MutationType.Drop ignored = (ItemObfuscationBinding.BoundObfuscationConfiguration.MutationType.Drop)mutationType;
                yield Optional.empty();
            }
            case 1 -> {
                ItemObfuscationBinding.BoundObfuscationConfiguration.MutationType.Sanitize sanitize = (ItemObfuscationBinding.BoundObfuscationConfiguration.MutationType.Sanitize)mutationType;
                yield Optional.of(sanitize.sanitizer().apply(value.get()));
            }
            case -1 -> value;
        };
    }
}

