/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.util;

import com.google.common.base.Preconditions;
import com.mojang.serialization.JavaOps;
import io.papermc.paper.adventure.WrapperAwareSerializer;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import org.bukkit.craftbukkit.v1_21_R3.CraftRegistry;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class Conversions {
    private static @Nullable Conversions globalInstance;
    private final RegistryOps.c lookup;
    private final WrapperAwareSerializer serializer;

    public static Conversions global() {
        if (globalInstance == null) {
            final IRegistryCustom globalAccess = CraftRegistry.getMinecraftRegistry();
            Preconditions.checkState((globalAccess != null ? 1 : 0) != 0, (Object)"Global registry access is not available");
            globalInstance = new Conversions(new RegistryOps.c(){

                @Override
                public <T> Optional<RegistryOps.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryRef) {
                    IRegistry registry = globalAccess.e(registryRef);
                    return Optional.of(new RegistryOps.b(registry, registry, registry.h()));
                }
            });
        }
        return globalInstance;
    }

    public Conversions(RegistryOps.c lookup) {
        this.lookup = lookup;
        this.serializer = new WrapperAwareSerializer(() -> RegistryOps.a(JavaOps.INSTANCE, lookup));
    }

    public RegistryOps.c lookup() {
        return this.lookup;
    }

    @Contract(value="null -> null; !null -> !null")
    public @Nullable IChatBaseComponent asVanilla(@Nullable Component adventure) {
        if (adventure == null) {
            return null;
        }
        return this.serializer.serialize(adventure);
    }

    public Component asAdventure(@Nullable IChatBaseComponent vanilla) {
        return vanilla == null ? Component.empty() : this.serializer.deserialize(vanilla);
    }
}

