/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.PaperRegistryBuilderFactory;
import io.papermc.paper.registry.RegistryBuilderFactory;
import io.papermc.paper.registry.data.InlinedRegistryBuilderProvider;
import io.papermc.paper.registry.data.PaintingVariantRegistryEntry;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Art;
import org.bukkit.Keyed;
import org.bukkit.craftbukkit.v1_21_R3.CraftRegistry;

public final class InlinedRegistryBuilderProviderImpl
implements InlinedRegistryBuilderProvider {
    private static <M, A extends Keyed, B extends PaperRegistryBuilder<M, A>> A create(ResourceKey<? extends IRegistry<M>> registryKey, Consumer<PaperRegistryBuilderFactory<M, A, B>> value) {
        RegistryEntryMeta.Buildable buildableMeta = PaperRegistries.getBuildableMeta(registryKey);
        Preconditions.checkArgument((boolean)buildableMeta.registryTypeMapper().supportsDirectHolders(), (Object)"Registry type mapper must support direct holders");
        PaperRegistryBuilderFactory builderFactory = new PaperRegistryBuilderFactory(Conversions.global(), buildableMeta.builderFiller(), CraftRegistry.getMinecraftRegistry(buildableMeta.mcKey())::a);
        value.accept(builderFactory);
        return (A)((Keyed)buildableMeta.registryTypeMapper().createBukkit(Holder.a(builderFactory.requireBuilder().build())));
    }

    public Art createPaintingVariant(Consumer<RegistryBuilderFactory<Art, ? extends PaintingVariantRegistryEntry.Builder>> value) {
        return (Art)InlinedRegistryBuilderProviderImpl.create(Registries.X, value::accept);
    }
}

