/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.PaperDataComponentType;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.PaperSimpleRegistry;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.PaperBannerPatternRegistryEntry;
import io.papermc.paper.registry.data.PaperDamageTypeRegistryEntry;
import io.papermc.paper.registry.data.PaperEnchantmentRegistryEntry;
import io.papermc.paper.registry.data.PaperGameEventRegistryEntry;
import io.papermc.paper.registry.data.PaperPaintingVariantRegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntryBuilder;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import io.papermc.paper.registry.tag.TagKey;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Art;
import org.bukkit.Fluid;
import org.bukkit.GameEvent;
import org.bukkit.JukeboxSong;
import org.bukkit.Keyed;
import org.bukkit.MusicInstrument;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockType;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_21_R3.CraftArt;
import org.bukkit.craftbukkit.v1_21_R3.CraftFluid;
import org.bukkit.craftbukkit.v1_21_R3.CraftGameEvent;
import org.bukkit.craftbukkit.v1_21_R3.CraftJukeboxSong;
import org.bukkit.craftbukkit.v1_21_R3.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R3.CraftSound;
import org.bukkit.craftbukkit.v1_21_R3.attribute.CraftAttribute;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlockType;
import org.bukkit.craftbukkit.v1_21_R3.block.banner.CraftPatternType;
import org.bukkit.craftbukkit.v1_21_R3.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R3.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R3.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R3.generator.structure.CraftStructureType;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftMenuType;
import org.bukkit.craftbukkit.v1_21_R3.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_21_R3.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.v1_21_R3.legacy.FieldRename;
import org.bukkit.craftbukkit.v1_21_R3.map.CraftMapCursor;
import org.bukkit.craftbukkit.v1_21_R3.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftNamespacedKey;
import org.bukkit.damage.DamageType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.generator.structure.Structure;
import org.bukkit.generator.structure.StructureType;
import org.bukkit.inventory.ItemType;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.map.MapCursor;
import org.bukkit.potion.PotionEffectType;
import org.jspecify.annotations.Nullable;

public final class PaperRegistries {
    static final List<RegistryEntry<?, ?>> REGISTRY_ENTRIES = List.of(RegistryEntryBuilder.start(Registries.G, RegistryKey.GAME_EVENT).craft(GameEvent.class, CraftGameEvent::new).writable(PaperGameEventRegistryEntry.PaperBuilder::new), RegistryEntryBuilder.start(Registries.as, RegistryKey.STRUCTURE_TYPE).craft(StructureType.class, CraftStructureType::new).build(), RegistryEntryBuilder.start(Registries.W, RegistryKey.MOB_EFFECT).craft(PotionEffectType.class, CraftPotionEffectType::new).build(), RegistryEntryBuilder.start(Registries.f, RegistryKey.BLOCK).craft(BlockType.class, CraftBlockType::new).build(), RegistryEntryBuilder.start(Registries.K, RegistryKey.ITEM).craft(ItemType.class, CraftItemType::new).build(), RegistryEntryBuilder.start(Registries.l, RegistryKey.CAT_VARIANT).craft(Cat.Type.class, CraftCat.CraftType::new).build(), RegistryEntryBuilder.start(Registries.F, RegistryKey.FROG_VARIANT).craft(Frog.Variant.class, CraftFrog.CraftVariant::new).build(), RegistryEntryBuilder.start(Registries.av, RegistryKey.VILLAGER_PROFESSION).craft(Villager.Profession.class, CraftVillager.CraftProfession::new).build(), RegistryEntryBuilder.start(Registries.aw, RegistryKey.VILLAGER_TYPE).craft(Villager.Type.class, CraftVillager.CraftType::new).build(), RegistryEntryBuilder.start(Registries.aC, RegistryKey.MAP_DECORATION_TYPE).craft(MapCursor.Type.class, CraftMapCursor.CraftType::new).build(), RegistryEntryBuilder.start(Registries.V, RegistryKey.MENU).craft(MenuType.class, CraftMenuType::new).build(), RegistryEntryBuilder.start(Registries.c, RegistryKey.ATTRIBUTE).craft(Attribute.class, CraftAttribute::new).build(), RegistryEntryBuilder.start(Registries.D, RegistryKey.FLUID).craft(Fluid.class, CraftFluid::new).build(), RegistryEntryBuilder.start(Registries.al, RegistryKey.SOUND_EVENT).craft(Sound.class, CraftSound::new, true).build(), RegistryEntryBuilder.start(Registries.az, RegistryKey.DATA_COMPONENT_TYPE).craft(DataComponentTypes.class, PaperDataComponentType::of).build(), RegistryEntryBuilder.start(Registries.aI, RegistryKey.BIOME).craft(Biome.class, CraftBiome::new).build().delayed(), RegistryEntryBuilder.start(Registries.aU, RegistryKey.STRUCTURE).craft(Structure.class, CraftStructure::new).build().delayed(), RegistryEntryBuilder.start(Registries.aZ, RegistryKey.TRIM_MATERIAL).craft(TrimMaterial.class, CraftTrimMaterial::new, true).build().delayed(), RegistryEntryBuilder.start(Registries.ba, RegistryKey.TRIM_PATTERN).craft(TrimPattern.class, CraftTrimPattern::new, true).build().delayed(), RegistryEntryBuilder.start(Registries.s, RegistryKey.DAMAGE_TYPE).craft(DamageType.class, CraftDamageType::new).writable(PaperDamageTypeRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.m, RegistryKey.WOLF_VARIANT).craft(Wolf.Variant.class, CraftWolf.CraftVariant::new).build().delayed(), RegistryEntryBuilder.start(Registries.aO, RegistryKey.ENCHANTMENT).craft(Enchantment.class, CraftEnchantment::new).serializationUpdater(FieldRename.ENCHANTMENT_RENAME).writable(PaperEnchantmentRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.L, RegistryKey.JUKEBOX_SONG).craft(JukeboxSong.class, CraftJukeboxSong::new).build().delayed(), RegistryEntryBuilder.start(Registries.d, RegistryKey.BANNER_PATTERN).craft(PatternType.class, CraftPatternType::new, true).writable(PaperBannerPatternRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.X, RegistryKey.PAINTING_VARIANT).craft(Art.class, CraftArt::new, true).writable(PaperPaintingVariantRegistryEntry.PaperBuilder::new).delayed(), RegistryEntryBuilder.start(Registries.I, RegistryKey.INSTRUMENT).craft(MusicInstrument.class, CraftMusicInstrument::new, true).build().delayed(), RegistryEntryBuilder.start(Registries.z, RegistryKey.ENTITY_TYPE).apiOnly(PaperSimpleRegistry::entityType), RegistryEntryBuilder.start(Registries.Y, RegistryKey.PARTICLE_TYPE).apiOnly(PaperSimpleRegistry::particleType), RegistryEntryBuilder.start(Registries.ad, RegistryKey.POTION).apiOnly(PaperSimpleRegistry::potion), RegistryEntryBuilder.start(Registries.U, RegistryKey.MEMORY_MODULE_TYPE).apiOnly(() -> Registry.MEMORY_MODULE_TYPE));
    private static final Map<RegistryKey<?>, RegistryEntry<?, ?>> BY_REGISTRY_KEY;
    private static final Map<ResourceKey<?>, RegistryEntry<?, ?>> BY_RESOURCE_KEY;

    public static <M, T extends Keyed> @Nullable RegistryEntry<M, T> getEntry(ResourceKey<? extends IRegistry<M>> resourceKey) {
        return BY_RESOURCE_KEY.get(resourceKey);
    }

    public static <M, T extends Keyed> @Nullable RegistryEntry<M, T> getEntry(RegistryKey<? super T> registryKey) {
        return BY_REGISTRY_KEY.get(registryKey);
    }

    public static <M, T extends Keyed, B extends PaperRegistryBuilder<M, T>> RegistryEntryMeta.Buildable<M, T, B> getBuildableMeta(ResourceKey<? extends IRegistry<M>> resourceKey) {
        RegistryEntry<M, T> entry = PaperRegistries.getEntry(resourceKey);
        if (entry == null) {
            throw new IllegalArgumentException("No registry entry for " + String.valueOf(resourceKey));
        }
        RegistryEntryMeta<M, T> registryEntryMeta = entry.meta();
        if (!(registryEntryMeta instanceof RegistryEntryMeta.Buildable)) {
            throw new IllegalArgumentException("Registry entry for " + String.valueOf(resourceKey) + " is not buildable");
        }
        RegistryEntryMeta.Buildable buildableMeta = (RegistryEntryMeta.Buildable)registryEntryMeta;
        return buildableMeta;
    }

    public static <M, T> RegistryKey<T> registryFromNms(ResourceKey<? extends IRegistry<M>> registryResourceKey) {
        return Objects.requireNonNull(BY_RESOURCE_KEY.get(registryResourceKey), String.valueOf(registryResourceKey) + " doesn't have an api RegistryKey").apiKey();
    }

    public static <M, T> ResourceKey<? extends IRegistry<M>> registryToNms(RegistryKey<T> registryKey) {
        return Objects.requireNonNull(BY_REGISTRY_KEY.get(registryKey), String.valueOf(registryKey) + " doesn't have an mc registry ResourceKey").mcKey();
    }

    public static <M, T> TypedKey<T> fromNms(ResourceKey<M> resourceKey) {
        return TypedKey.create(PaperRegistries.registryFromNms(resourceKey.c()), (Key)CraftNamespacedKey.fromMinecraft(resourceKey.a()));
    }

    public static <M, T> ResourceKey<M> toNms(TypedKey<T> typedKey) {
        return ResourceKey.a(PaperRegistries.registryToNms(typedKey.registryKey()), PaperAdventure.asVanilla(typedKey.key()));
    }

    public static <M, T> TagKey<T> fromNms(net.minecraft.tags.TagKey<M> tagKey) {
        return TagKey.create(PaperRegistries.registryFromNms(tagKey.a()), (Key)CraftNamespacedKey.fromMinecraft(tagKey.b()));
    }

    public static <M, T> net.minecraft.tags.TagKey<M> toNms(TagKey<T> tagKey) {
        return net.minecraft.tags.TagKey.a(PaperRegistries.registryToNms(tagKey.registryKey()), PaperAdventure.asVanilla(tagKey.key()));
    }

    private PaperRegistries() {
    }

    static {
        IdentityHashMap byRegistryKey = new IdentityHashMap(REGISTRY_ENTRIES.size());
        IdentityHashMap byResourceKey = new IdentityHashMap(REGISTRY_ENTRIES.size());
        for (RegistryEntry<?, ?> entry : REGISTRY_ENTRIES) {
            Preconditions.checkState((byRegistryKey.put(entry.apiKey(), entry) == null ? 1 : 0) != 0, (String)"Duplicate api registry key: %s", entry.apiKey());
            Preconditions.checkState((byResourceKey.put(entry.mcKey(), entry) == null ? 1 : 0) != 0, (String)"Duplicate mc registry key: %s", entry.mcKey());
        }
        BY_REGISTRY_KEY = Collections.unmodifiableMap(byRegistryKey);
        BY_RESOURCE_KEY = Collections.unmodifiableMap(byResourceKey);
    }
}

