/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.configuration;

import com.google.gson.reflect.TypeToken;
import io.papermc.paper.plugin.provider.configuration.type.DependencyConfiguration;
import io.papermc.paper.plugin.provider.configuration.type.PluginDependencyLifeCycle;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Required;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;

class LegacyPaperMeta {
    private static final TypeToken<Map<PluginDependencyLifeCycle, Map<String, DependencyConfiguration>>> TYPE_TOKEN = new TypeToken<Map<PluginDependencyLifeCycle, Map<String, DependencyConfiguration>>>(){};

    LegacyPaperMeta() {
    }

    public static void migrate(CommentedConfigurationNode node) throws ConfigurateException {
        ConfigurationTransformation.chain((ConfigurationTransformation[])new ConfigurationTransformation[]{LegacyPaperMeta.notVersioned()}).apply((ConfigurationNode)node);
    }

    private static ConfigurationTransformation notVersioned() {
        return ConfigurationTransformation.builder().addAction(NodePath.path(), (path, value) -> {
            Set dependencyFlags;
            LegacyConfiguration legacyConfiguration;
            boolean bootstrapSubSection = value.hasChild(new Object[]{"bootstrap"});
            boolean serverSubSection = value.hasChild(new Object[]{"server"});
            if (bootstrapSubSection || serverSubSection) {
                return null;
            }
            try {
                legacyConfiguration = (LegacyConfiguration)value.require(LegacyConfiguration.class);
            }
            catch (SerializationException exception) {
                return null;
            }
            EnumMap dependencies = new EnumMap(PluginDependencyLifeCycle.class);
            dependencies.put(PluginDependencyLifeCycle.BOOTSTRAP, new HashMap());
            dependencies.put(PluginDependencyLifeCycle.SERVER, new HashMap());
            HashMap dependencyConfigurationMap = new HashMap();
            dependencyConfigurationMap.put(PluginDependencyLifeCycle.BOOTSTRAP, new HashMap());
            dependencyConfigurationMap.put(PluginDependencyLifeCycle.SERVER, new HashMap());
            for (LegacyLoadConfiguration legacyLoadConfiguration : legacyConfiguration.loadAfter) {
                dependencyFlags = ((Map)dependencyConfigurationMap.get((Object)(legacyLoadConfiguration.bootstrap ? PluginDependencyLifeCycle.BOOTSTRAP : PluginDependencyLifeCycle.SERVER))).computeIfAbsent(legacyLoadConfiguration.name, s2 -> EnumSet.noneOf(DependencyFlag.class));
                dependencyFlags.add(DependencyFlag.LOAD_AFTER);
            }
            for (LegacyLoadConfiguration legacyLoadConfiguration : legacyConfiguration.loadBefore) {
                dependencyFlags = ((Map)dependencyConfigurationMap.get((Object)(legacyLoadConfiguration.bootstrap ? PluginDependencyLifeCycle.BOOTSTRAP : PluginDependencyLifeCycle.SERVER))).computeIfAbsent(legacyLoadConfiguration.name, s2 -> EnumSet.noneOf(DependencyFlag.class));
                dependencyFlags.add(DependencyFlag.LOAD_BEFORE);
            }
            for (LegacyDependencyConfiguration legacyDependencyConfiguration : legacyConfiguration.dependencies) {
                dependencyFlags = ((Map)dependencyConfigurationMap.get((Object)(legacyDependencyConfiguration.bootstrap ? PluginDependencyLifeCycle.BOOTSTRAP : PluginDependencyLifeCycle.SERVER))).computeIfAbsent(legacyDependencyConfiguration.name, s2 -> EnumSet.noneOf(DependencyFlag.class));
                dependencyFlags.add(DependencyFlag.DEPENDENCY);
                if (!legacyDependencyConfiguration.required) continue;
                dependencyFlags.add(DependencyFlag.REQUIRED);
            }
            for (Map.Entry entry : dependencyConfigurationMap.entrySet()) {
                Map flagMap = (Map)dependencies.get(entry.getKey());
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    Set flags = (Set)entry2.getValue();
                    DependencyConfiguration.LoadOrder loadOrder = DependencyConfiguration.LoadOrder.OMIT;
                    if (flags.contains((Object)DependencyFlag.LOAD_BEFORE)) {
                        loadOrder = DependencyConfiguration.LoadOrder.AFTER;
                    } else if (flags.contains((Object)DependencyFlag.LOAD_AFTER)) {
                        loadOrder = DependencyConfiguration.LoadOrder.BEFORE;
                    }
                    flagMap.put((String)entry2.getKey(), new DependencyConfiguration(loadOrder, flags.contains((Object)DependencyFlag.REQUIRED), flags.contains((Object)DependencyFlag.DEPENDENCY)));
                }
            }
            value.node(new Object[]{"dependencies"}).set(TYPE_TOKEN.getType(), dependencies);
            return null;
        }).build();
    }

    @ConfigSerializable
    private static class LegacyConfiguration {
        private List<LegacyLoadConfiguration> loadAfter = List.of();
        private List<LegacyLoadConfiguration> loadBefore = List.of();
        private List<LegacyDependencyConfiguration> dependencies = List.of();

        private LegacyConfiguration() {
        }
    }

    @ConfigSerializable
    record LegacyLoadConfiguration(@Required String name, boolean bootstrap) {
    }

    static enum DependencyFlag {
        LOAD_AFTER,
        LOAD_BEFORE,
        REQUIRED,
        DEPENDENCY;

    }

    @ConfigSerializable
    public record LegacyDependencyConfiguration(@Required String name, boolean required, boolean bootstrap) {
    }
}

