/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.strategy.modern;

import com.google.common.collect.Maps;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.logging.LogUtils;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.entrypoint.dependency.MetaDependencyTree;
import io.papermc.paper.plugin.entrypoint.strategy.ProviderConfiguration;
import io.papermc.paper.plugin.entrypoint.strategy.ProviderLoadingStrategy;
import io.papermc.paper.plugin.entrypoint.strategy.modern.LoadOrderTree;
import io.papermc.paper.plugin.provider.PluginProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.plugin.UnknownDependencyException;
import org.slf4j.Logger;

public class ModernPluginLoadingStrategy<T>
implements ProviderLoadingStrategy<T> {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private final ProviderConfiguration<T> configuration;

    public ModernPluginLoadingStrategy(ProviderConfiguration<T> onLoad) {
        this.configuration = onLoad;
    }

    @Override
    public List<ProviderLoadingStrategy.ProviderPair<T>> loadProviders(List<PluginProvider<T>> pluginProviders, MetaDependencyTree dependencyTree) {
        HashMap<String, PluginProviderEntry<T>> providerMap = new HashMap<String, PluginProviderEntry<T>>();
        Map providerMapMirror = Maps.transformValues(providerMap, entry -> entry.provider);
        ArrayList<PluginProvider<T>> validatedProviders = new ArrayList<PluginProvider<T>>();
        for (PluginProvider<T> pluginProvider : pluginProviders) {
            PluginMeta pluginMeta = pluginProvider.getMeta();
            PluginProviderEntry<T> entry2 = new PluginProviderEntry<T>(pluginProvider);
            PluginProviderEntry<T> replacedProvider = providerMap.put(pluginMeta.getName(), entry2);
            if (replacedProvider != null) {
                LOGGER.error(String.format("Ambiguous plugin name '%s' for files '%s' and '%s' in '%s'", pluginMeta.getName(), pluginProvider.getSource(), replacedProvider.provider.getSource(), replacedProvider.provider.getParentSource()));
                this.configuration.onGenericError(replacedProvider.provider);
            }
            for (String extra : pluginMeta.getProvidedPlugins()) {
                PluginProviderEntry<T> replacedExtraProvider = providerMap.putIfAbsent(extra, entry2);
                if (replacedExtraProvider == null) continue;
                LOGGER.warn(String.format("`%s' is provided by both `%s' and `%s'", extra, pluginMeta.getName(), replacedExtraProvider.provider.getMeta().getName()));
            }
        }
        for (PluginProvider<T> pluginProvider : pluginProviders) {
            dependencyTree.add(pluginProvider);
        }
        for (PluginProvider<T> pluginProvider : pluginProviders) {
            PluginMeta pluginMeta = pluginProvider.getMeta();
            List<String> missingDependencies = pluginProvider.validateDependencies(dependencyTree);
            if (missingDependencies.isEmpty()) {
                validatedProviders.add(pluginProvider);
                continue;
            }
            LOGGER.error("Could not load '%s' in '%s'".formatted(pluginProvider.getSource(), pluginProvider.getParentSource()), (Throwable)new UnknownDependencyException(missingDependencies, pluginMeta.getName()));
            providerMap.remove(pluginMeta.getName());
            dependencyTree.remove(pluginProvider);
            this.configuration.onGenericError(pluginProvider);
        }
        LoadOrderTree loadOrderTree = new LoadOrderTree(providerMapMirror, (MutableGraph<String>)GraphBuilder.directed().build());
        for (PluginProvider pluginProvider : validatedProviders) {
            loadOrderTree.add(pluginProvider);
        }
        List<String> list = loadOrderTree.getLoadOrder();
        ArrayList<ProviderLoadingStrategy.ProviderPair<T>> arrayList = new ArrayList<ProviderLoadingStrategy.ProviderPair<T>>();
        for (String providerIdentifier : list) {
            PluginProviderEntry retrievedProviderEntry = (PluginProviderEntry)providerMap.get(providerIdentifier);
            if (retrievedProviderEntry == null || retrievedProviderEntry.provided) continue;
            retrievedProviderEntry.provided = true;
            PluginProvider retrievedProvider = retrievedProviderEntry.provider;
            try {
                Object instance;
                this.configuration.applyContext(retrievedProvider, dependencyTree);
                if (!this.configuration.preloadProvider(retrievedProvider) || !this.configuration.load(retrievedProvider, instance = retrievedProvider.createInstance())) continue;
                arrayList.add(new ProviderLoadingStrategy.ProviderPair(retrievedProvider, instance));
            }
            catch (Throwable ex) {
                LOGGER.error("Could not load plugin '%s' in folder '%s'".formatted(retrievedProvider.getFileName(), retrievedProvider.getParentSource()), ex);
            }
        }
        return arrayList;
    }

    private static class PluginProviderEntry<T> {
        private final PluginProvider<T> provider;
        private boolean provided;

        private PluginProviderEntry(PluginProvider<T> provider) {
            this.provider = provider;
        }
    }
}

