/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.strategy;

import com.google.common.graph.MutableGraph;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.entrypoint.dependency.MetaDependencyTree;
import io.papermc.paper.plugin.entrypoint.strategy.ProviderConfiguration;
import io.papermc.paper.plugin.entrypoint.strategy.ProviderLoadingStrategy;
import io.papermc.paper.plugin.provider.PluginProvider;
import io.papermc.paper.plugin.provider.type.paper.PaperPluginParent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.plugin.UnknownDependencyException;

public class LegacyPluginLoadingStrategy<T>
implements ProviderLoadingStrategy<T> {
    private static final Logger LOGGER = Logger.getLogger("LegacyPluginLoadingStrategy");
    private final ProviderConfiguration<T> configuration;

    public LegacyPluginLoadingStrategy(ProviderConfiguration<T> onLoad) {
        this.configuration = onLoad;
    }

    @Override
    public List<ProviderLoadingStrategy.ProviderPair<T>> loadProviders(List<PluginProvider<T>> providers, MetaDependencyTree dependencyTree) {
        ArrayList<ProviderLoadingStrategy.ProviderPair<T>> javapluginsLoaded = new ArrayList<ProviderLoadingStrategy.ProviderPair<T>>();
        MutableGraph<String> dependencyGraph = dependencyTree.getGraph();
        HashMap<String, PluginProvider<T>> providersToLoad = new HashMap<String, PluginProvider<T>>();
        HashSet<String> loadedPlugins = new HashSet<String>();
        HashMap<String, String> pluginsProvided = new HashMap<String, String>();
        HashMap dependencies = new HashMap();
        HashMap softDependencies = new HashMap();
        for (PluginProvider<T> provider : providers) {
            List loadBeforeSet;
            List dependencySet;
            String removedProvided;
            PluginMeta configuration = provider.getMeta();
            PluginProvider<T> replacedProvider = providersToLoad.put(configuration.getName(), provider);
            dependencyTree.addDirectDependency(configuration.getName());
            if (replacedProvider != null) {
                LOGGER.severe(String.format("Ambiguous plugin name `%s' for files `%s' and `%s' in `%s'", configuration.getName(), provider.getSource(), replacedProvider.getSource(), replacedProvider.getParentSource()));
            }
            if ((removedProvided = (String)pluginsProvided.remove(configuration.getName())) != null) {
                LOGGER.warning(String.format("Ambiguous plugin name `%s'. It is also provided by `%s'", configuration.getName(), removedProvided));
            }
            for (Object provided : configuration.getProvidedPlugins()) {
                PluginProvider pluginProvider = (PluginProvider)providersToLoad.get(provided);
                if (pluginProvider != null) {
                    LOGGER.warning(String.format("`%s provides `%s' while this is also the name of `%s' in `%s'", provider.getSource(), provided, pluginProvider.getSource(), provider.getParentSource()));
                    continue;
                }
                String replacedPlugin = pluginsProvided.put((String)provided, configuration.getName());
                dependencyTree.addDirectDependency((String)provided);
                if (replacedPlugin == null) continue;
                LOGGER.warning(String.format("`%s' is provided by both `%s' and `%s'", provided, configuration.getName(), replacedPlugin));
            }
            List softDependencySet = provider.getMeta().getPluginSoftDependencies();
            if (softDependencySet != null && !softDependencySet.isEmpty()) {
                Object provided;
                if (softDependencies.containsKey(configuration.getName())) {
                    ((Collection)softDependencies.get(configuration.getName())).addAll(softDependencySet);
                } else {
                    softDependencies.put(configuration.getName(), new LinkedList(softDependencySet));
                }
                provided = softDependencySet.iterator();
                while (provided.hasNext()) {
                    String depend = (String)provided.next();
                    dependencyGraph.putEdge((Object)configuration.getName(), (Object)depend);
                }
            }
            if ((dependencySet = provider.getMeta().getPluginDependencies()) != null && !dependencySet.isEmpty()) {
                dependencies.put(configuration.getName(), new LinkedList(dependencySet));
                for (String depend : dependencySet) {
                    dependencyGraph.putEdge((Object)configuration.getName(), (Object)depend);
                }
            }
            if ((loadBeforeSet = provider.getMeta().getLoadBeforePlugins()) == null || loadBeforeSet.isEmpty()) continue;
            for (String loadBeforeTarget : loadBeforeSet) {
                if (softDependencies.containsKey(loadBeforeTarget)) {
                    ((Collection)softDependencies.get(loadBeforeTarget)).add(configuration.getName());
                } else {
                    LinkedList<String> shortSoftDependency = new LinkedList<String>();
                    shortSoftDependency.add(configuration.getName());
                    softDependencies.put(loadBeforeTarget, shortSoftDependency);
                }
                dependencyGraph.putEdge((Object)loadBeforeTarget, (Object)configuration.getName());
            }
        }
        while (!providersToLoad.isEmpty()) {
            Object loadedPlugin;
            PluginProvider file;
            Map.Entry entry;
            boolean missingDependency = true;
            Iterator providerIterator = providersToLoad.entrySet().iterator();
            while (providerIterator.hasNext()) {
                entry = providerIterator.next();
                String providerIdentifier = (String)entry.getKey();
                if (dependencies.containsKey(providerIdentifier)) {
                    Iterator dependencyIterator = ((Collection)dependencies.get(providerIdentifier)).iterator();
                    HashSet<String> missingHardDependencies = new HashSet<String>(((Collection)dependencies.get(providerIdentifier)).size());
                    while (dependencyIterator.hasNext()) {
                        String dependency = (String)dependencyIterator.next();
                        if (loadedPlugins.contains(dependency)) {
                            dependencyIterator.remove();
                            continue;
                        }
                        if (providersToLoad.containsKey(dependency) || pluginsProvided.containsKey(dependency)) continue;
                        missingHardDependencies.add(dependency);
                    }
                    if (!missingHardDependencies.isEmpty()) {
                        missingDependency = false;
                        providerIterator.remove();
                        pluginsProvided.values().removeIf(s2 -> s2.equals(providerIdentifier));
                        softDependencies.remove(providerIdentifier);
                        dependencies.remove(providerIdentifier);
                        LOGGER.log(Level.SEVERE, "Could not load '" + String.valueOf(((PluginProvider)entry.getValue()).getSource()) + "' in folder '" + String.valueOf(((PluginProvider)entry.getValue()).getParentSource()) + "'", (Throwable)new UnknownDependencyException(missingHardDependencies, providerIdentifier));
                    }
                    if (dependencies.containsKey(providerIdentifier) && ((Collection)dependencies.get(providerIdentifier)).isEmpty()) {
                        dependencies.remove(providerIdentifier);
                    }
                }
                if (softDependencies.containsKey(providerIdentifier)) {
                    Iterator softDependencyIterator = ((Collection)softDependencies.get(providerIdentifier)).iterator();
                    while (softDependencyIterator.hasNext()) {
                        String softDependency = (String)softDependencyIterator.next();
                        if (providersToLoad.containsKey(softDependency) || pluginsProvided.containsKey(softDependency)) continue;
                        softDependencyIterator.remove();
                    }
                    if (((Collection)softDependencies.get(providerIdentifier)).isEmpty()) {
                        softDependencies.remove(providerIdentifier);
                    }
                }
                if (dependencies.containsKey(providerIdentifier) || softDependencies.containsKey(providerIdentifier) || !providersToLoad.containsKey(providerIdentifier)) continue;
                file = (PluginProvider)providersToLoad.get(providerIdentifier);
                providerIterator.remove();
                pluginsProvided.values().removeIf(s2 -> s2.equals(providerIdentifier));
                missingDependency = false;
                try {
                    this.configuration.applyContext(file, dependencyTree);
                    loadedPlugin = file.createInstance();
                    this.warnIfPaperPlugin(file);
                    if (!this.configuration.load(file, loadedPlugin)) continue;
                    loadedPlugins.add(file.getMeta().getName());
                    loadedPlugins.addAll(file.getMeta().getProvidedPlugins());
                    javapluginsLoaded.add(new ProviderLoadingStrategy.ProviderPair(file, loadedPlugin));
                }
                catch (Throwable ex) {
                    LOGGER.log(Level.SEVERE, "Could not load '" + String.valueOf(file.getSource()) + "' in folder '" + String.valueOf(file.getParentSource()) + "'", ex);
                }
            }
            if (!missingDependency) continue;
            providerIterator = providersToLoad.entrySet().iterator();
            while (providerIterator.hasNext()) {
                entry = providerIterator.next();
                String plugin = (String)entry.getKey();
                if (dependencies.containsKey(plugin)) continue;
                softDependencies.remove(plugin);
                missingDependency = false;
                file = (PluginProvider)entry.getValue();
                providerIterator.remove();
                try {
                    this.configuration.applyContext(file, dependencyTree);
                    loadedPlugin = file.createInstance();
                    this.warnIfPaperPlugin(file);
                    if (!this.configuration.load(file, loadedPlugin)) break;
                    loadedPlugins.add(file.getMeta().getName());
                    loadedPlugins.addAll(file.getMeta().getProvidedPlugins());
                    javapluginsLoaded.add(new ProviderLoadingStrategy.ProviderPair(file, loadedPlugin));
                    break;
                }
                catch (Throwable ex) {
                    LOGGER.log(Level.SEVERE, "Could not load '" + String.valueOf(file.getSource()) + "' in folder '" + String.valueOf(file.getParentSource()) + "'", ex);
                }
            }
            if (!missingDependency) continue;
            softDependencies.clear();
            dependencies.clear();
            Iterator failedPluginIterator = providersToLoad.values().iterator();
            while (failedPluginIterator.hasNext()) {
                PluginProvider file2 = (PluginProvider)failedPluginIterator.next();
                failedPluginIterator.remove();
                LOGGER.log(Level.SEVERE, "Could not load '" + String.valueOf(file2.getSource()) + "' in folder '" + String.valueOf(file2.getParentSource()) + "': circular dependency detected");
            }
        }
        return javapluginsLoaded;
    }

    private void warnIfPaperPlugin(PluginProvider<T> provider) {
        if (provider instanceof PaperPluginParent.PaperServerPluginProvider) {
            provider.getLogger().warn("Loading Paper plugin in the legacy plugin loading logic. This is not recommended and may introduce some differences into load order. It's highly recommended you move away from this if you are wanting to use Paper plugins.");
        }
    }
}

