/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.classloader.group;

import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import io.papermc.paper.plugin.provider.classloader.PluginClassLoaderGroup;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class SimpleListPluginClassLoaderGroup
implements PluginClassLoaderGroup {
    private static final boolean DISABLE_CLASS_PRIORITIZATION = Boolean.getBoolean("Paper.DisableClassPrioritization");
    protected final List<ConfiguredPluginClassLoader> classloaders;

    protected SimpleListPluginClassLoaderGroup() {
        this(new CopyOnWriteArrayList<ConfiguredPluginClassLoader>());
    }

    protected SimpleListPluginClassLoaderGroup(List<ConfiguredPluginClassLoader> classloaders) {
        this.classloaders = classloaders;
    }

    @Nullable
    public Class<?> getClassByName(String name, boolean resolve, ConfiguredPluginClassLoader requester) {
        if (!DISABLE_CLASS_PRIORITIZATION) {
            try {
                return this.lookupClass(name, false, requester);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (ConfiguredPluginClassLoader loader : this.classloaders) {
            try {
                return this.lookupClass(name, resolve, loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    protected Class<?> lookupClass(String name, boolean resolve, ConfiguredPluginClassLoader current) throws ClassNotFoundException {
        return current.loadClass(name, resolve, false, true);
    }

    public void remove(ConfiguredPluginClassLoader configuredPluginClassLoader) {
        this.classloaders.remove(configuredPluginClassLoader);
    }

    public void add(ConfiguredPluginClassLoader configuredPluginClassLoader) {
        this.classloaders.add(configuredPluginClassLoader);
    }

    public List<ConfiguredPluginClassLoader> getClassLoaders() {
        return this.classloaders;
    }

    public String toString() {
        return "SimpleListPluginClassLoaderGroup{classloaders=" + String.valueOf(this.classloaders) + "}";
    }
}

