/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.classloader;

import io.papermc.paper.pluginremap.reflect.ReflectionRemapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class BytecodeModifyingURLClassLoader
extends URLClassLoader {
    private static final Object MISSING_MANIFEST;
    private final Function<byte[], byte[]> modifier;
    private final Map<String, Object> manifests = new ConcurrentHashMap<String, Object>();

    public BytecodeModifyingURLClassLoader(URL[] urls, ClassLoader parent, Function<byte[], byte[]> modifier) {
        super(urls, parent);
        this.modifier = modifier;
    }

    public BytecodeModifyingURLClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, (byte[] bytes) -> {
            ClassReader classReader = new ClassReader(bytes);
            ClassWriter classWriter = new ClassWriter(classReader, 0);
            ClassVisitor visitor = ReflectionRemapper.visitor((ClassVisitor)classWriter);
            if (visitor == classWriter) {
                return bytes;
            }
            classReader.accept(visitor, 0);
            return classWriter.toByteArray();
        });
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result;
        String path = name.replace('.', '/').concat(".class");
        URL url = this.findResource(path);
        if (url != null) {
            try {
                result = this.defineClass(name, url);
            }
            catch (IOException e2) {
                throw new ClassNotFoundException(name, e2);
            }
        } else {
            result = null;
        }
        if (result == null) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    private Class<?> defineClass(String name, URL url) throws IOException {
        byte[] bytes;
        block11: {
            URL jarUrl;
            Manifest man;
            String pkgname;
            int i2 = name.lastIndexOf(46);
            if (i2 != -1 && this.getAndVerifyPackage(pkgname = name.substring(0, i2), man = this.manifestFor(url), jarUrl = URI.create(BytecodeModifyingURLClassLoader.jarName(url)).toURL()) == null) {
                try {
                    if (man != null) {
                        this.definePackage(pkgname, man, jarUrl);
                    } else {
                        this.definePackage(pkgname, null, null, null, null, null, null, null);
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (this.getAndVerifyPackage(pkgname, man, jarUrl) != null) break block11;
                    throw new AssertionError((Object)("Cannot find package " + pkgname));
                }
            }
        }
        try (InputStream is = url.openStream();){
            bytes = is.readAllBytes();
        }
        byte[] modified = this.modifier.apply(bytes);
        CodeSource cs = new CodeSource(url, (CodeSigner[])null);
        return this.defineClass(name, modified, 0, modified.length, cs);
    }

    private Package getAndVerifyPackage(String pkgname, Manifest man, URL url) {
        Package pkg = this.getDefinedPackage(pkgname);
        if (pkg != null) {
            if (pkg.isSealed()) {
                if (!pkg.isSealed(url)) {
                    throw new SecurityException("sealing violation: package " + pkgname + " is sealed");
                }
            } else if (man != null && this.isSealed(pkgname, man)) {
                throw new SecurityException("sealing violation: can't seal package " + pkgname + ": already loaded");
            }
        }
        return pkg;
    }

    private boolean isSealed(String name, Manifest man) {
        Attributes attr = man.getAttributes(name.replace('.', '/').concat("/"));
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    private @Nullable Manifest manifestFor(URL url) throws IOException {
        Manifest man = null;
        if (url.getProtocol().equals("jar")) {
            try {
                Object computedManifest = this.manifests.computeIfAbsent(BytecodeModifyingURLClassLoader.jarName(url), $ -> {
                    try {
                        Manifest m2 = ((JarURLConnection)url.openConnection()).getManifest();
                        return Objects.requireNonNullElse(m2, MISSING_MANIFEST);
                    }
                    catch (IOException e2) {
                        throw new UncheckedIOException(e2);
                    }
                });
                if (computedManifest instanceof Manifest) {
                    Manifest found;
                    man = found = (Manifest)computedManifest;
                }
            }
            catch (UncheckedIOException e2) {
                throw e2.getCause();
            }
            catch (IllegalArgumentException e3) {
                throw new IOException(e3);
            }
        }
        return man;
    }

    private static String jarName(URL sourceUrl) {
        int exclamationIdx = sourceUrl.getPath().lastIndexOf(33);
        if (exclamationIdx != -1) {
            return sourceUrl.getPath().substring(0, exclamationIdx);
        }
        throw new IllegalArgumentException("Could not find jar for URL " + String.valueOf(sourceUrl));
    }

    static {
        ClassLoader.registerAsParallelCapable();
        MISSING_MANIFEST = new Object();
    }
}

