/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datapack;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datapack.Datapack;
import io.papermc.paper.datapack.DatapackRegistrar;
import io.papermc.paper.datapack.DiscoveredDatapack;
import io.papermc.paper.datapack.PaperDiscoveredDatapack;
import io.papermc.paper.datapack.PluginPackSource;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.lifecycle.event.registrar.PaperRegistrar;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.VanillaPackResourcesBuilder;
import net.minecraft.server.packs.repository.PackDetector;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackSourceFolder;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.ForbiddenSymlinkInfo;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@NullMarked
public class PaperDatapackRegistrar
implements PaperRegistrar<BootstrapContext>,
DatapackRegistrar {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private final PackDetector<ResourcePackLoader.c> detector;
    public final Map<String, ResourcePackLoader> discoveredPacks;
    private @Nullable BootstrapContext owner;

    public PaperDatapackRegistrar(DirectoryValidator symlinkValidator, Map<String, ResourcePackLoader> discoveredPacks) {
        this.detector = new ResourcePackSourceFolder.a(symlinkValidator);
        this.discoveredPacks = discoveredPacks;
    }

    @Override
    public void setCurrentContext(@Nullable BootstrapContext owner) {
        this.owner = owner;
    }

    public boolean hasPackDiscovered(String name) {
        return this.discoveredPacks.containsKey(name);
    }

    public DiscoveredDatapack getDiscoveredPack(String name) {
        if (!this.hasPackDiscovered(name)) {
            throw new NoSuchElementException("No pack with id " + name + " was discovered");
        }
        return new PaperDiscoveredDatapack(this.discoveredPacks.get(name));
    }

    public boolean removeDiscoveredPack(String name) {
        return this.discoveredPacks.remove(name) != null;
    }

    public @Unmodifiable Map<String, DiscoveredDatapack> getDiscoveredPacks() {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)this.discoveredPacks.size());
        for (Map.Entry<String, ResourcePackLoader> entry : this.discoveredPacks.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)new PaperDiscoveredDatapack(entry.getValue()));
        }
        return builder.buildOrThrow();
    }

    public @Nullable DiscoveredDatapack discoverPack(URI uri, String id, Consumer<DatapackRegistrar.Configurer> configurer) throws IOException {
        Preconditions.checkState((this.owner != null ? 1 : 0) != 0, (Object)"Discovering packs is not supported outside of lifecycle events");
        return this.discoverPack(this.owner.getPluginMeta(), uri, id, configurer);
    }

    public @Nullable DiscoveredDatapack discoverPack(Path path, String id, Consumer<DatapackRegistrar.Configurer> configurer) throws IOException {
        Preconditions.checkState((this.owner != null ? 1 : 0) != 0, (Object)"Discovering packs is not supported outside of lifecycle events");
        return this.discoverPack(this.owner.getPluginMeta(), path, id, configurer);
    }

    public @Nullable DiscoveredDatapack discoverPack(PluginMeta pluginMeta, URI uri, String id, Consumer<DatapackRegistrar.Configurer> configurer) throws IOException {
        return this.discoverPack(pluginMeta, VanillaPackResourcesBuilder.a(uri), id, configurer);
    }

    public @Nullable DiscoveredDatapack discoverPack(PluginMeta pluginMeta, Path path, String id, Consumer<DatapackRegistrar.Configurer> configurer) throws IOException {
        Preconditions.checkState((this.owner != null ? 1 : 0) != 0, (Object)"Discovering packs is not supported outside of lifecycle events");
        ArrayList<ForbiddenSymlinkInfo> badLinks = new ArrayList<ForbiddenSymlinkInfo>();
        ResourcePackLoader.c resourcesSupplier = this.detector.a(path, badLinks);
        if (!badLinks.isEmpty()) {
            LOGGER.warn("Ignoring potential pack entry: {}", (Object)ContentValidationException.a(path, badLinks));
            return null;
        }
        if (resourcesSupplier != null) {
            String packId = pluginMeta.getName() + "/" + id;
            ConfigurerImpl configurerImpl = new ConfigurerImpl((Component)Component.text((String)packId));
            configurer.accept(configurerImpl);
            PackLocationInfo locInfo = new PackLocationInfo(packId, PaperAdventure.asVanilla(configurerImpl.title), PluginPackSource.INSTANCE, Optional.empty());
            ResourcePackLoader pack = ResourcePackLoader.a(locInfo, resourcesSupplier, EnumResourcePackType.b, new PackSelectionConfig(configurerImpl.autoEnableOnServerStart, configurerImpl.position, configurerImpl.fixedPosition));
            if (pack != null) {
                this.discoveredPacks.put(packId, pack);
                return new PaperDiscoveredDatapack(pack);
            }
            return null;
        }
        LOGGER.info("Found non-pack entry '{}', ignoring", (Object)path);
        return null;
    }

    static final class ConfigurerImpl
    implements DatapackRegistrar.Configurer {
        private Component title;
        private boolean autoEnableOnServerStart = false;
        private boolean fixedPosition = false;
        private ResourcePackLoader.Position position = ResourcePackLoader.Position.a;

        ConfigurerImpl(Component title) {
            this.title = title;
        }

        public DatapackRegistrar.Configurer title(Component title) {
            this.title = title;
            return this;
        }

        public DatapackRegistrar.Configurer autoEnableOnServerStart(boolean autoEnableOnServerStart) {
            this.autoEnableOnServerStart = autoEnableOnServerStart;
            return this;
        }

        public DatapackRegistrar.Configurer position(boolean fixed, Datapack.Position position) {
            this.fixedPosition = fixed;
            this.position = switch (position) {
                default -> throw new MatchException(null, null);
                case Datapack.Position.TOP -> ResourcePackLoader.Position.a;
                case Datapack.Position.BOTTOM -> ResourcePackLoader.Position.b;
            };
            return this;
        }
    }
}

